/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.util.ActionBuilder;
import org.openhab.core.automation.util.ConditionBuilder;
import org.openhab.core.automation.util.ModuleBuilder;
import org.openhab.core.automation.util.TriggerBuilder;
import org.openhab.core.i18n.I18nUtil;
import org.openhab.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class ModuleI18nUtil {
    private final TranslationProvider i18nProvider;

    public ModuleI18nUtil(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    public <T extends Module> List<T> getLocalizedModules(List<T> modules, Bundle bundle, String uid, String prefix, @Nullable Locale locale) {
        ArrayList<Module> lmodules = new ArrayList<Module>();
        for (Module module : modules) {
            String description;
            String label;
            @Nullable Module lmodule = this.createLocalizedModule(module, label = this.getModuleLabel(bundle, uid, module.getId(), module.getLabel(), prefix, locale), description = this.getModuleDescription(bundle, uid, module.getId(), module.getDescription(), prefix, locale));
            lmodules.add(lmodule == null ? module : lmodule);
        }
        return lmodules;
    }

    /*
     * WARNING - void declaration
     */
    private <T extends Module> @Nullable T createLocalizedModule(T module, @Nullable String label, @Nullable String description) {
        T t = module;
        if (t instanceof Action) {
            void action;
            Action action2 = (Action)t;
            Action cfr_ignored_0 = (Action)t;
            return (T)this.createLocalizedAction((Action)action, label, description);
        }
        T t2 = module;
        if (t2 instanceof Condition) {
            void condition;
            Condition condition2 = (Condition)t2;
            Condition cfr_ignored_1 = (Condition)t2;
            return (T)this.createLocalizedCondition((Condition)condition, label, description);
        }
        T t3 = module;
        if (t3 instanceof Trigger) {
            void trigger;
            Trigger trigger2 = (Trigger)t3;
            Trigger cfr_ignored_2 = (Trigger)t3;
            return (T)this.createLocalizedTrigger((Trigger)trigger, label, description);
        }
        return null;
    }

    private Trigger createLocalizedTrigger(Trigger module, @Nullable String label, @Nullable String description) {
        return ((TriggerBuilder)((TriggerBuilder)ModuleBuilder.createTrigger(module).withLabel(label)).withDescription(description)).build();
    }

    private Condition createLocalizedCondition(Condition module, @Nullable String label, @Nullable String description) {
        return ((ConditionBuilder)((ConditionBuilder)ModuleBuilder.createCondition(module).withLabel(label)).withDescription(description)).build();
    }

    private Action createLocalizedAction(Action module, @Nullable String label, @Nullable String description) {
        return ((ActionBuilder)((ActionBuilder)ModuleBuilder.createAction(module).withLabel(label)).withDescription(description)).build();
    }

    private @Nullable String getModuleLabel(Bundle bundle, String uid, String moduleName, @Nullable String defaultLabel, String prefix, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> this.inferModuleKey(prefix, uid, moduleName, "label"));
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    private @Nullable String getModuleDescription(Bundle bundle, String uid, String moduleName, @Nullable String defaultDescription, String prefix, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultDescription, () -> this.inferModuleKey(prefix, uid, moduleName, "description"));
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    private String inferModuleKey(String prefix, String uid, String moduleName, String lastSegment) {
        return prefix + uid + ".input." + moduleName + "." + lastSegment;
    }
}

