/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class IdentifierNode
extends Node {
    private static final String ASTERISK = "*".intern();
    public String name;
    public ReferenceValue ref;
    int authOrigTypeToken = -1;

    public IdentifierNode(String name, int pos) {
        this(name, true, pos);
    }

    public IdentifierNode(String name, boolean intern, int pos) {
        super(pos);
        if (intern) {
            this.name = name.intern();
        } else {
            assert (name.intern() == name);
            this.name = name;
        }
        if (name == ASTERISK) {
            this.setAny(true);
        }
    }

    public void setOrigTypeToken(int token) {
        this.authOrigTypeToken = token;
    }

    public int getOrigTypeToken() {
        return this.authOrigTypeToken;
    }

    @Override
    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    @Override
    public boolean isAttribute() {
        return true;
    }

    @Override
    public boolean isIdentifier() {
        return true;
    }

    @Override
    public boolean hasAttribute(String name) {
        assert (name.intern() == name);
        return this.name == name;
    }

    @Override
    public String toString() {
        return "Identifier";
    }

    public String toIdentifierString() {
        return this.name;
    }

    public void setAttr(boolean is_attr) {
        this.flags = is_attr ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    public boolean isAttr() {
        return (this.flags & 2) != 0;
    }

    public void setAny(boolean is_any) {
        this.flags = is_any ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }

    public boolean isAny() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isLValue() {
        return true;
    }
}

