/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

import macromedia.asc.util.CompilerProfiler;

public class ProfileController {
    static CompilerProfiler m_profiler = null;
    static boolean initialization_failed = false;

    public static void setProfiler(String profiler_class) {
        if (null == m_profiler) {
            try {
                m_profiler = (CompilerProfiler)Class.forName(profiler_class).newInstance();
                m_profiler.initialize();
            }
            catch (Throwable profiler_exception) {
                initialization_failed = true;
                System.err.println("Unable to instantiate profiler " + profiler_class + " due to:");
                profiler_exception.printStackTrace();
            }
        }
    }

    public static void startCPUProfiling(boolean use_sampling_mode) {
        if (m_profiler != null) {
            m_profiler.startCPUProfiling(use_sampling_mode);
        }
    }

    public static void startAllocationRecording() {
        if (m_profiler != null) {
            m_profiler.startAllocationRecording(10, 4096);
        }
    }

    public static void newPhase(String description) {
        if (m_profiler != null) {
            m_profiler.advanceGeneration(description);
        }
    }

    public static String captureSnapshot() {
        String result = new String();
        if (m_profiler != null) {
            result = m_profiler.captureSnapshot();
        }
        return result;
    }

    public static boolean annotateSnapshot(String snapshot_file, String annotation) {
        boolean result = false;
        if (m_profiler != null && snapshot_file != null) {
            result = m_profiler.annotateSnapshot(snapshot_file, annotation);
        }
        return result;
    }

    public static boolean isInitialized() {
        return m_profiler != null;
    }
}

