//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cGameCore.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cGameCore_hpp
#define cGameCore_hpp
//==============================================================================
// Includes
#include <string>
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cDisplayManager;
class cMainMenu;
class cGameMode;
class cOptions;
//==============================================================================

//==============================================================================
//! Game core
//------------------------------------------------------------------------------
class cGameCore
{
	friend class cGameView;
	
	// Constructor & Destructor
	public:
		//! Constructor
		cGameCore (void);
		//! Destructor
		~cGameCore (void);
	
	// Public methods
	public:
		//! Initialize the game
		void Initialize (int argc, char **argv);
		//! Run the game
		void Run (void);
	
		/*void BeginFrame (void);
		void EndFrame (void);*/
	
		string GetDataDir (void) const { return mDataDir; };
		string GetOptionsFile (void) const { return mOptionsFile; };
		
	// Private methods
	private:
		void CopyFile (string src, string dst);

	// Member variables
	private:
		bool mRunning;			//!< Is the game running
	
		cMainMenu *mpMainMenu;
		cGameMode *mpGameMode;
		cDisplayManager &mDisplayManager;
		cOptions &mOptions;
	
		string mDataDir;
		string mOptionsFile;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cGameCore_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
