/* progress_bar.c

    icdprog - an open source PIC programmer for use with the Microchip ICD(1)
    Copyright (C) 2001-2004  Geir Thomassen.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/


#include <stdio.h>
#include "icdprog.h"
#include "progress_bar.h"

int n_tot;
int n_cur;

void progress_init(int n_total)
{
	setbuf(stdout,NULL);
	
	if (n_total == 1
)    /* Kludge to get a progress bar for a total of 1 */
	    n_tot = n_total+1;
	else
	    n_tot = n_total;
	    
	n_cur = 0;
}

void progress()
{
	static int cur_hash;
	int i, num_hash;

	num_hash = (((n_cur) * (N_STEP))) / (n_tot - 1);

	if((num_hash != cur_hash) || (n_cur == 0)) {

		if(n_cur != 0) {
			for(i=0;i<N_STEP + 7;i++) {
				putchar('\b');
			}
		}

		for(i=0;i<num_hash;i++) {
			putchar('#');
		}

		for(;i<N_STEP;i++) {
			putchar('-');
		}

		printf(" (%3d%%)",(n_cur*100)/(n_tot - 1));

		cur_hash = num_hash;
	}

	n_cur++;
}

void progress_end()
{
	printf("\n");
	setlinebuf(stdout);
}
