/*
 * Bitbucket API
 *
 * Code against the Bitbucket API to automate simple tasks, embed Bitbucket data into your own site, build mobile or desktop apps, or even add custom UI add-ons into Bitbucket itself using the Connect framework.
 *
 * API version: 2.0
 * Contact: support@bitbucket.org
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package bitbucket

import (
	"encoding/json"
)

// ReportData A key-value element that will be displayed along with the report.
type ReportData struct {
	// The type of data contained in the value field. If not provided, then the value will be detected as a boolean, number or string.
	Type *string `json:"type,omitempty"`
	// A string describing what this data field represents.
	Title *string `json:"title,omitempty"`
	// The value of the data element.
	Value *map[string]interface{} `json:"value,omitempty"`
}

// NewReportData instantiates a new ReportData object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewReportData() *ReportData {
	this := ReportData{}
	return &this
}

// NewReportDataWithDefaults instantiates a new ReportData object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewReportDataWithDefaults() *ReportData {
	this := ReportData{}
	return &this
}

// GetType returns the Type field value if set, zero value otherwise.
func (o *ReportData) GetType() string {
	if o == nil || o.Type == nil {
		var ret string
		return ret
	}
	return *o.Type
}

// GetTypeOk returns a tuple with the Type field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ReportData) GetTypeOk() (*string, bool) {
	if o == nil || o.Type == nil {
		return nil, false
	}
	return o.Type, true
}

// HasType returns a boolean if a field has been set.
func (o *ReportData) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

// SetType gets a reference to the given string and assigns it to the Type field.
func (o *ReportData) SetType(v string) {
	o.Type = &v
}

// GetTitle returns the Title field value if set, zero value otherwise.
func (o *ReportData) GetTitle() string {
	if o == nil || o.Title == nil {
		var ret string
		return ret
	}
	return *o.Title
}

// GetTitleOk returns a tuple with the Title field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ReportData) GetTitleOk() (*string, bool) {
	if o == nil || o.Title == nil {
		return nil, false
	}
	return o.Title, true
}

// HasTitle returns a boolean if a field has been set.
func (o *ReportData) HasTitle() bool {
	if o != nil && o.Title != nil {
		return true
	}

	return false
}

// SetTitle gets a reference to the given string and assigns it to the Title field.
func (o *ReportData) SetTitle(v string) {
	o.Title = &v
}

// GetValue returns the Value field value if set, zero value otherwise.
func (o *ReportData) GetValue() map[string]interface{} {
	if o == nil || o.Value == nil {
		var ret map[string]interface{}
		return ret
	}
	return *o.Value
}

// GetValueOk returns a tuple with the Value field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ReportData) GetValueOk() (*map[string]interface{}, bool) {
	if o == nil || o.Value == nil {
		return nil, false
	}
	return o.Value, true
}

// HasValue returns a boolean if a field has been set.
func (o *ReportData) HasValue() bool {
	if o != nil && o.Value != nil {
		return true
	}

	return false
}

// SetValue gets a reference to the given map[string]interface{} and assigns it to the Value field.
func (o *ReportData) SetValue(v map[string]interface{}) {
	o.Value = &v
}

func (o ReportData) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Type != nil {
		toSerialize["type"] = o.Type
	}
	if o.Title != nil {
		toSerialize["title"] = o.Title
	}
	if o.Value != nil {
		toSerialize["value"] = o.Value
	}
	return json.Marshal(toSerialize)
}

type NullableReportData struct {
	value *ReportData
	isSet bool
}

func (v NullableReportData) Get() *ReportData {
	return v.value
}

func (v *NullableReportData) Set(val *ReportData) {
	v.value = val
	v.isSet = true
}

func (v NullableReportData) IsSet() bool {
	return v.isSet
}

func (v *NullableReportData) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableReportData(val *ReportData) *NullableReportData {
	return &NullableReportData{value: val, isSet: true}
}

func (v NullableReportData) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableReportData) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
