library ieee;
use ieee.fixed_pkg.all;
use ieee.std_logic_1164.all;

package pacote_aux is

	-- -------------------------- Defini��es de constantes --------------------------
	constant parte_inteira     : integer := 3;
	constant parte_fracionaria : integer := -12;
	constant tamanho           : integer := parte_inteira - parte_fracionaria + 1;

	constant vec_zero      : std_logic_vector(tamanho - 1 downto 0) := (others => '0');
	constant vec_um        : std_logic_vector(tamanho - 1 downto 0) := (others => '1');
	constant vec_lsb       : std_logic_vector(tamanho - 1 downto 0) := (0 => '1', others => '0');
	constant vec_msb       : std_logic_vector(tamanho - 1 downto 0) := (tamanho - 1 => '1', others => '0');
	constant vec_msb_m_lsb : std_logic_vector(tamanho - 1 downto 0) := (tamanho - 1 => '0', others => '1');

	constant s_fixo_max  : sfixed(parte_inteira downto parte_fracionaria) := to_sfixed(vec_msb_m_lsb, parte_inteira, parte_fracionaria);
	constant s_fixo_min  : sfixed(parte_inteira downto parte_fracionaria) := to_sfixed(vec_msb, parte_inteira, parte_fracionaria);
	constant s_fixo_lsb  : sfixed(parte_inteira downto parte_fracionaria) := to_sfixed(vec_lsb, parte_inteira, parte_fracionaria);
	constant s_fixo_msb  : sfixed(parte_inteira downto parte_fracionaria) := to_sfixed(vec_msb, parte_inteira, parte_fracionaria);
	constant s_fixo_zero : sfixed(parte_inteira downto parte_fracionaria) := to_sfixed(vec_zero, parte_inteira, parte_fracionaria);

	constant u_fixo_min : ufixed(parte_inteira downto parte_fracionaria) := to_ufixed(vec_zero, parte_inteira, parte_fracionaria);
	constant u_fixo_max : ufixed(parte_inteira downto parte_fracionaria) := to_ufixed(vec_um, parte_inteira, parte_fracionaria);
	constant u_fixo_lsb : ufixed(parte_inteira downto parte_fracionaria) := to_ufixed(vec_lsb, parte_inteira, parte_fracionaria);
	constant u_fixo_msb : ufixed(parte_inteira downto parte_fracionaria) := to_ufixed(vec_msb, parte_inteira, parte_fracionaria);

	-- ----------------------------- Defini��es de tipos ----------------------------
	subtype s_fixo is sfixed(parte_inteira downto parte_fracionaria);
	subtype u_fixo is ufixed(parte_inteira downto parte_fracionaria);

	type vec_s_fixo is array (integer range <>) of s_fixo;
	type vec_u_fixo is array (integer range <>) of u_fixo;
	type vec_inteiro is array (integer range <>) of integer;

	type mat_s_fixo is array(integer range <>, integer range<>) of s_fixo;
	type mat_u_fixo is array(integer range <>, integer range<>) of u_fixo;

	-- ---------------------------------- Dataset ----------------------------------
	constant amostras_treino   : integer := 117;
	constant amostras_teste    : integer := 33;
	constant n_classes         : integer := 3;
	constant n_caracteristicas : integer := 4;

	constant maior_por_caracteristica : vec_s_fixo(4 - 1 downto 0) := (0=>to_sfixed(7.7, s_fixo_min), 1=>to_sfixed(4.2, s_fixo_min), 2=>to_sfixed(6.7, s_fixo_min), 3=>to_sfixed(2.5, s_fixo_min));
	constant menor_por_caracteristica : vec_s_fixo(4 - 1 downto 0) := (0=>to_sfixed(4.3, s_fixo_min), 1=>to_sfixed(2.0, s_fixo_min), 2=>to_sfixed(1.1, s_fixo_min), 3=>to_sfixed(0.1, s_fixo_min));

	-- ---------------------------------- x_treino ----------------------------------
	constant x_treino : mat_s_fixo(amostras_treino - 1 downto 0, n_caracteristicas - 1 downto 0) := (
                                                                                                       0   => (0 => to_sfixed(0.14705882352941174, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6363636363636362, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.08928571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       1   => (0 => to_sfixed(0.029411764705882505, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5454545454545455, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.035714285714285705, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       2   => (0 => to_sfixed(0.588235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.22727272727272727, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6964285714285715, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.75, parte_inteira, parte_fracionaria)),
                                                                                                       3   => (0 => to_sfixed(0.6176470588235295, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5454545454545455, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6071428571428572, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5833333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       4   => (0 => to_sfixed(0.26470588235294124, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6818181818181818, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.07142857142857141, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       5   => (0 => to_sfixed(0.2058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.7272727272727273, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.05357142857142854, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       6   => (0 => to_sfixed(0.26470588235294124, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.9545454545454543, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.07142857142857141, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.0, parte_inteira, parte_fracionaria)),
                                                                                                       7   => (0 => to_sfixed(0.4411764705882352, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.31818181818181823, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7142857142857143, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.75, parte_inteira, parte_fracionaria)),
                                                                                                       8   => (0 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6363636363636362, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6071428571428572, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.625, parte_inteira, parte_fracionaria)),
                                                                                                       9   => (0 => to_sfixed(0.7058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6428571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5833333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       10  => (0 => to_sfixed(0.323529411764706, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.8636363636363635, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.035714285714285705, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.12500000000000003, parte_inteira, parte_fracionaria)),
                                                                                                       11  => (0 => to_sfixed(0.323529411764706, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.7727272727272727, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.07142857142857141, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       12  => (0 => to_sfixed(0.35294117647058826, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.18181818181818177, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.46428571428571436, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.375, parte_inteira, parte_fracionaria)),
                                                                                                       13  => (0 => to_sfixed(0.588235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.36363636363636354, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7142857142857143, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5833333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       14  => (0 => to_sfixed(0.6176470588235295, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7857142857142858, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7083333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       15  => (0 => to_sfixed(0.676470588235294, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5892857142857144, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5416666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       16  => (0 => to_sfixed(0.8529411764705882, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.7272727272727273, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8928571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.0, parte_inteira, parte_fracionaria)),
                                                                                                       17  => (0 => to_sfixed(0.411764705882353, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.409090909090909, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5535714285714286, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5, parte_inteira, parte_fracionaria)),
                                                                                                       18  => (0 => to_sfixed(0.9705882352941175, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.9821428571428572, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.8333333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       19  => (0 => to_sfixed(0.3823529411764705, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6071428571428572, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5833333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       20  => (0 => to_sfixed(0.23529411764705874, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6818181818181818, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.05357142857142854, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       21  => (0 => to_sfixed(1.0, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.36363636363636354, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.0, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7916666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       22  => (0 => to_sfixed(0.4411764705882352, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.31818181818181823, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5357142857142857, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.375, parte_inteira, parte_fracionaria)),
                                                                                                       23  => (0 => to_sfixed(0.26470588235294124, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6363636363636362, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.05357142857142854, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       24  => (0 => to_sfixed(0.2058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6818181818181818, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.035714285714285705, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.08333333333333333, parte_inteira, parte_fracionaria)),
                                                                                                       25  => (0 => to_sfixed(0.23529411764705874, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.818181818181818, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.14285714285714282, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.12500000000000003, parte_inteira, parte_fracionaria)),
                                                                                                       26  => (0 => to_sfixed(0.2058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.0, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.4285714285714286, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.375, parte_inteira, parte_fracionaria)),
                                                                                                       27  => (0 => to_sfixed(0.588235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.31818181818181823, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6785714285714287, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7083333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       28  => (0 => to_sfixed(0.14705882352941174, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6363636363636362, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.14285714285714282, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       29  => (0 => to_sfixed(0.2058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.08928571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       30  => (0 => to_sfixed(0.23529411764705874, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5909090909090908, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.10714285714285712, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.16666666666666669, parte_inteira, parte_fracionaria)),
                                                                                                       31  => (0 => to_sfixed(0.3823529411764705, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.31818181818181823, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5535714285714286, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5, parte_inteira, parte_fracionaria)),
                                                                                                       32  => (0 => to_sfixed(0.23529411764705874, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6363636363636362, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.07142857142857141, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       33  => (0 => to_sfixed(0.411764705882353, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5535714285714286, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.4583333333333333, parte_inteira, parte_fracionaria)),
                                                                                                       34  => (0 => to_sfixed(1.0, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.818181818181818, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.0, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.8750000000000001, parte_inteira, parte_fracionaria)),
                                                                                                       35  => (0 => to_sfixed(0.088235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5454545454545455, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.05357142857142854, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       36  => (0 => to_sfixed(0.5588235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.409090909090909, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5714285714285714, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5, parte_inteira, parte_fracionaria)),
                                                                                                       37  => (0 => to_sfixed(0.411764705882353, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.22727272727272727, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6964285714285715, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7916666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       38  => (0 => to_sfixed(0.35294117647058826, parte_inteira, parte_fracionaria), 1 => to_sfixed(1.0, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.05357142857142854, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       39  => (0 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6607142857142857, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7083333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       40  => (0 => to_sfixed(0.4411764705882352, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.31818181818181823, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7142857142857143, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.75, parte_inteira, parte_fracionaria)),
                                                                                                       41  => (0 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.09090909090909098, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5178571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.375, parte_inteira, parte_fracionaria)),
                                                                                                       42  => (0 => to_sfixed(0.323529411764706, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6071428571428572, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5833333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       43  => (0 => to_sfixed(0.5588235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6363636363636362, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.767857142857143, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.9166666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       44  => (0 => to_sfixed(0.35294117647058826, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.13636363636363627, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5178571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5, parte_inteira, parte_fracionaria)),
                                                                                                       45  => (0 => to_sfixed(0.323529411764706, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.8636363636363635, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.10714285714285712, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.12500000000000003, parte_inteira, parte_fracionaria)),
                                                                                                       46  => (0 => to_sfixed(0.2058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.13636363636363627, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.39285714285714285, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.375, parte_inteira, parte_fracionaria)),
                                                                                                       47  => (0 => to_sfixed(0.6176470588235295, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.31818181818181823, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7499999999999999, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.75, parte_inteira, parte_fracionaria)),
                                                                                                       48  => (0 => to_sfixed(0.2058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5909090909090908, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.05357142857142854, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       49  => (0 => to_sfixed(0.2058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5454545454545455, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.017857142857142835, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       50  => (0 => to_sfixed(0.35294117647058826, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.18181818181818177, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.48214285714285715, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.4166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       51  => (0 => to_sfixed(0.7058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6964285714285715, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.6666666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       52  => (0 => to_sfixed(0.17647058823529427, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.07142857142857141, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.0, parte_inteira, parte_fracionaria)),
                                                                                                       53  => (0 => to_sfixed(0.4411764705882352, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.36363636363636354, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7142857142857143, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.9583333333333333, parte_inteira, parte_fracionaria)),
                                                                                                       54  => (0 => to_sfixed(0.2058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6363636363636362, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.07142857142857141, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       55  => (0 => to_sfixed(0.2058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6818181818181818, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.08928571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.20833333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       56  => (0 => to_sfixed(0.47058823529411775, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5454545454545455, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6607142857142857, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7083333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       57  => (0 => to_sfixed(0.23529411764705874, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.22727272727272727, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.3392857142857143, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.4166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       58  => (0 => to_sfixed(0.7647058823529412, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5454545454545455, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8214285714285714, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.9166666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       59  => (0 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.31818181818181823, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7142857142857143, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.625, parte_inteira, parte_fracionaria)),
                                                                                                       60  => (0 => to_sfixed(0.5294117647058822, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.27272727272727276, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8035714285714286, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5416666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       61  => (0 => to_sfixed(1.0, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8928571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.9166666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       62  => (0 => to_sfixed(0.35294117647058826, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.22727272727272727, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5178571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5, parte_inteira, parte_fracionaria)),
                                                                                                       63  => (0 => to_sfixed(0.029411764705882505, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.409090909090909, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.05357142857142854, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       64  => (0 => to_sfixed(0.0, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.0, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.0, parte_inteira, parte_fracionaria)),
                                                                                                       65  => (0 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.09090909090909098, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6964285714285715, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5833333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       66  => (0 => to_sfixed(0.8529411764705882, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5454545454545455, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8750000000000001, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7083333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       67  => (0 => to_sfixed(0.088235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.07142857142857141, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       68  => (0 => to_sfixed(0.23529411764705874, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6818181818181818, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.05357142857142854, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.08333333333333333, parte_inteira, parte_fracionaria)),
                                                                                                       69  => (0 => to_sfixed(0.029411764705882505, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.035714285714285705, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       70  => (0 => to_sfixed(0.588235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.22727272727272727, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6785714285714287, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5833333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       71  => (0 => to_sfixed(0.588235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6363636363636362, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8035714285714286, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.9583333333333333, parte_inteira, parte_fracionaria)),
                                                                                                       72  => (0 => to_sfixed(0.088235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6363636363636362, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.05357142857142854, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.08333333333333333, parte_inteira, parte_fracionaria)),
                                                                                                       73  => (0 => to_sfixed(0.7352941176470588, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7857142857142858, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.8333333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       74  => (0 => to_sfixed(0.588235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5909090909090908, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8750000000000001, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.0, parte_inteira, parte_fracionaria)),
                                                                                                       75  => (0 => to_sfixed(0.11764705882352951, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5454545454545455, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.035714285714285705, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       76  => (0 => to_sfixed(0.5294117647058822, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.409090909090909, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6428571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5416666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       77  => (0 => to_sfixed(0.6470588235294118, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.36363636363636354, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.625, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5833333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       78  => (0 => to_sfixed(0.5588235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.36363636363636354, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6607142857142857, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7083333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       79  => (0 => to_sfixed(0.7941176470588235, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5454545454545455, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6428571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5416666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       80  => (0 => to_sfixed(0.6176470588235295, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5454545454545455, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7499999999999999, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.9166666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       81  => (0 => to_sfixed(0.23529411764705874, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.818181818181818, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.08928571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       82  => (0 => to_sfixed(0.7647058823529412, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.767857142857143, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.8333333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       83  => (0 => to_sfixed(0.47058823529411775, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5535714285714286, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5833333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       84  => (0 => to_sfixed(0.6470588235294118, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7321428571428571, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7916666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       85  => (0 => to_sfixed(0.411764705882353, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.27272727272727276, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.4285714285714286, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.375, parte_inteira, parte_fracionaria)),
                                                                                                       86  => (0 => to_sfixed(0.26470588235294124, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.31818181818181823, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5416666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       87  => (0 => to_sfixed(0.5294117647058822, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.625, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5416666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       88  => (0 => to_sfixed(0.058823529411764754, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.13636363636363627, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.035714285714285705, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.08333333333333333, parte_inteira, parte_fracionaria)),
                                                                                                       89  => (0 => to_sfixed(0.676470588235294, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.409090909090909, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.625, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5, parte_inteira, parte_fracionaria)),
                                                                                                       90  => (0 => to_sfixed(0.35294117647058826, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.27272727272727276, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5892857142857144, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.4583333333333333, parte_inteira, parte_fracionaria)),
                                                                                                       91  => (0 => to_sfixed(0.2941176470588235, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.7727272727272727, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.07142857142857141, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       92  => (0 => to_sfixed(0.3823529411764705, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5357142857142857, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5, parte_inteira, parte_fracionaria)),
                                                                                                       93  => (0 => to_sfixed(0.8823529411764705, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.409090909090909, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.9285714285714285, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7083333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       94  => (0 => to_sfixed(0.7058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5909090909090908, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8214285714285714, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.8333333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       95  => (0 => to_sfixed(0.23529411764705874, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.7727272727272727, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.07142857142857141, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.12500000000000003, parte_inteira, parte_fracionaria)),
                                                                                                       96  => (0 => to_sfixed(0.17647058823529427, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.18181818181818177, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.39285714285714285, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.375, parte_inteira, parte_fracionaria)),
                                                                                                       97  => (0 => to_sfixed(0.7058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5909090909090908, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8214285714285714, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.0, parte_inteira, parte_fracionaria)),
                                                                                                       98  => (0 => to_sfixed(0.8529411764705882, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8392857142857142, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.625, parte_inteira, parte_fracionaria)),
                                                                                                       99  => (0 => to_sfixed(0.17647058823529427, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.07142857142857141, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.0, parte_inteira, parte_fracionaria)),
                                                                                                       100 => (0 => to_sfixed(0.7058823529411765, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8035714285714286, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.9583333333333333, parte_inteira, parte_fracionaria)),
                                                                                                       101 => (0 => to_sfixed(0.17647058823529427, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.05357142857142854, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       102 => (0 => to_sfixed(0.7647058823529412, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.5, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6785714285714287, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5833333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       103 => (0 => to_sfixed(0.911764705882353, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.36363636363636354, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8928571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.75, parte_inteira, parte_fracionaria)),
                                                                                                       104 => (0 => to_sfixed(0.588235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.409090909090909, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8035714285714286, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7083333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       105 => (0 => to_sfixed(0.411764705882353, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.36363636363636354, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5357142857142857, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5, parte_inteira, parte_fracionaria)),
                                                                                                       106 => (0 => to_sfixed(0.6470588235294118, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7857142857142858, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7083333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       107 => (0 => to_sfixed(0.588235294117647, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.13636363636363627, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5892857142857144, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5, parte_inteira, parte_fracionaria)),
                                                                                                       108 => (0 => to_sfixed(0.6176470588235295, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.409090909090909, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5714285714285714, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5, parte_inteira, parte_fracionaria)),
                                                                                                       109 => (0 => to_sfixed(0.3823529411764705, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.36363636363636354, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6785714285714287, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7916666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       110 => (0 => to_sfixed(0.47058823529411775, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.7142857142857143, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.7083333333333334, parte_inteira, parte_fracionaria)),
                                                                                                       111 => (0 => to_sfixed(0.323529411764706, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.6363636363636362, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.10714285714285712, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       112 => (0 => to_sfixed(0.5294117647058822, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.36363636363636354, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5178571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.5, parte_inteira, parte_fracionaria)),
                                                                                                       113 => (0 => to_sfixed(0.17647058823529427, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.22727272727272727, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.6071428571428572, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.6666666666666666, parte_inteira, parte_fracionaria)),
                                                                                                       114 => (0 => to_sfixed(0.4411764705882352, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.9090909090909091, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.017857142857142835, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.04166666666666667, parte_inteira, parte_fracionaria)),
                                                                                                       115 => (0 => to_sfixed(0.4411764705882352, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.27272727272727276, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.5178571428571429, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.4583333333333333, parte_inteira, parte_fracionaria)),
                                                                                                       116 => (0 => to_sfixed(0.8235294117647057, parte_inteira, parte_fracionaria), 1 => to_sfixed(0.45454545454545453, parte_inteira, parte_fracionaria), 2 => to_sfixed(0.8571428571428573, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.8333333333333334, parte_inteira, parte_fracionaria))
	);

	-- ---------------------------------- x_teste ----------------------------------
	constant x_teste : mat_s_fixo(amostras_teste - 1 downto 0, n_caracteristicas -1 downto 0) := (
                                                                                                    0  => (0 => to_sfixed(6.1, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.8, parte_inteira, parte_fracionaria), 2 => to_sfixed(4.7, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.2, parte_inteira, parte_fracionaria)),
                                                                                                    1  => (0 => to_sfixed(5.7, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.8, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.7, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.3, parte_inteira, parte_fracionaria)),
                                                                                                    2  => (0 => to_sfixed(7.7, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.6, parte_inteira, parte_fracionaria), 2 => to_sfixed(6.9, parte_inteira, parte_fracionaria), 3 => to_sfixed(2.3, parte_inteira, parte_fracionaria)),
                                                                                                    3  => (0 => to_sfixed(6.0, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.9, parte_inteira, parte_fracionaria), 2 => to_sfixed(4.5, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.5, parte_inteira, parte_fracionaria)),
                                                                                                    4  => (0 => to_sfixed(6.8, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.8, parte_inteira, parte_fracionaria), 2 => to_sfixed(4.8, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.4, parte_inteira, parte_fracionaria)),
                                                                                                    5  => (0 => to_sfixed(5.4, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.4, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.5, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.4, parte_inteira, parte_fracionaria)),
                                                                                                    6  => (0 => to_sfixed(5.6, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.9, parte_inteira, parte_fracionaria), 2 => to_sfixed(3.6, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.3, parte_inteira, parte_fracionaria)),
                                                                                                    7  => (0 => to_sfixed(6.9, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.1, parte_inteira, parte_fracionaria), 2 => to_sfixed(5.1, parte_inteira, parte_fracionaria), 3 => to_sfixed(2.3, parte_inteira, parte_fracionaria)),
                                                                                                    8  => (0 => to_sfixed(6.2, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.2, parte_inteira, parte_fracionaria), 2 => to_sfixed(4.5, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.5, parte_inteira, parte_fracionaria)),
                                                                                                    9  => (0 => to_sfixed(5.8, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.7, parte_inteira, parte_fracionaria), 2 => to_sfixed(3.9, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.2, parte_inteira, parte_fracionaria)),
                                                                                                    10 => (0 => to_sfixed(6.5, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.2, parte_inteira, parte_fracionaria), 2 => to_sfixed(5.1, parte_inteira, parte_fracionaria), 3 => to_sfixed(2.0, parte_inteira, parte_fracionaria)),
                                                                                                    11 => (0 => to_sfixed(4.8, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.0, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.4, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.1, parte_inteira, parte_fracionaria)),
                                                                                                    12 => (0 => to_sfixed(5.5, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.5, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.3, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.2, parte_inteira, parte_fracionaria)),
                                                                                                    13 => (0 => to_sfixed(4.9, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.1, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.5, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.1, parte_inteira, parte_fracionaria)),
                                                                                                    14 => (0 => to_sfixed(5.1, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.8, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.5, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.3, parte_inteira, parte_fracionaria)),
                                                                                                    15 => (0 => to_sfixed(6.3, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.3, parte_inteira, parte_fracionaria), 2 => to_sfixed(4.7, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.6, parte_inteira, parte_fracionaria)),
                                                                                                    16 => (0 => to_sfixed(6.5, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.0, parte_inteira, parte_fracionaria), 2 => to_sfixed(5.8, parte_inteira, parte_fracionaria), 3 => to_sfixed(2.2, parte_inteira, parte_fracionaria)),
                                                                                                    17 => (0 => to_sfixed(5.6, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.5, parte_inteira, parte_fracionaria), 2 => to_sfixed(3.9, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.1, parte_inteira, parte_fracionaria)),
                                                                                                    18 => (0 => to_sfixed(5.7, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.8, parte_inteira, parte_fracionaria), 2 => to_sfixed(4.5, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.3, parte_inteira, parte_fracionaria)),
                                                                                                    19 => (0 => to_sfixed(6.4, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.8, parte_inteira, parte_fracionaria), 2 => to_sfixed(5.6, parte_inteira, parte_fracionaria), 3 => to_sfixed(2.2, parte_inteira, parte_fracionaria)),
                                                                                                    20 => (0 => to_sfixed(4.7, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.2, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.6, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.2, parte_inteira, parte_fracionaria)),
                                                                                                    21 => (0 => to_sfixed(6.1, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.0, parte_inteira, parte_fracionaria), 2 => to_sfixed(4.9, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.8, parte_inteira, parte_fracionaria)),
                                                                                                    22 => (0 => to_sfixed(5.0, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.4, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.6, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.4, parte_inteira, parte_fracionaria)),
                                                                                                    23 => (0 => to_sfixed(6.4, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.8, parte_inteira, parte_fracionaria), 2 => to_sfixed(5.6, parte_inteira, parte_fracionaria), 3 => to_sfixed(2.1, parte_inteira, parte_fracionaria)),
                                                                                                    24 => (0 => to_sfixed(7.9, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.8, parte_inteira, parte_fracionaria), 2 => to_sfixed(6.4, parte_inteira, parte_fracionaria), 3 => to_sfixed(2.0, parte_inteira, parte_fracionaria)),
                                                                                                    25 => (0 => to_sfixed(6.7, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.0, parte_inteira, parte_fracionaria), 2 => to_sfixed(5.2, parte_inteira, parte_fracionaria), 3 => to_sfixed(2.3, parte_inteira, parte_fracionaria)),
                                                                                                    26 => (0 => to_sfixed(6.7, parte_inteira, parte_fracionaria), 1 => to_sfixed(2.5, parte_inteira, parte_fracionaria), 2 => to_sfixed(5.8, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.8, parte_inteira, parte_fracionaria)),
                                                                                                    27 => (0 => to_sfixed(6.8, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.2, parte_inteira, parte_fracionaria), 2 => to_sfixed(5.9, parte_inteira, parte_fracionaria), 3 => to_sfixed(2.3, parte_inteira, parte_fracionaria)),
                                                                                                    28 => (0 => to_sfixed(4.8, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.0, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.4, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.3, parte_inteira, parte_fracionaria)),
                                                                                                    29 => (0 => to_sfixed(4.8, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.1, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.6, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.2, parte_inteira, parte_fracionaria)),
                                                                                                    30 => (0 => to_sfixed(4.6, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.6, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.0, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.2, parte_inteira, parte_fracionaria)),
                                                                                                    31 => (0 => to_sfixed(5.7, parte_inteira, parte_fracionaria), 1 => to_sfixed(4.4, parte_inteira, parte_fracionaria), 2 => to_sfixed(1.5, parte_inteira, parte_fracionaria), 3 => to_sfixed(0.4, parte_inteira, parte_fracionaria)),
                                                                                                    32 => (0 => to_sfixed(6.7, parte_inteira, parte_fracionaria), 1 => to_sfixed(3.1, parte_inteira, parte_fracionaria), 2 => to_sfixed(4.4, parte_inteira, parte_fracionaria), 3 => to_sfixed(1.4, parte_inteira, parte_fracionaria))
	);

	-- ---------------------------------- y_treino ----------------------------------
	constant y_treino : vec_inteiro(amostras_treino - 1 downto 0) := (
                                                                        0  =>0,	1  =>0,	2  =>1,	3  =>2,
                                                                        4  =>0,	5  =>0,	6  =>0,	7  =>1,
                                                                        8  =>2,	9  =>2,	10 =>0,	11 =>0,
                                                                        12 =>2,	13 =>1,	14 =>1,	15 =>2,
                                                                        16 =>1,	17 =>2,	18 =>1,	19 =>2,
                                                                        20 =>0,	21 =>1,	22 =>2,	23 =>0,
                                                                        24 =>0,	25 =>0,	26 =>2,	27 =>1,
                                                                        28 =>0,	29 =>0,	30 =>0,	31 =>2,
                                                                        32 =>0,	33 =>2,	34 =>1,	35 =>0,
                                                                        36 =>2,	37 =>1,	38 =>0,	39 =>1,
                                                                        40 =>1,	41 =>2,	42 =>2,	43 =>1,
                                                                        44 =>2,	45 =>0,	46 =>2,	47 =>1,
                                                                        48 =>0,	49 =>0,	50 =>2,	51 =>2,
                                                                        52 =>0,	53 =>1,	54 =>0,	55 =>0,
                                                                        56 =>2,	57 =>2,	58 =>1,	59 =>2,
                                                                        60 =>1,	61 =>1,	62 =>2,	63 =>0,
                                                                        64 =>0,	65 =>1,	66 =>1,	67 =>0,
                                                                        68 =>0,	69 =>0,	70 =>2,	71 =>1,
                                                                        72 =>0,	73 =>1,	74 =>1,	75 =>0,
                                                                        76 =>2,	77 =>2,	78 =>1,	79 =>2,
                                                                        80 =>1,	81 =>0,	82 =>1,	83 =>2,
                                                                        84 =>1,	85 =>2,	86 =>2,	87 =>2,
                                                                        88 =>0,	89 =>2,	90 =>2,	91 =>0,
                                                                        92 =>2,	93 =>1,	94 =>1,	95 =>0,
                                                                        96 =>2,	97 =>1,	98 =>1,	99 =>0,
                                                                        100=>1,	101=>0,	102=>2,	103=>1,
                                                                        104=>1,	105=>2,	106=>1,	107=>2,
                                                                        108=>2,	109=>1,	110=>1,	111=>0,
                                                                        112=>2,	113=>1,	114=>0,	115=>2,
                                                                        116=>1	
	);

	-- ---------------------------------- y_teste ----------------------------------
	constant y_teste : vec_inteiro(amostras_teste - 1 downto 0) := (
                                                                      0 =>2,	1 =>0,	2 =>1,	3 =>2,
                                                                      4 =>2,	5 =>0,	6 =>2,	7 =>1,
                                                                      8 =>2,	9 =>2,	10=>1,	11=>0,
                                                                      12=>0,	13=>0,	14=>0,	15=>2,
                                                                      16=>1,	17=>2,	18=>2,	19=>1,
                                                                      20=>0,	21=>1,	22=>0,	23=>1,
                                                                      24=>1,	25=>1,	26=>1,	27=>1,
                                                                      28=>0,	29=>0,	30=>0,	31=>0,
                                                                      32=>2	
	);

end package pacote_aux;
