/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.LinearFloatValueAnimator;
import org.openimaj.content.animation.animator.RandomLinearFloatValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class FloatArrayValueAnimator
implements ValueAnimator<float[]> {
    ValueAnimator<Float>[] animators;

    @SafeVarargs
    public FloatArrayValueAnimator(ValueAnimator<Float> ... animators) {
        this.animators = animators;
    }

    public static FloatArrayValueAnimator makeLinear(int duration, float ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new LinearFloatValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new FloatArrayValueAnimator(animators);
    }

    public static FloatArrayValueAnimator makeLinear(int duration, int count, float start, float finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new LinearFloatValueAnimator(start, finish, duration);
        }
        return new FloatArrayValueAnimator(animators);
    }

    public static FloatArrayValueAnimator makeRandomLinear(int duration, float ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new RandomLinearFloatValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new FloatArrayValueAnimator(animators);
    }

    public static FloatArrayValueAnimator makeRandomLinear(int duration, int count, float start, float finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new RandomLinearFloatValueAnimator(start, finish, duration);
        }
        return new FloatArrayValueAnimator(animators);
    }

    @Override
    public float[] nextValue() {
        float[] value = new float[this.animators.length];
        for (int i = 0; i < this.animators.length; ++i) {
            value[i] = this.animators[i].nextValue().floatValue();
        }
        return value;
    }

    @Override
    public boolean hasFinished() {
        for (ValueAnimator<Float> a : this.animators) {
            if (a.hasFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        for (ValueAnimator<Float> animator : this.animators) {
            animator.reset();
        }
    }
}

