/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.samples;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.timecode.AudioTimecode;

public class SampleBuffer16Bit
implements SampleBuffer,
Iterator<Float> {
    private byte[] samples = null;
    private ShortBuffer shortBuffer = null;
    private AudioFormat format;
    private int iteratorCount;
    private AudioTimecode timecode = null;

    public SampleBuffer16Bit(SampleChunk samples, AudioFormat af) {
        this.format = af;
        this.shortBuffer = samples.getSamplesAsByteBuffer().asShortBuffer();
        this.samples = samples.getSamples();
        this.setStartTimecode(samples.getStartTimecode());
    }

    public SampleBuffer16Bit(AudioFormat af, int nSamples) {
        this.format = af.clone();
        this.samples = new byte[nSamples * 2];
        this.shortBuffer = new SampleChunk(this.samples, this.format).getSamplesAsByteBuffer().asShortBuffer();
    }

    @Override
    public SampleChunk getSampleChunk() {
        SampleChunk sc = new SampleChunk(this.samples, this.format);
        sc.setStartTimecode(this.timecode);
        return sc;
    }

    @Override
    public SampleChunk getSampleChunk(int channel) {
        if (channel > this.format.getNumChannels()) {
            throw new IllegalArgumentException("Cannot generate sample chunk for channel " + channel + " as sample only has " + this.format.getNumChannels() + " channels.");
        }
        if (channel == 0 && this.format.getNumChannels() == 1) {
            return this.getSampleChunk();
        }
        byte[] newSamples = new byte[this.size() * 2];
        ShortBuffer sb = ByteBuffer.wrap(newSamples).order(this.format.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        for (int i = 0; i < this.size() / this.format.getNumChannels(); ++i) {
            sb.put(i, this.shortBuffer.get(i * this.format.getNumChannels() + channel));
        }
        AudioFormat af = this.format.clone();
        af.setNumChannels(1);
        return new SampleChunk(newSamples, af);
    }

    @Override
    public float get(int index) {
        if (index >= this.shortBuffer.limit()) {
            return 0.0f;
        }
        return (float)this.shortBuffer.get(index) * 2.1474836E9f / 32767.0f;
    }

    @Override
    public float getUnscaled(int index) {
        return this.shortBuffer.get(index);
    }

    @Override
    public void set(int index, float sample) {
        float s = sample;
        if (s > 2.1474836E9f) {
            s = 2.1474836E9f;
        }
        if (s < -2.1474836E9f) {
            s = -2.1474836E9f;
        }
        this.shortBuffer.put(index, (short)(sample * 32767.0f / 2.1474836E9f));
    }

    @Override
    public int size() {
        return this.shortBuffer.limit();
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(AudioFormat af) {
        this.format = af;
    }

    @Override
    public double[] asDoubleArray() {
        double[] d = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            d[i] = this.get(i) / 2.1474836E9f;
        }
        return d;
    }

    @Override
    public double[][] asDoubleChannelArray() {
        int nc = this.format.getNumChannels();
        double[][] s = new double[nc][this.size() / nc];
        for (int c = 0; c < nc; ++c) {
            for (int sa = 0; sa < this.size() / nc; ++sa) {
                s[c][sa] = this.get(sa * nc + c) / 2.1474836E9f;
            }
        }
        return s;
    }

    @Override
    public float[] asFloatArray() {
        float[] d = new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            d[i] = this.get(i) / 2.1474836E9f;
        }
        return d;
    }

    @Override
    public float[][] asFloatChannelArray() {
        int nc = this.format.getNumChannels();
        float[][] s = new float[nc][this.size() / nc];
        for (int c = 0; c < nc; ++c) {
            for (int sa = 0; sa < this.size() / nc; ++sa) {
                s[c][sa] = this.get(sa * nc + c) / 2.1474836E9f;
            }
        }
        return s;
    }

    @Override
    public Iterator<Float> iterator() {
        this.iteratorCount = 0;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorCount < this.size();
    }

    @Override
    public Float next() {
        float f = this.get(this.iteratorCount);
        ++this.iteratorCount;
        return Float.valueOf(f);
    }

    @Override
    public void remove() {
        throw new NotImplementedException("Cannot remove from 16bit sample buffer");
    }

    @Override
    public AudioTimecode getStartTimecode() {
        return this.timecode;
    }

    public void setStartTimecode(AudioTimecode timecode) {
        this.timecode = timecode;
    }
}

