/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.BlankLineContainer;
import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;

public abstract class ListItem
extends Block
implements ParagraphItemContainer,
BlankLineContainer {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence markerSuffix = BasedSequence.NULL;
    private boolean tight = true;
    private boolean hadBlankAfterItemParagraph = false;
    private boolean containsBlankLine = false;

    public void getAstExtra(StringBuilder out) {
        ListItem.segmentSpanChars((StringBuilder)out, (BasedSequence)this.openingMarker, (String)"open");
        ListItem.segmentSpanChars((StringBuilder)out, (BasedSequence)this.markerSuffix, (String)"openSuffix");
        if (this.isTight()) {
            out.append(" isTight");
        } else {
            out.append(" isLoose");
        }
        if (this.isHadBlankAfterItemParagraph()) {
            out.append(" hadBlankLineAfter");
        } else if (this.isContainsBlankLine()) {
            out.append(" hadBlankLine");
        }
    }

    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.markerSuffix};
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getMarkerSuffix() {
        return this.markerSuffix;
    }

    public void setMarkerSuffix(BasedSequence markerSuffix) {
        assert (markerSuffix.isNull() || this.openingMarker.getBase() == markerSuffix.getBase());
        this.markerSuffix = markerSuffix;
    }

    public void setTight(boolean tight) {
        this.tight = tight;
    }

    public void setLoose(boolean loose) {
        this.tight = !loose;
    }

    public boolean isTight() {
        return this.tight && this.isInTightList();
    }

    public boolean isOwnTight() {
        return this.tight;
    }

    public boolean isLoose() {
        return !this.isTight();
    }

    public boolean isParagraphInTightListItem(Paragraph node) {
        if (!this.isTight()) {
            return false;
        }
        return this.isItemParagraph(node);
    }

    @Override
    public boolean isItemParagraph(Paragraph node) {
        Node child;
        for (child = this.getFirstChild(); child != null && !(child instanceof Paragraph); child = child.getNext()) {
        }
        return child == node;
    }

    @Override
    public boolean isParagraphWrappingDisabled(Paragraph node, ListOptions listOptions, DataHolder options) {
        assert (node.getParent() == this);
        return listOptions.isInTightListItem(node);
    }

    public boolean isInTightList() {
        return !(this.getParent() instanceof ListBlock) || ((ListBlock)this.getParent()).isTight();
    }

    public boolean isHadBlankAfterItemParagraph() {
        return this.hadBlankAfterItemParagraph;
    }

    public boolean isContainsBlankLine() {
        return this.containsBlankLine;
    }

    public void setContainsBlankLine(boolean containsBlankLine) {
        this.containsBlankLine = containsBlankLine;
    }

    public void setHadBlankAfterItemParagraph(boolean hadBlankAfterItemParagraph) {
        this.hadBlankAfterItemParagraph = hadBlankAfterItemParagraph;
    }

    public Node getLastBlankLineChild() {
        return this.getLastChild();
    }

    public ListItem() {
    }

    public ListItem(ListItem other) {
        this.openingMarker = other.openingMarker;
        this.markerSuffix = other.markerSuffix;
        this.tight = other.tight;
        this.hadBlankAfterItemParagraph = other.hadBlankAfterItemParagraph;
        this.takeChildren((Node)other);
        this.setCharsFromContent();
    }

    public ListItem(BasedSequence chars) {
        super(chars);
    }

    public ListItem(BasedSequence chars, List<BasedSequence> segments) {
        super(chars, segments);
    }

    public ListItem(BlockContent blockContent) {
        super(blockContent);
    }
}

