/*
 * Decompiled with CFR 0.152.
 */
package bsearch.evaluation;

import bsearch.app.BehaviorSearchException;
import bsearch.app.SearchProtocol;
import bsearch.evaluation.FitnessFunction;
import bsearch.evaluation.ResultListener;
import bsearch.evaluation.ResultsArchive;
import bsearch.nlogolink.BatchRunner;
import bsearch.nlogolink.ModelRunResult;
import bsearch.nlogolink.ModelRunner;
import bsearch.nlogolink.NetLogoLinkException;
import bsearch.representations.Chromosome;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.nlogo.api.MersenneTwisterFast;

public class SearchManager {
    private final BatchRunner runner;
    private final SearchProtocol protocol;
    private final FitnessFunction fitnessFunction;
    private int searchIDNumber;
    private double fitnessGoalLimit;
    private boolean stopAtFitnessGoal;
    private int evaluationCounter;
    private int requestedCounter;
    private int requestedCounterWhenLastEvaluated;
    private int auxilliaryEvaluationCounter;
    private Chromosome currentBest;
    private double currentBestFitness;
    private double currentBestFitnessCheckedEstimate;
    private ResultsArchive cache;
    private List<ResultListener> resultListeners = new ArrayList<ResultListener>();

    public SearchManager(int searchIDNumber, BatchRunner runner, SearchProtocol protocol, FitnessFunction fitnessFunction, boolean stopAtFitnessGoal, double fitnessGoalLimit) {
        this.searchIDNumber = searchIDNumber;
        this.runner = runner;
        this.protocol = protocol;
        this.fitnessFunction = fitnessFunction;
        this.evaluationCounter = 0;
        this.requestedCounter = 0;
        this.requestedCounterWhenLastEvaluated = 0;
        this.auxilliaryEvaluationCounter = 0;
        this.stopAtFitnessGoal = stopAtFitnessGoal;
        this.fitnessGoalLimit = fitnessGoalLimit;
        this.cache = new ResultsArchive(4096);
        this.setCurrentBest(null, fitnessFunction.getWorstConceivableFitnessValue());
    }

    public void addResultsListener(ResultListener listener) {
        this.resultListeners.add(listener);
    }

    /*
     * WARNING - void declaration
     */
    private double computeFitnessWithoutSideEffects(Chromosome pointOfInterest, int numReplicationsDesired, MersenneTwisterFast rng) throws ModelRunner.ModelRunnerException, NetLogoLinkException, InterruptedException, BehaviorSearchException {
        void var9_13;
        ResultsArchive tempCache = new ResultsArchive(numReplicationsDesired);
        HashMap<Chromosome, Integer> desiredRuns = this.fitnessFunction.getRunsNeeded(pointOfInterest, numReplicationsDesired, tempCache);
        ArrayList<Chromosome> evaluationQueue = new ArrayList<Chromosome>(numReplicationsDesired);
        for (Chromosome chromosome : desiredRuns.keySet()) {
            evaluationQueue.addAll(Collections.nCopies(desiredRuns.get(chromosome), chromosome));
        }
        ArrayList<ModelRunner.RunSetup> setupList = new ArrayList<ModelRunner.RunSetup>(evaluationQueue.size());
        for (Chromosome chromosome : evaluationQueue) {
            setupList.add(new ModelRunner.RunSetup(rng.nextInt(), chromosome.getParamSettings()));
        }
        List<ModelRunResult> list = this.runner.doBatchRun(setupList);
        boolean bl = false;
        while (var9_13 < evaluationQueue.size()) {
            tempCache.add((Chromosome)evaluationQueue.get((int)var9_13), list.get((int)var9_13), numReplicationsDesired);
            ++var9_13;
        }
        this.auxilliaryEvaluationCounter += list.size();
        return this.fitnessFunction.evaluate(pointOfInterest, tempCache);
    }

    public double computeFitnessSingle(Chromosome point, int numReplicationsDesired, MersenneTwisterFast rng) throws ModelRunner.ModelRunnerException, BehaviorSearchException, InterruptedException {
        Chromosome[] points = new Chromosome[]{point};
        return this.computeFitnessBatch(points, numReplicationsDesired, rng)[0];
    }

    public double[] computeFitnessBatch(Chromosome[] points, int numReplicationsDesired, MersenneTwisterFast rng) throws ModelRunner.ModelRunnerException, BehaviorSearchException, InterruptedException {
        int[] repsDesired = new int[points.length];
        Arrays.fill(repsDesired, numReplicationsDesired);
        try {
            return this.computeFitnessBatch(points, repsDesired, rng);
        }
        catch (NetLogoLinkException ex) {
            ex.printStackTrace();
            throw new BehaviorSearchException(ex.getMessage(), ex.getCause());
        }
    }

    public double[] computeFitnessBatch(Chromosome[] points, int[] numReplicationsDesired, MersenneTwisterFast rng) throws ModelRunner.ModelRunnerException, NetLogoLinkException, InterruptedException, BehaviorSearchException {
        if (numReplicationsDesired.length != points.length) {
            throw new IllegalArgumentException("there must be some number of desired replications specified for *each* of the Chromosomes to be evaluated.");
        }
        if (!this.protocol.caching) {
            this.cache.clear();
        }
        LinkedHashMap<Chromosome, Integer> allDesiredRuns = new LinkedHashMap<Chromosome, Integer>();
        int[] numReplicationsNeeded = new int[points.length];
        int prevRequested = 0;
        int requested = 0;
        for (int i = 0; i < points.length; ++i) {
            this.requestedCounter += this.fitnessFunction.getMaximumRunsThatCouldBeNeeded(numReplicationsDesired[i]);
            HashMap<Chromosome, Integer> desiredRuns = this.fitnessFunction.getRunsNeeded(points[i], numReplicationsDesired[i], this.cache);
            for (Chromosome chromosome : desiredRuns.keySet()) {
                int oldReps = 0;
                if (allDesiredRuns.containsKey(chromosome)) {
                    oldReps = (Integer)((HashMap)allDesiredRuns).get(chromosome);
                }
                int newReps = this.protocol.caching ? StrictMath.max((Integer)desiredRuns.get(chromosome), oldReps) : oldReps + (Integer)desiredRuns.get(chromosome);
                allDesiredRuns.put(chromosome, newReps);
                requested += newReps - oldReps;
            }
            numReplicationsNeeded[i] = requested - prevRequested;
            prevRequested = requested;
        }
        ArrayList<Object> evaluationQueue = new ArrayList<Object>(requested);
        for (Object point : ((HashMap)allDesiredRuns).keySet()) {
            evaluationQueue.addAll(Collections.nCopies((Integer)((HashMap)allDesiredRuns).get(point), point));
        }
        ArrayList<ModelRunner.RunSetup> setupList = new ArrayList<ModelRunner.RunSetup>(evaluationQueue.size());
        for (Chromosome chromosome : evaluationQueue) {
            int seed = rng.nextInt();
            setupList.add(new ModelRunner.RunSetup(seed, chromosome.getParamSettings()));
        }
        MersenneTwisterFast auxilliaryRNG = new MersenneTwisterFast((long)rng.clone().nextInt());
        int n = this.evaluationCounter;
        List<ModelRunResult> results = this.runner.doBatchRun(setupList);
        for (int i = 0; i < evaluationQueue.size(); ++i) {
            ++this.evaluationCounter;
            Chromosome point = (Chromosome)evaluationQueue.get(i);
            this.cache.add(point, results.get(i), this.protocol.fitnessSamplingReplications);
            for (ResultListener listener : this.resultListeners) {
                listener.modelRunOccurred(this, point, results.get(i));
            }
        }
        evaluationQueue.clear();
        this.evaluationCounter = n;
        double[] fitnesses = new double[points.length];
        for (int i = 0; i < points.length; ++i) {
            double fitness;
            fitnesses[i] = fitness = this.fitnessFunction.evaluate(points[i], this.cache);
            this.evaluationCounter += numReplicationsNeeded[i];
            if (this.fitnessFunction.strictlyBetterThan(fitness, this.currentBestFitness)) {
                this.setCurrentBest(points[i], fitness);
                if (this.protocol.useBestChecking()) {
                    this.currentBestFitnessCheckedEstimate = this.computeFitnessWithoutSideEffects(points[i], this.protocol.bestCheckingNumReplications, auxilliaryRNG);
                }
                for (ResultListener listener : this.resultListeners) {
                    listener.newBestFound(this);
                }
            }
            if (numReplicationsNeeded[i] <= 0) continue;
            for (ResultListener listener : this.resultListeners) {
                listener.fitnessComputed(this, points[i], fitness);
            }
        }
        return fitnesses;
    }

    public List<ModelRunResult> getCachedResults(Chromosome point) {
        return this.cache.getResults(point);
    }

    public int getEvaluationCount() {
        return this.evaluationCounter;
    }

    public int getEvaluationsRequestedCount() {
        return this.requestedCounter;
    }

    public int getAuxilliaryEvaluationCount() {
        return this.auxilliaryEvaluationCounter;
    }

    private boolean searchHasTotallyStalled() {
        if (this.protocol.fitnessSamplingReplications > 0) {
            int evaluationsPerPoint = this.fitnessFunction.getMaximumRunsThatCouldBeNeeded(this.protocol.fitnessSamplingReplications);
            return this.requestedCounter - this.requestedCounterWhenLastEvaluated > 10000000 * evaluationsPerPoint;
        }
        return this.requestedCounter - this.requestedCounterWhenLastEvaluated > 10000000;
    }

    public boolean searchFinished() {
        return this.searchHasTotallyStalled() || this.evaluationCounter >= this.protocol.evaluationLimit || this.stopAtFitnessGoal && this.fitnessFunction.reachedStopGoalFitness(this.fitnessGoalLimit);
    }

    public int getRemainingEvaluations() {
        return this.protocol.evaluationLimit - this.evaluationCounter;
    }

    public int getBatchRunnerNumThreads() {
        return this.runner.getNumThreads();
    }

    public int getSearchIDNumber() {
        return this.searchIDNumber;
    }

    public boolean fitnessStrictlyBetter(double f1, double f2) {
        return this.fitnessFunction.strictlyBetterThan(f1, f2);
    }

    public FitnessFunction getFitnessFunction() {
        return this.fitnessFunction;
    }

    private void setCurrentBest(Chromosome point, double fitness) {
        this.currentBest = point;
        this.currentBestFitness = fitness;
    }

    public Chromosome getCurrentBest() {
        return this.currentBest;
    }

    public double getCurrentBestFitness() {
        return this.currentBestFitness;
    }

    public double getCurrentBestFitnessCheckedEstimate() {
        return this.currentBestFitnessCheckedEstimate;
    }

    public double getBestFitnessCheckingReplications() {
        return this.protocol.bestCheckingNumReplications;
    }

    public Chromosome tournamentSelect(Chromosome[] population, double[] fitness, int tournamentSize, MersenneTwisterFast rng) {
        int i;
        int[] randomIndices = new int[tournamentSize];
        for (i = 0; i < randomIndices.length; ++i) {
            int randomIndex = rng.nextInt(population.length);
            for (int j = 0; j < i; ++j) {
                if (randomIndices[j] != randomIndex) continue;
            }
            randomIndices[i] = randomIndex;
        }
        int bestIndex = -1;
        double bestFitness = this.fitnessFunction.getWorstConceivableFitnessValue();
        for (i = 0; i < randomIndices.length; ++i) {
            double f = fitness[randomIndices[i]];
            if (!this.fitnessFunction.strictlyBetterThan(f, bestFitness)) continue;
            bestIndex = randomIndices[i];
            bestFitness = f;
        }
        return population[bestIndex];
    }
}

