/*
 * Decompiled with CFR 0.152.
 */
package bsearch.space;

import bsearch.space.ParameterSpec;
import org.nlogo.api.MersenneTwisterFast;

public strictfp class DoubleDiscreteSpec
extends ParameterSpec {
    private double dMin;
    private double dStep;
    private double dMax;

    public DoubleDiscreteSpec(String name, double min, double step, double max) {
        super(name);
        this.dMin = min;
        this.dStep = step;
        this.dMax = min + step * StrictMath.floor((max - min) / step);
    }

    private double enforceValidRange(double d) {
        if (d < this.dMin) {
            d = this.dMin;
        } else if (d > this.dMax) {
            d = this.dMax;
        }
        return this.dMin + (double)StrictMath.round((d - this.dMin) / this.dStep) * this.dStep;
    }

    @Override
    public Double generateRandomValue(MersenneTwisterFast rng) {
        return (double)rng.nextInt(1 + (int)StrictMath.floor((this.dMax - this.dMin) / this.dStep)) * this.dStep + this.dMin;
    }

    @Override
    public Double mutate(Object obj, double mutStrength, MersenneTwisterFast rng) {
        double mutStdDev = (this.dMax - this.dMin) * mutStrength;
        return this.enforceValidRange((Double)obj + mutStdDev * rng.nextGaussian());
    }

    @Override
    public int choiceCount() {
        return 1 + (int)StrictMath.floor((this.dMax - this.dMin) / this.dStep);
    }

    public String toString() {
        return "[ \"" + this.name + "\" [ " + this.dMin + " " + this.dStep + " " + this.dMax + " ]]";
    }

    @Override
    public Object getValueFromChoice(long choice, long maxNumChoices) {
        if (choice < (long)this.choiceCount()) {
            return this.dMin + this.dStep * (double)choice;
        }
        long wrappedChoice = StrictMath.round((double)(choice % (long)this.choiceCount()) / (double)(maxNumChoices - (long)this.choiceCount()) * (double)this.choiceCount());
        return this.dMin + this.dStep * (double)wrappedChoice;
    }

    @Override
    public long getChoiceIndexFromValue(Object val, long maxNumChoices) {
        if (!(val instanceof Number)) {
            System.out.println(val);
            throw new IllegalStateException("Type mismatch: can't represent a non-number using this double-valued parameter specification.");
        }
        double dVal = ((Number)val).doubleValue();
        return StrictMath.round((dVal - this.dMin) / this.dStep);
    }
}

