/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.contour;

import org.tinfour.common.IQuadEdge;
import org.tinfour.contour.Contour;
import org.tinfour.contour.TipLink;

class PerimeterLink {
    final int index;
    final IQuadEdge edge;
    PerimeterLink next;
    PerimeterLink prior;
    TipLink tip0;
    TipLink tip1;

    PerimeterLink(int index, IQuadEdge edge) {
        this.index = index;
        this.edge = edge;
    }

    void addContourTip(Contour contour, boolean contourStart) {
        TipLink tip = new TipLink(this, contour, contourStart);
        if (contourStart) {
            contour.startTip = tip;
        } else {
            contour.terminalTip = tip;
        }
        if (this.tip0 == null) {
            this.tip0 = tip;
            this.tip1 = tip;
        } else if (contourStart) {
            tip.next = this.tip0;
            this.tip0.prior = tip;
            this.tip0 = tip;
        } else {
            tip.prior = this.tip1;
            this.tip1.next = tip;
            this.tip1 = tip;
        }
    }

    public String toString() {
        if (this.prior == null || this.next == null) {
            return "Perimeter link " + this.index + ": " + this.edge.getIndex() + " (no links)";
        }
        return "Perimeter link " + this.index + ": " + this.prior.edge.getIndex() + " <- " + this.edge.getIndex() + " -> " + this.next.edge.getIndex();
    }
}

