/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.voronoi;

import java.awt.geom.Rectangle2D;
import java.util.List;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.voronoi.BoundedVoronoiDiagram;
import org.tinfour.voronoi.ThiessenPolygon;

public class BoundedVoronoiIntegrityCheck {
    String message;
    BoundedVoronoiDiagram lmv;

    public BoundedVoronoiIntegrityCheck(BoundedVoronoiDiagram BoundedVoronoi) {
        this.lmv = BoundedVoronoi;
        this.message = null;
    }

    public boolean inspect() {
        this.message = null;
        int maxEdgeIndex = this.lmv.getMaximumEdgeAllocationIndex();
        boolean[] visited = new boolean[maxEdgeIndex];
        List<ThiessenPolygon> polyList = this.lmv.getPolygons();
        for (int index = 0; index < polyList.size(); ++index) {
            IQuadEdge first;
            ThiessenPolygon poly = polyList.get(index);
            double area = poly.getArea();
            if (area <= 0.0) {
                this.message = "Polygon " + index + " has non-positive area " + area;
                return false;
            }
            List<IQuadEdge> eList = poly.getEdges();
            IQuadEdge edge = first = eList.get(0);
            IQuadEdge ePrior = first.getReverse();
            boolean synthetic = false;
            int n = 0;
            do {
                ++n;
                visited[edge.getIndex()] = true;
                synthetic |= edge.isSynthetic();
                Vertex vEdge = edge.getA();
                Vertex vPrior = ePrior.getB();
                double test = vPrior.getDistance(vEdge);
                if (test > 0.0) {
                    this.message = "Polygon " + index + " edge " + edge.getIndex() + " vertex mismatch with predecessor, dist=" + test + " vPrior=" + vPrior.getLabel() + ", vEdge=" + vEdge.getLabel();
                    return false;
                }
                ePrior = edge;
            } while (!(edge = edge.getForward()).equals(first));
            if (n != eList.size()) {
                this.message = "Polygon " + index + " edge list size not equal to count " + eList.size() + ", " + n;
                return false;
            }
            Vertex v = poly.getVertex();
            if (poly.isPointInPolygon(v.getX(), v.getY())) continue;
            this.message = "Vertex " + v.getLabel() + " fails point-in-polygon test for polygon " + index;
            return false;
        }
        List<IQuadEdge> eList = this.lmv.getEdges();
        for (IQuadEdge e : eList) {
            int index = e.getIndex();
            int n = (visited[index] ? 1 : 0) + (visited[index + 1] ? 1 : 0);
            if (e.isSynthetic()) {
                if (n == 1) continue;
                this.message = "Exterior edge " + index + " has polygon membership count of " + n;
                return false;
            }
            if (n == 2) continue;
            this.message = "Interior edge " + index + " has polygon membership of " + n;
            return false;
        }
        double sumArea = 0.0;
        for (ThiessenPolygon p : this.lmv.getPolygons()) {
            sumArea += p.getArea();
        }
        Rectangle2D bounds = this.lmv.getBounds();
        double boundsArea = bounds.getWidth() * bounds.getHeight();
        double meanArea = (boundsArea + sumArea) / 2.0;
        double areaTest = Math.abs(boundsArea - sumArea) / meanArea;
        if (areaTest > 0.001) {
            this.message = String.format("Sum of polygon area differs from bounds specification by more than %5.3f percent", areaTest * 100.0);
            return false;
        }
        return true;
    }

    public String getMessage() {
        if (this.message == null) {
            return "No Error Detected";
        }
        return this.message;
    }
}

