/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.model.fit.residuals;

import org.openimaj.math.model.Model;
import org.openimaj.math.model.fit.residuals.AbstractResidualCalculator;
import org.openimaj.util.comparator.DistanceComparator;
import org.openimaj.util.pair.IndependentPair;

public class DistanceComparatorResidual<I, D, M extends Model<I, D>>
extends AbstractResidualCalculator<I, D, M> {
    protected DistanceComparator<D> comparator;
    private int multiplier = 1;

    public DistanceComparatorResidual(DistanceComparator<D> comparator) {
        this.comparator = comparator;
        if (!comparator.isDistance()) {
            this.multiplier = -1;
        }
    }

    @Override
    public double computeResidual(IndependentPair<I, D> data) {
        Object predicted = this.model.predict(data.firstObject());
        return (double)this.multiplier * this.comparator.compare(data.getSecondObject(), predicted);
    }
}

