/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.util;

public class MathUtils {
    public static double logSum(double log_a, double log_b) {
        double v = log_a < log_b ? log_b + Math.log(1.0 + Math.exp(log_a - log_b)) : log_a + Math.log(1.0 + Math.exp(log_b - log_a));
        return v;
    }

    public static int nextPowerOf2(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    public static ExponentAndMantissa frexp(double value) {
        ExponentAndMantissa ret = new ExponentAndMantissa();
        ret.exponent = 0;
        ret.mantissa = 0.0;
        if (value == 0.0 || value == -0.0) {
            return ret;
        }
        if (Double.isNaN(value)) {
            ret.mantissa = Double.NaN;
            ret.exponent = -1;
            return ret;
        }
        if (Double.isInfinite(value)) {
            ret.mantissa = value;
            ret.exponent = -1;
            return ret;
        }
        ret.mantissa = value;
        ret.exponent = 0;
        int sign = 1;
        if (ret.mantissa < 0.0) {
            --sign;
            ret.mantissa = -ret.mantissa;
        }
        while (ret.mantissa < 0.5) {
            ret.mantissa *= 2.0;
            --ret.exponent;
        }
        while (ret.mantissa >= 1.0) {
            ret.mantissa *= 0.5;
            ++ret.exponent;
        }
        ret.mantissa *= (double)sign;
        return ret;
    }

    public static class ExponentAndMantissa {
        public int exponent;
        public double mantissa;
    }
}

