/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import net.lingala.zip4j.ZipFile;
import org.nlogo.core.LibraryInfo;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001i2QAB\u0004\u0001\u000f5A\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006IA\u0006\u0005\tA\u0001\u0011\t\u0011)A\u0005C!)q\u0005\u0001C\u0001Q!)Q\u0006\u0001C\u0001]!)q\u0007\u0001C\u0001q\t\u0011R\t\u001f;f]NLwN\\%ogR\fG\u000e\\3s\u0015\tA\u0011\"A\u0002ba&T!AC\u0006\u0002\u000b9dwnZ8\u000b\u00031\t1a\u001c:h'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VMZ\u0001\fkN,'/\u0012=u!\u0006$\bn\u0001\u0001\u0011\u0005]qR\"\u0001\r\u000b\u0005eQ\u0012\u0001\u00024jY\u0016T!a\u0007\u000f\u0002\u00079LwNC\u0001\u001e\u0003\u0011Q\u0017M^1\n\u0005}A\"\u0001\u0002)bi\"\f\u0001#\u001e8m_\u0006$W\t\u001f;f]NLwN\\:\u0011\u0007=\u0011C%\u0003\u0002$!\tIa)\u001e8di&|g\u000e\r\t\u0003\u001f\u0015J!A\n\t\u0003\tUs\u0017\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007%ZC\u0006\u0005\u0002+\u00015\tq\u0001C\u0003\u0015\u0007\u0001\u0007a\u0003C\u0003!\u0007\u0001\u0007\u0011%A\u0004j]N$\u0018\r\u001c7\u0015\u0005\u0011z\u0003\"\u0002\u0019\u0005\u0001\u0004\t\u0014aA3yiB\u0011!'N\u0007\u0002g)\u0011A'C\u0001\u0005G>\u0014X-\u0003\u00027g\tYA*\u001b2sCJL\u0018J\u001c4p\u0003%)h.\u001b8ti\u0006dG\u000e\u0006\u0002%s!)\u0001'\u0002a\u0001c\u0001")
public class ExtensionInstaller {
    private final Path userExtPath;
    private final Function0<BoxedUnit> unloadExtensions;

    public void install(LibraryInfo ext) {
        HttpURLConnection conn = (HttpURLConnection)ext.downloadURL().openConnection();
        if (conn.getResponseCode() == 200) {
            String urlPath = new StringOps(Predef$.MODULE$.augmentString(ext.downloadURL().getPath())).stripSuffix("/");
            Path zipPath = Files.createTempFile((String)new StringOps(Predef$.MODULE$.augmentString(urlPath.substring(urlPath.lastIndexOf(47) + 1))).dropRight(4), ".zip", new FileAttribute[0]);
            Files.copy(conn.getInputStream(), zipPath, StandardCopyOption.REPLACE_EXISTING);
            Path extDir = this.userExtPath.resolve(ext.codeName());
            if (!Files.isDirectory(extDir, new LinkOption[0])) {
                Files.createDirectory(extDir, new FileAttribute[0]);
            } else {
                this.unloadExtensions.apply$mcV$sp();
            }
            new ZipFile(zipPath.toFile()).extractAll(((Object)extDir).toString());
            Files.delete(zipPath);
        }
    }

    public void uninstall(LibraryInfo ext) {
        Path extDir = this.userExtPath.resolve(ext.codeName());
        if (Files.exists(extDir, new LinkOption[0])) {
            Files.walkFileTree(extDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(null){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    return this.delete(file);
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException ex) {
                    return this.delete(dir);
                }

                private FileVisitResult delete(Path path) {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public ExtensionInstaller(Path userExtPath, Function0<BoxedUnit> unloadExtensions) {
        this.userExtPath = userExtPath;
        this.unloadExtensions = unloadExtensions;
    }
}

