/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.io.PrintWriter;
import java.io.Serializable;
import org.nlogo.api.CSV;
import org.nlogo.api.Color$;
import org.nlogo.api.PlotInterface;
import org.nlogo.api.PlotPenInterface;
import org.nlogo.api.PlotPointInterface;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

@ScalaSignature(bytes="\u0006\u0001\u00153AAC\u0006\u0001%!AA\u0002\u0001BC\u0002\u0013%\u0011\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\u001b\u0011!\t\u0003A!b\u0001\n\u0013\u0011\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u000b\u001d\u0002A\u0011\u0001\u0015\t\u000b5\u0002A\u0011\u0001\u0018\t\u000bq\u0002A\u0011B\u001f\t\u000b}\u0002A\u0011\u0002!\t\u000b\t\u0003A\u0011B\"\u0003!\r{'/\u001a)m_R,\u0005\u0010]8si\u0016\u0014(B\u0001\u0007\u000e\u0003\u0011\u0001Hn\u001c;\u000b\u00059y\u0011!\u00028m_\u001e|'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-F\u0001\u001b!\tYb$D\u0001\u001d\u0015\tiR\"A\u0002ba&L!a\b\u000f\u0003\u001bAcw\u000e^%oi\u0016\u0014h-Y2f\u0003\u0015\u0001Hn\u001c;!\u0003\r\u00197O^\u000b\u0002GA\u00111\u0004J\u0005\u0003Kq\u00111aQ*W\u0003\u0011\u00197O\u001e\u0011\u0002\rqJg.\u001b;?)\rI3\u0006\f\t\u0003U\u0001i\u0011a\u0003\u0005\u0006\u0019\u0015\u0001\rA\u0007\u0005\u0006C\u0015\u0001\raI\u0001\u0007Kb\u0004xN\u001d;\u0015\u0005=\u0012\u0004C\u0001\u000b1\u0013\t\tTC\u0001\u0003V]&$\b\"B\u001a\u0007\u0001\u0004!\u0014AB<sSR,'\u000f\u0005\u00026u5\taG\u0003\u00028q\u0005\u0011\u0011n\u001c\u0006\u0002s\u0005!!.\u0019<b\u0013\tYdGA\u0006Qe&tGo\u0016:ji\u0016\u0014\u0018aC3ya>\u0014H/\u00138ue>$\"a\f \t\u000bM:\u0001\u0019\u0001\u001b\u0002\u0015\u0015D\bo\u001c:u!\u0016t7\u000f\u0006\u00020\u0003\")1\u0007\u0003a\u0001i\u0005aQ\r\u001f9peR\u0004v.\u001b8ugR\u0011q\u0006\u0012\u0005\u0006g%\u0001\r\u0001\u000e")
public class CorePlotExporter {
    private final PlotInterface plot;
    private final CSV csv;

    private PlotInterface plot() {
        return this.plot;
    }

    private CSV csv() {
        return this.csv;
    }

    public void export(PrintWriter writer) {
        this.exportIntro(writer);
        this.exportPens(writer);
        this.exportPoints(writer);
    }

    private void exportIntro(PrintWriter writer) {
        writer.println(this.csv().data(this.plot().name()));
        writer.println(this.csv().headerRow((String[])((Object[])new String[]{"x min", "x max", "y min", "y max", "autoplot?", "current pen", "legend open?", "number of pens"})));
        writer.println(this.csv().dataRow(new Object[]{BoxesRunTime.boxToDouble(this.plot().state().xMin()), BoxesRunTime.boxToDouble(this.plot().state().xMax()), BoxesRunTime.boxToDouble(this.plot().state().yMin()), BoxesRunTime.boxToDouble(this.plot().state().yMax()), BoxesRunTime.boxToBoolean(this.plot().state().autoPlotOn()), this.plot().currentPen().map((Function1<PlotPenInterface, String> & Serializable & scala.Serializable)x$1 -> x$1.name()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""), BoxesRunTime.boxToBoolean(this.plot().legendIsOpen()), BoxesRunTime.boxToInteger(this.plot().pens().size())}));
        writer.println();
    }

    private void exportPens(PrintWriter writer) {
        writer.println(this.csv().headerRow((String[])((Object[])new String[]{"pen name", "pen down?", "mode", "interval", "color", "x"})));
        this.plot().pens().foreach((Function1<PlotPenInterface, Object> & Serializable & scala.Serializable)pen -> {
            writer.println(this.csv().dataRow(new Object[]{pen.name(), BoxesRunTime.boxToBoolean(pen.state().isDown()), BoxesRunTime.boxToInteger(pen.state().mode()), BoxesRunTime.boxToDouble(pen.state().interval()), Color$.MODULE$.argbToColor(pen.state().color()), BoxesRunTime.boxToDouble(pen.state().x())}));
            return BoxedUnit.UNIT;
        });
        writer.println();
    }

    private void exportPoints(PrintWriter writer) {
        IntRef numPens = IntRef.create(0);
        this.plot().pens().foreach((Function1<PlotPenInterface, Object> & Serializable & scala.Serializable)pen -> {
            CorePlotExporter.$anonfun$exportPoints$1(this, numPens, writer, pen);
            return BoxedUnit.UNIT;
        });
        writer.println();
        Buffer pointHeaders = (Buffer)Buffer$.MODULE$.apply(Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPens.elem).foreach((Function1<Object, Buffer> & Serializable & scala.Serializable)i -> CorePlotExporter.$anonfun$exportPoints$2(pointHeaders, BoxesRunTime.unboxToInt(i)));
        writer.println(this.csv().headerRow((String[])pointHeaders.toArray(ClassTag$.MODULE$.apply(String.class))));
        Buffer penDataListsList = (Buffer)Buffer$.MODULE$.apply(Nil$.MODULE$);
        IntRef maxPenDataListSize = IntRef.create(0);
        this.plot().pens().foreach((Function1<PlotPenInterface, Buffer> & Serializable & scala.Serializable)pen -> {
            Seq penDataList = (Seq)Option$.MODULE$.apply(pen.points()).getOrElse((Function0<Vector> & Serializable & scala.Serializable)() -> (Vector)package$.MODULE$.Vector().apply(Nil$.MODULE$));
            maxPenDataListSize$1.elem = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(maxPenDataListSize$1.elem), penDataList.size());
            return penDataListsList.$plus$eq(penDataList);
        });
        PlotPointInterface[][] outColumnsArray = (PlotPointInterface[][])Array$.MODULE$.ofDim(maxPenDataListSize.elem, numPens.elem, ClassTag$.MODULE$.apply(PlotPointInterface.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPens.elem).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            Seq penDataList = (Seq)penDataListsList.apply(i);
            int penDataListSize = penDataList.size();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), penDataListSize).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)j -> {
                outColumnsArray$1[j][i$1] = (PlotPointInterface)penDataList.apply(j);
            });
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxPenDataListSize.elem).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)row -> {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPens$1.elem).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)col -> {
                if (outColumnsArray[row][col] != null) {
                    writer.print(this.csv().data(BoxesRunTime.boxToDouble(outColumnsArray[row][col].x())));
                    writer.print(",");
                    writer.print(this.csv().data(BoxesRunTime.boxToDouble(outColumnsArray[row][col].y())));
                    writer.print(",");
                    writer.print(this.csv().data(Color$.MODULE$.argbToColor(outColumnsArray[row][col].color())));
                    writer.print(",");
                    writer.print(this.csv().data(BoxesRunTime.boxToBoolean(outColumnsArray[row][col].isDown())));
                    if (col + 1 < numPens$1.elem) {
                        writer.print(",");
                        return;
                    }
                } else {
                    if (col + 1 < numPens$1.elem) {
                        writer.print(",,,,");
                        return;
                    }
                    writer.print(",,,");
                }
            });
            writer.println();
        });
    }

    public static final /* synthetic */ void $anonfun$exportPoints$1(CorePlotExporter $this, IntRef numPens$1, PrintWriter writer$2, PlotPenInterface pen) {
        if (numPens$1.elem > 0) {
            writer$2.print(",,,,");
        }
        writer$2.print($this.csv().data(pen.name()));
        ++numPens$1.elem;
    }

    public static final /* synthetic */ Buffer $anonfun$exportPoints$2(Buffer pointHeaders$1, int i) {
        return (Buffer)pointHeaders$1.$plus$eq("x", "y", Predef$.MODULE$.wrapRefArray((Object[])new String[]{"color", "pen down?"}));
    }

    public CorePlotExporter(PlotInterface plot, CSV csv) {
        this.plot = plot;
        this.csv = csv;
    }
}

