/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm;

import java.io.Serializable;
import org.nlogo.sdm.Converter;
import org.nlogo.sdm.EOLToken$;
import org.nlogo.sdm.Model;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.Rate;
import org.nlogo.sdm.Reservoir;
import org.nlogo.sdm.Stock;
import org.nlogo.sdm.Tokenizer;
import org.nlogo.sdm.WordToken;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class Loader$ {
    public static Loader$ MODULE$;

    static {
        new Loader$();
    }

    public Option<Model> load(String input) {
        Option option;
        Seq lines = Source$.MODULE$.fromString(this.mungeClassNames(input)).getLines().map((Function1<String, String> & Serializable & scala.Serializable)x$1 -> x$1.trim()).filter((Function1<String, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(Loader$.$anonfun$load$2(x$2))).toSeq();
        Option option2 = lines.headOption();
        if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else if (option2 instanceof Some) {
            String dt = (String)((Some)option2).value();
            Model model = this.buildModel(new Tokenizer(((TraversableOnce)lines.tail()).mkString("", "\n", "\n")), new StringOps(Predef$.MODULE$.augmentString(dt)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(input)).lines().drop(1).mkString("\n"));
            option = new Some<Model>(model);
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    public String mungeClassNames(String input) {
        return input.replaceAll(" *org.nlogo.sdm.Stock ", "org.nlogo.sdm.gui.WrappedStock ").replaceAll(" *org.nlogo.sdm.Rate ", "org.nlogo.sdm.gui.WrappedRate ").replaceAll(" *org.nlogo.sdm.Reservoir ", "org.nlogo.sdm.gui.WrappedReservoir").replaceAll(" *org.nlogo.sdm.Converter ", "org.nlogo.sdm.gui.WrappedConverter").replaceAll("org.nlogo.aggregate.gui", "org.nlogo.sdm.gui");
    }

    private Model buildModel(Tokenizer tokens, double dt, String serializedGUI) {
        scala.collection.mutable.Map lineMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        ObjectRef<Object> model = ObjectRef.create(null);
        block0: while (tokens.hasNext()) {
            Product product = tokens.next();
            if (product instanceof WordToken) {
                String name = ((WordToken)product).s();
                this.readElement(name, tokens).foreach((Function1<ModelElement, Object> & Serializable & scala.Serializable)me -> {
                    Loader$.$anonfun$buildModel$1(model, tokens, serializedGUI, dt, lineMap, me);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new Exception("Invalid SDM Model");
            }
            while (tokens.hasNext()) {
                Product product2 = tokens.next();
                EOLToken$ eOLToken$ = EOLToken$.MODULE$;
                if (!(product2 == null ? eOLToken$ != null : !product2.equals(eOLToken$))) continue block0;
            }
        }
        return (Model)model.elem;
    }

    private Option<ModelElement> readElement(String name, Tokenizer tokens) {
        Option option;
        if ("org.nlogo.sdm.gui.WrappedStock".equals(name)) {
            Stock stock = new Stock();
            stock.setName(tokens.string());
            stock.setInitialValueExpression(tokens.string());
            stock.setNonNegative(tokens.boolean());
            option = new Some<Stock>(stock);
        } else if ("org.nlogo.sdm.gui.WrappedRate".equals(name)) {
            Rate rate = new Rate();
            rate.setExpression(tokens.string());
            rate.setName(tokens.string());
            option = new Some<Rate>(rate);
        } else if ("org.nlogo.sdm.gui.WrappedConverter".equals(name)) {
            Converter converter = new Converter();
            converter.setExpression(tokens.string());
            converter.setName(tokens.string());
            option = new Some<Converter>(converter);
        } else if ("org.nlogo.sdm.gui.AggregateDrawing".equals(name)) {
            Model model = new Model("Test Model", 1.0);
            option = new Some<Model>(model);
        } else {
            boolean bl = "org.nlogo.sdm.gui.ReservoirFigure".equals(name) ? true : ("org.nlogo.sdm.gui.StockFigure".equals(name) ? true : ("org.nlogo.sdm.gui.RateConnection".equals(name) ? true : ("org.jhotdraw.contrib.ChopDiamondConnector".equals(name) ? true : ("org.jhotdraw.standard.ChopBoxConnector".equals(name) ? true : ("org.nlogo.sdm.gui.WrappedReservoir".equals(name) ? true : ("org.nlogo.sdm.gui.ConverterFigure".equals(name) ? true : ("org.nlogo.sdm.gui.BindingConnection".equals(name) ? true : ("org.jhotdraw.figures.ChopEllipseConnector".equals(name) ? true : "org.nlogo.sdm.gui.ChopRateConnector".equals(name)))))))));
            if (bl) {
                option = None$.MODULE$;
            } else {
                throw new MatchError((Object)name);
            }
        }
        return option;
    }

    private void setSourceSink(Rate rate, Tokenizer tokens, Map<Object, ModelElement> lineMap) {
        String string2;
        Product product = tokens.next();
        if (product instanceof WordToken && "REF".equals(string2 = ((WordToken)product).s())) {
            String string3;
            rate.setSource(this.getSourceOrSink(tokens, lineMap));
            Product product2 = tokens.next();
            Stock stock = product2 instanceof WordToken && "REF".equals(string3 = ((WordToken)product2).s()) ? this.getSourceOrSink(tokens, lineMap) : new Reservoir();
            rate.setSink(stock);
            return;
        }
        tokens.next();
        tokens.next();
        rate.setSink(this.getSourceOrSink(tokens, lineMap));
        rate.setSource(this.getSourceOrSink(tokens, lineMap));
    }

    private Stock getSourceOrSink(Tokenizer tokens, Map<Object, ModelElement> lineMap) {
        return (Stock)lineMap.get(BoxesRunTime.boxToInteger(tokens.number() + 1)).map((Function1<ModelElement, Stock> & Serializable & scala.Serializable)x$3 -> (Stock)x$3).getOrElse((Function0<Reservoir> & Serializable & scala.Serializable)() -> new Reservoir());
    }

    public static final /* synthetic */ boolean $anonfun$load$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$buildModel$1(ObjectRef model$1, Tokenizer tokens$1, String serializedGUI$1, double dt$1, scala.collection.mutable.Map lineMap$1, ModelElement me) {
        if (me instanceof Model) {
            Model model = (Model)me;
            Predef$.MODULE$.require((Model)model$1.elem == null, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> tokens$1.diagnostics());
            String x$2 = model.copy$default$1();
            double x$3 = model.copy$default$2();
            ListBuffer<ModelElement> x$4 = model.copy$default$3();
            model$1.elem = model.copy(x$2, x$3, x$4, serializedGUI$1);
            ((Model)model$1.elem).setDt(dt$1);
        } else if (me instanceof Stock) {
            Stock stock = (Stock)me;
            lineMap$1.update(BoxesRunTime.boxToInteger(tokens$1.lineNumber()), stock);
        } else if (me instanceof Rate) {
            Rate rate = (Rate)me;
            MODULE$.setSourceSink(rate, tokens$1, lineMap$1);
        }
        ((Model)model$1.elem).addElement(me);
    }

    private Loader$() {
        MODULE$ = this;
    }
}

