/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.aac.blocks;

import org.jcodec.codecs.aac.ChannelPosition;
import org.jcodec.codecs.aac.blocks.Block;
import org.jcodec.codecs.aac.blocks.RawDataBlockType;
import org.jcodec.common.io.BitReader;

public class BlockPCE
extends Block {
    private static final int MAX_ELEM_ID = 16;

    @Override
    public void parse(BitReader in) {
        in.readNBit(2);
        int samplingIndex = in.readNBit(4);
        int num_front = in.readNBit(4);
        int num_side = in.readNBit(4);
        int num_back = in.readNBit(4);
        int num_lfe = in.readNBit(2);
        int num_assoc_data = in.readNBit(3);
        int num_cc = in.readNBit(4);
        if (in.read1Bit() != 0) {
            in.readNBit(4);
        }
        if (in.read1Bit() != 0) {
            in.readNBit(4);
        }
        if (in.read1Bit() != 0) {
            in.readNBit(3);
        }
        ChannelMapping[] layout_map = new ChannelMapping[64];
        int tags = 0;
        this.decodeChannelMap(layout_map, tags, ChannelPosition.AAC_CHANNEL_FRONT, in, num_front);
        tags = num_front;
        this.decodeChannelMap(layout_map, tags, ChannelPosition.AAC_CHANNEL_SIDE, in, num_side);
        this.decodeChannelMap(layout_map, tags += num_side, ChannelPosition.AAC_CHANNEL_BACK, in, num_back);
        this.decodeChannelMap(layout_map, tags += num_back, ChannelPosition.AAC_CHANNEL_LFE, in, num_lfe);
        in.skip(4 * num_assoc_data);
        this.decodeChannelMap(layout_map, tags += num_lfe, ChannelPosition.AAC_CHANNEL_CC, in, num_cc);
        tags += num_cc;
        in.align();
        int comment_len = in.readNBit(8) * 8;
        in.skip(comment_len);
    }

    private void decodeChannelMap(ChannelMapping[] layout_map, int offset, ChannelPosition type, BitReader in, int n) {
        while (n-- > 0) {
            RawDataBlockType syn_ele = null;
            switch (type) {
                case AAC_CHANNEL_FRONT: 
                case AAC_CHANNEL_BACK: 
                case AAC_CHANNEL_SIDE: {
                    syn_ele = RawDataBlockType.fromOrdinal(in.read1Bit());
                    break;
                }
                case AAC_CHANNEL_CC: {
                    in.read1Bit();
                    syn_ele = RawDataBlockType.TYPE_CCE;
                    break;
                }
                case AAC_CHANNEL_LFE: {
                    syn_ele = RawDataBlockType.TYPE_LFE;
                }
            }
            layout_map[offset].syn_ele = syn_ele;
            layout_map[offset].someInt = in.readNBit(4);
            layout_map[offset].position = type;
            ++offset;
        }
    }

    public static class ChannelMapping {
        RawDataBlockType syn_ele;
        int someInt;
        ChannelPosition position;
    }
}

