/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.codecs.h264.encode.H264FixedRateControl;
import org.jcodec.codecs.mpeg12.MPEGDecoder;
import org.jcodec.codecs.mpeg12.MPEGUtil;
import org.jcodec.codecs.mpeg12.bitstream.PictureHeader;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.Size;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.MPEGToAVCTranscoder;
import org.jcodec.movtool.streaming.tracks.Transcode2AVCTrack;
import org.jcodec.movtool.streaming.tracks.VirtualPacketWrapper;

public class Mpeg2AVCTrack
implements VirtualTrack {
    public static final int TARGET_RATE = 1024;
    private int frameSize;
    protected VirtualTrack src;
    private CodecMeta se;
    private ThreadLocal<MPEGToAVCTranscoder> transcoders = new ThreadLocal();
    int mbW;
    int mbH;
    int scaleFactor;
    int thumbWidth;
    int thumbHeight;
    private GOP gop;
    private GOP prevGop;
    private VirtualPacket nextPacket;

    protected void checkFourCC(VirtualTrack srcTrack) {
        String fourcc = srcTrack.getCodecMeta().getFourcc();
        if (!"m2v1".equals(fourcc)) {
            throw new IllegalArgumentException("Input track is not ProRes");
        }
    }

    protected int selectScaleFactor(Size frameDim) {
        return frameDim.getWidth() >= 960 ? 2 : (frameDim.getWidth() > 480 ? 1 : 0);
    }

    public Mpeg2AVCTrack(VirtualTrack src) throws IOException {
        this.checkFourCC(src);
        this.src = src;
        H264FixedRateControl rc = new H264FixedRateControl(1024);
        H264Encoder encoder = new H264Encoder(rc);
        this.nextPacket = src.nextPacket();
        Size frameDim = MPEGDecoder.getSize(this.nextPacket.getData());
        this.scaleFactor = this.selectScaleFactor(frameDim);
        this.thumbWidth = frameDim.getWidth() >> this.scaleFactor;
        this.thumbHeight = frameDim.getHeight() >> this.scaleFactor & 0xFFFFFFFE;
        this.mbW = this.thumbWidth + 15 >> 4;
        this.mbH = this.thumbHeight + 15 >> 4;
        this.se = Transcode2AVCTrack.createCodecMeta(src, encoder, this.thumbWidth, this.thumbHeight);
        this.frameSize = rc.calcFrameSize(this.mbW * this.mbH);
        this.frameSize += this.frameSize >> 4;
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.se;
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        if (this.nextPacket == null) {
            return null;
        }
        if (this.nextPacket.isKeyframe()) {
            this.prevGop = this.gop;
            this.gop = new GOP(this.nextPacket.getFrameNo(), this.prevGop);
            if (this.prevGop != null) {
                this.prevGop.setNextGop(this.gop);
            }
        }
        VirtualPacket ret = this.gop.addPacket(this.nextPacket);
        this.nextPacket = this.src.nextPacket();
        return ret;
    }

    protected MPEGToAVCTranscoder createTranscoder(int scaleFactor) {
        return new MPEGToAVCTranscoder(scaleFactor);
    }

    public static int getPicType(ByteBuffer buf) {
        ByteBuffer segment;
        while ((segment = MPEGUtil.nextSegment(buf)) != null) {
            int code = segment.getInt() & 0xFF;
            if (code != 0) continue;
            PictureHeader ph = PictureHeader.read(segment);
            return ph.picture_coding_type;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return this.src.getEdits();
    }

    @Override
    public int getPreferredTimescale() {
        return this.src.getPreferredTimescale();
    }

    private class TranscodePacket
    extends VirtualPacketWrapper {
        private GOP gop;
        private int index;

        public TranscodePacket(VirtualPacket nextPacket, GOP gop, int index) {
            super(nextPacket);
            this.gop = gop;
            this.index = index;
        }

        @Override
        public int getDataLen() {
            return Mpeg2AVCTrack.this.frameSize;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            return this.gop.getData(this.index);
        }
    }

    private class GOP {
        private List<VirtualPacket> packets = new ArrayList<VirtualPacket>();
        private ByteBuffer[] data;
        private int frameNo;
        private GOP nextGop;
        private GOP prevGop;
        private List<ByteBuffer> leadingB;

        public GOP(int frameNo, GOP prevGop) {
            this.frameNo = frameNo;
            this.prevGop = prevGop;
        }

        public void setNextGop(GOP gop) {
            this.nextGop = gop;
        }

        public VirtualPacket addPacket(VirtualPacket pkt) {
            this.packets.add(pkt);
            return new TranscodePacket(pkt, this, this.packets.size() - 1);
        }

        private synchronized void transcode() throws IOException {
            if (this.data != null) {
                return;
            }
            this.data = new ByteBuffer[this.packets.size()];
            block2: for (int tr = 0; tr < 2; ++tr) {
                try {
                    ByteBuffer buf;
                    int picType;
                    ByteBuffer pktData;
                    VirtualPacket pkt;
                    int i;
                    MPEGToAVCTranscoder t = (MPEGToAVCTranscoder)Mpeg2AVCTrack.this.transcoders.get();
                    if (t == null) {
                        t = Mpeg2AVCTrack.this.createTranscoder(Mpeg2AVCTrack.this.scaleFactor);
                        Mpeg2AVCTrack.this.transcoders.set(t);
                    }
                    this.carryLeadingBOver();
                    double[] pts = this.collectPts(this.packets);
                    int numRefs = 0;
                    for (i = 0; i < this.packets.size(); ++i) {
                        pkt = this.packets.get(i);
                        pktData = pkt.getData();
                        picType = Mpeg2AVCTrack.getPicType(pktData.duplicate());
                        if (picType != 3) {
                            ++numRefs;
                        } else if (numRefs < 2) continue;
                        buf = ByteBuffer.allocate(Mpeg2AVCTrack.this.frameSize);
                        this.data[i] = t.transcodeFrame(pktData, buf, i == 0, Arrays.binarySearch(pts, pkt.getPts()));
                    }
                    if (this.nextGop == null) break;
                    this.nextGop.leadingB = new ArrayList<ByteBuffer>();
                    pts = this.collectPts(this.nextGop.packets);
                    numRefs = 0;
                    for (i = 0; i < this.nextGop.packets.size(); ++i) {
                        pkt = this.nextGop.packets.get(i);
                        pktData = pkt.getData();
                        picType = Mpeg2AVCTrack.getPicType(pktData.duplicate());
                        if (picType != 3) {
                            ++numRefs;
                        }
                        if (numRefs >= 2) break block2;
                        buf = ByteBuffer.allocate(Mpeg2AVCTrack.this.frameSize);
                        this.nextGop.leadingB.add(t.transcodeFrame(pktData, buf, i == 0, Arrays.binarySearch(pts, pkt.getPts())));
                    }
                    break;
                }
                catch (Throwable t) {
                    Logger.error("Error transcoding gop: " + t.getMessage() + ", retrying.");
                    continue;
                }
            }
        }

        private double[] collectPts(List<VirtualPacket> packets2) {
            double[] pts = new double[packets2.size()];
            for (int i = 0; i < pts.length; ++i) {
                pts[i] = packets2.get(i).getPts();
            }
            Arrays.sort(pts);
            return pts;
        }

        private synchronized void carryLeadingBOver() {
            if (this.leadingB != null) {
                for (int i = 0; i < this.leadingB.size(); ++i) {
                    this.data[i] = this.leadingB.get(i);
                }
            }
        }

        public ByteBuffer getData(int i) throws IOException {
            this.transcode();
            if (this.data[i] == null && this.prevGop != null) {
                this.prevGop.transcode();
                this.carryLeadingBOver();
            }
            return this.data[i];
        }
    }
}

