/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data.dataset;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Set;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.io.ObjectReader;
import org.openimaj.util.iterator.ConcatenatedIterable;

public abstract class ReadableGroupDataset<KEY, DATASET extends Dataset<INSTANCE>, INSTANCE, SOURCE>
extends AbstractMap<KEY, DATASET>
implements GroupedDataset<KEY, DATASET, INSTANCE> {
    protected ObjectReader<INSTANCE, SOURCE> reader;

    public ReadableGroupDataset(ObjectReader<INSTANCE, SOURCE> reader) {
        this.reader = reader;
    }

    @Override
    public INSTANCE getRandomInstance() {
        int index = (int)(Math.random() * (double)this.numInstances());
        int count = 0;
        for (KEY key : this.getGroups()) {
            DATASET group = this.getInstances(key);
            if (count + group.numInstances() > index) {
                if (group instanceof ListDataset) {
                    return (INSTANCE)((ListDataset)group).get(index - count);
                }
                for (Object i : group) {
                    if (index == count) {
                        return (INSTANCE)i;
                    }
                    ++count;
                }
                continue;
            }
            count += group.numInstances();
        }
        return null;
    }

    @Override
    public int numInstances() {
        int size = 0;
        for (KEY key : this.getGroups()) {
            size += this.getInstances(key).numInstances();
        }
        return size;
    }

    @Override
    public Iterator<INSTANCE> iterator() {
        return new ConcatenatedIterable(this.values()).iterator();
    }

    @Override
    public DATASET getInstances(KEY key) {
        return (DATASET)((Dataset)this.get(key));
    }

    @Override
    public Set<KEY> getGroups() {
        return this.keySet();
    }

    @Override
    public INSTANCE getRandomInstance(KEY key) {
        return ((Dataset)this.get(key)).getRandomInstance();
    }
}

