/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data.dataset;

import java.util.AbstractList;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.identity.IdentifiableObject;
import org.openimaj.io.ObjectReader;

public abstract class ReadableListDataset<INSTANCE, SOURCE>
extends AbstractList<INSTANCE>
implements ListDataset<INSTANCE> {
    protected ObjectReader<INSTANCE, SOURCE> reader;

    public ReadableListDataset(ObjectReader<INSTANCE, SOURCE> reader) {
        this.reader = reader;
    }

    @Override
    public INSTANCE getRandomInstance() {
        return this.getInstance((int)(Math.random() * (double)this.size()));
    }

    @Override
    public INSTANCE get(int index) {
        return this.getInstance(index);
    }

    public String getID(int index) {
        return index + "";
    }

    public int indexOfID(String id) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getID(i).equals(id)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int size() {
        return this.numInstances();
    }

    public ListDataset<IdentifiableObject<INSTANCE>> toIdentifiable() {
        return new WrappedListDataset(this);
    }

    private class WrappedListDataset
    extends AbstractList<IdentifiableObject<INSTANCE>>
    implements ListDataset<IdentifiableObject<INSTANCE>> {
        private final ReadableListDataset<INSTANCE, SOURCE> internal;

        WrappedListDataset(ReadableListDataset<INSTANCE, SOURCE> internal) {
            this.internal = internal;
        }

        @Override
        public IdentifiableObject<INSTANCE> getRandomInstance() {
            int index = (int)(Math.random() * (double)this.size());
            return this.getInstance(index);
        }

        @Override
        public IdentifiableObject<INSTANCE> getInstance(int index) {
            return new IdentifiableObject(this.internal.getID(index), this.internal.getInstance(index));
        }

        @Override
        public IdentifiableObject<INSTANCE> get(int index) {
            return this.getInstance(index);
        }

        @Override
        public int size() {
            return this.internal.size();
        }

        @Override
        public int numInstances() {
            return this.internal.size();
        }
    }
}

