/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import org.testng.remote.strprotocol.IMessage;
import org.testng.remote.strprotocol.IStringMessage;

public class StringMessageSenderHelper {
    private boolean m_debugMode = false;
    private Socket m_clientSocket;
    private String m_host;
    private int m_port;
    private PrintWriter m_outStream;
    private BufferedReader m_inStream;
    private ReaderThread m_readerThread;
    private Object lock = new Object();

    public StringMessageSenderHelper(String host, int port) {
        this.m_host = host;
        this.m_port = port;
    }

    public boolean connect() {
        if (this.m_debugMode) {
            StringMessageSenderHelper.ppp("trying to connect " + this.m_host + ":" + this.m_port);
        }
        Throwable exception = null;
        for (int i = 1; i < 20; ++i) {
            try {
                this.m_clientSocket = new Socket(this.m_host, this.m_port);
                try {
                    this.m_outStream = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.m_clientSocket.getOutputStream(), "UTF-8")), false);
                }
                catch (UnsupportedEncodingException e1) {
                    this.m_outStream = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.m_clientSocket.getOutputStream())), false);
                }
                try {
                    this.m_inStream = new BufferedReader(new InputStreamReader(this.m_clientSocket.getInputStream(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e1) {
                    this.m_inStream = new BufferedReader(new InputStreamReader(this.m_clientSocket.getInputStream()));
                }
                this.m_readerThread = new ReaderThread();
                this.m_readerThread.start();
                return true;
            }
            catch (IOException ioe) {
                exception = ioe;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        exception.printStackTrace();
        return false;
    }

    public void shutDown() {
        block8: {
            if (null != this.m_outStream) {
                this.m_outStream.close();
                this.m_outStream = null;
            }
            try {
                if (null != this.m_readerThread) {
                    this.m_readerThread.interrupt();
                }
                if (null != this.m_inStream) {
                    this.m_inStream.close();
                    this.m_inStream = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (null != this.m_clientSocket) {
                    this.m_clientSocket.close();
                    this.m_clientSocket = null;
                }
            }
            catch (IOException e) {
                if (!this.m_debugMode) break block8;
                e.printStackTrace();
            }
        }
    }

    public void sendMessage(IMessage message) {
        throw new UnsupportedOperationException("This operation is too generic yet.");
    }

    public void sendMessage(IStringMessage message) {
        this.sendMessage(message.getMessageAsString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(String msg) {
        if (null == this.m_outStream) {
            StringMessageSenderHelper.ppp("WARNING the outputstream is null. Cannot send message.");
            return;
        }
        if (this.m_debugMode) {
            StringMessageSenderHelper.ppp(msg);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < msg.length(); ++i) {
                if ('\u0001' == msg.charAt(i)) {
                    StringMessageSenderHelper.ppp("word:[" + buf.toString() + "]");
                    buf.delete(0, buf.length());
                    continue;
                }
                buf.append(msg.charAt(i));
            }
            StringMessageSenderHelper.ppp("word:[" + buf.toString() + "]");
        }
        Object object = this.lock;
        synchronized (object) {
            this.m_outStream.println(msg);
            this.m_outStream.flush();
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void ppp(String msg) {
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread() {
            super("ReaderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: {
                try {
                    String message;
                    if (StringMessageSenderHelper.this.m_inStream == null) break block7;
                    while ((message = StringMessageSenderHelper.this.m_inStream.readLine()) != null) {
                        if (StringMessageSenderHelper.this.m_debugMode) {
                            StringMessageSenderHelper.ppp("Reply:" + message);
                        }
                        boolean acknowledge = ">ACK".equals(message);
                        boolean stop = ">STOP".equals(message);
                        if (!acknowledge && !stop) continue;
                        Object object = StringMessageSenderHelper.this.lock;
                        synchronized (object) {
                            StringMessageSenderHelper.this.lock.notifyAll();
                        }
                        if (!stop) continue;
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

