/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.index.fielddata.DoubleScriptDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.plain.LeafDoubleFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public final class DoubleScriptFieldData
extends IndexNumericFieldData {
    private final String fieldName;
    DoubleFieldScript.LeafFactory leafFactory;

    private DoubleScriptFieldData(String fieldName, DoubleFieldScript.LeafFactory leafFactory) {
        this.fieldName = fieldName;
        this.leafFactory = leafFactory;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    @Override
    public DoubleScriptLeafFieldData load(LeafReaderContext context) {
        try {
            return this.loadDirect(context);
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    @Override
    public DoubleScriptLeafFieldData loadDirect(LeafReaderContext context) {
        return new DoubleScriptLeafFieldData(new DoubleScriptDocValues(this.leafFactory.newInstance(context)));
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.DOUBLE;
    }

    @Override
    protected boolean sortRequiresCustomComparator() {
        return true;
    }

    public static class DoubleScriptLeafFieldData
    extends LeafDoubleFieldData {
        private final DoubleScriptDocValues doubleScriptDocValues;

        DoubleScriptLeafFieldData(DoubleScriptDocValues doubleScriptDocValues) {
            super(0L);
            this.doubleScriptDocValues = doubleScriptDocValues;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            return this.doubleScriptDocValues;
        }

        @Override
        public void close() {
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final DoubleFieldScript.LeafFactory leafFactory;

        public Builder(String name, DoubleFieldScript.LeafFactory leafFactory) {
            this.name = name;
            this.leafFactory = leafFactory;
        }

        public DoubleScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new DoubleScriptFieldData(this.name, this.leafFactory);
        }
    }
}

