/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.util.Objects;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;

public class TimeValueSchedule
implements SchedulerEngine.Schedule {
    private TimeValue interval;

    public TimeValueSchedule(TimeValue interval) {
        if (interval.millis() <= 0L) {
            throw new IllegalArgumentException("interval must be greater than 0 milliseconds");
        }
        this.interval = interval;
    }

    public TimeValue getInterval() {
        return this.interval;
    }

    public long nextScheduledTimeAfter(long startTime, long time) {
        assert (time >= startTime);
        if (startTime == time) {
            ++time;
        }
        long delta = time - startTime;
        return startTime + (delta / this.interval.millis() + 1L) * this.interval.millis();
    }

    public int hashCode() {
        return Objects.hash(this.interval);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeValueSchedule other = (TimeValueSchedule)obj;
        return Objects.equals(this.interval, other.interval);
    }
}

