/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.filter;

import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.privilege.HealthAndStatsPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.security.action.SecurityActionMapper;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;

public class SecurityActionFilter
implements ActionFilter {
    private static final Predicate<String> LICENSE_EXPIRATION_ACTION_MATCHER = HealthAndStatsPrivilege.INSTANCE.predicate();
    private static final Predicate<String> SECURITY_ACTION_MATCHER = Automatons.predicate((String[])new String[]{"cluster:admin/xpack/security*"});
    private static final Logger logger = LogManager.getLogger(SecurityActionFilter.class);
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final AuditTrailService auditTrailService;
    private final SecurityActionMapper actionMapper = new SecurityActionMapper();
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final SecurityContext securityContext;
    private final DestructiveOperations destructiveOperations;

    public SecurityActionFilter(AuthenticationService authcService, AuthorizationService authzService, AuditTrailService auditTrailService, XPackLicenseState licenseState, ThreadPool threadPool, SecurityContext securityContext, DestructiveOperations destructiveOperations) {
        this.authcService = authcService;
        this.authzService = authzService;
        this.auditTrailService = auditTrailService;
        this.licenseState = licenseState;
        this.threadContext = threadPool.getThreadContext();
        this.securityContext = securityContext;
        this.destructiveOperations = destructiveOperations;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        block17: {
            if (!this.licenseState.isActive() && LICENSE_EXPIRATION_ACTION_MATCHER.test(action)) {
                logger.error("blocking [{}] operation due to expired license. Cluster health, cluster stats and indices stats \noperations are blocked on license expiration. All data operations (read and write) continue to work. \nIf you have a new license, please update it. Otherwise, please reach out to your support contact.", (Object)action);
                throw LicenseUtils.newComplianceException((String)"security");
            }
            if (this.licenseState.isSecurityEnabled()) {
                ContextPreservingActionListener contextPreservingListener = ContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)this.threadContext);
                boolean useSystemUser = AuthorizationUtils.shouldReplaceUserWithSystem(this.threadContext, action);
                try {
                    if (useSystemUser) {
                        this.securityContext.executeAsUser(SystemUser.INSTANCE, arg_0 -> this.lambda$apply$0(task, chain, action, request, (ActionListener)contextPreservingListener, arg_0), Version.CURRENT);
                        break block17;
                    }
                    if (AuthorizationUtils.shouldSetUserBasedOnActionOrigin(this.threadContext)) {
                        AuthorizationUtils.switchUserBasedOnActionOriginAndExecute(this.threadContext, this.securityContext, arg_0 -> this.lambda$apply$1(task, chain, action, request, (ActionListener)contextPreservingListener, arg_0));
                        break block17;
                    }
                    try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext(true);){
                        this.applyInternal(task, chain, action, request, (ActionListener<Response>)contextPreservingListener);
                    }
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            } else if (SECURITY_ACTION_MATCHER.test(action)) {
                if (!this.licenseState.isSecurityEnabled()) {
                    listener.onFailure((Exception)new ElasticsearchException("Security must be explicitly enabled when using a [" + this.licenseState.getOperationMode().description() + "] license. Enable security by setting [xpack.security.enabled] to [true] in the elasticsearch.yml file and restart the node.", new Object[0]));
                } else {
                    listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"security"));
                }
            } else {
                chain.proceed(task, action, request, listener);
            }
        }
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    private <Request extends ActionRequest, Response extends ActionResponse> void applyInternal(Task task, ActionFilterChain<Request, Response> chain, String action, Request request, ActionListener<Response> listener) {
        if ("indices:admin/close".equals(action) || "indices:admin/open".equals(action) || "indices:admin/delete".equals(action)) {
            IndicesRequest indicesRequest = (IndicesRequest)request;
            try {
                this.destructiveOperations.failDestructive(indicesRequest.indices());
            }
            catch (IllegalArgumentException e) {
                listener.onFailure((Exception)e);
                return;
            }
        }
        String securityAction = this.actionMapper.action(action, (TransportRequest)request);
        this.authcService.authenticate(securityAction, (TransportRequest)request, SystemUser.INSTANCE, (ActionListener<Authentication>)ActionListener.wrap(authc -> {
            if (authc != null) {
                String requestId = AuditUtil.extractRequestId(this.threadContext);
                assert (Strings.hasText((String)requestId));
                this.authzService.authorize((Authentication)authc, securityAction, (TransportRequest)request, (ActionListener<Void>)listener.delegateFailure((ll, aVoid) -> chain.proceed(task, action, request, ll.delegateFailure((l, response) -> {
                    this.auditTrailService.get().coordinatingActionResponse(requestId, (Authentication)authc, action, (TransportRequest)request, (TransportResponse)response);
                    l.onResponse(response);
                }))));
            } else if (!this.licenseState.isSecurityEnabled()) {
                listener.onResponse(null);
            } else {
                listener.onFailure((Exception)new IllegalStateException("no authentication present but auth is allowed"));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private /* synthetic */ void lambda$apply$1(Task task, ActionFilterChain chain, String action, ActionRequest request, ActionListener contextPreservingListener, ThreadContext.StoredContext original) {
        this.applyInternal(task, chain, action, request, contextPreservingListener);
    }

    private /* synthetic */ void lambda$apply$0(Task task, ActionFilterChain chain, String action, ActionRequest request, ActionListener contextPreservingListener, ThreadContext.StoredContext original) {
        this.applyInternal(task, chain, action, request, contextPreservingListener);
    }
}

