/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.ml.job.process.normalizer.BucketNormalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.Normalizable;

public class JobRenormalizedResultsPersister {
    private static final Logger logger = LogManager.getLogger(JobRenormalizedResultsPersister.class);
    static final int BULK_LIMIT = 10000;
    private final String jobId;
    private final Client client;
    private BulkRequest bulkRequest;

    public JobRenormalizedResultsPersister(String jobId, Client client) {
        this.jobId = jobId;
        this.client = client;
        this.bulkRequest = new BulkRequest();
    }

    public void updateBucket(BucketNormalizable normalizable) {
        this.updateResult(normalizable.getId(), normalizable.getOriginatingIndex(), (ToXContent)normalizable.getBucket());
        this.updateBucketInfluencersStandalone(normalizable.getOriginatingIndex(), normalizable.getBucket().getBucketInfluencers());
    }

    private void updateBucketInfluencersStandalone(String indexName, List<BucketInfluencer> bucketInfluencers) {
        if (bucketInfluencers != null && !bucketInfluencers.isEmpty()) {
            for (BucketInfluencer bucketInfluencer : bucketInfluencers) {
                this.updateResult(bucketInfluencer.getId(), indexName, (ToXContent)bucketInfluencer);
            }
        }
    }

    public void updateResults(List<Normalizable> normalizables) {
        for (Normalizable normalizable : normalizables) {
            this.updateResult(normalizable.getId(), normalizable.getOriginatingIndex(), (ToXContent)normalizable);
        }
    }

    public void updateResult(String id, String index, ToXContent resultDoc) {
        try (XContentBuilder content = this.toXContentBuilder(resultDoc);){
            this.bulkRequest.add(new IndexRequest(index).id(id).source(content));
        }
        catch (IOException e) {
            logger.error((Message)new ParameterizedMessage("[{}] Error serialising result", (Object)this.jobId), (Throwable)e);
        }
        if (this.bulkRequest.numberOfActions() >= 10000) {
            this.executeRequest();
        }
    }

    private XContentBuilder toXContentBuilder(ToXContent obj) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        obj.toXContent(builder, ToXContent.EMPTY_PARAMS);
        return builder;
    }

    public void executeRequest() {
        if (this.bulkRequest.numberOfActions() == 0) {
            return;
        }
        logger.trace("[{}] ES API CALL: bulk request with {} actions", (Object)this.jobId, (Object)this.bulkRequest.numberOfActions());
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            BulkResponse addRecordsResponse = (BulkResponse)this.client.bulk(this.bulkRequest).actionGet();
            if (addRecordsResponse.hasFailures()) {
                logger.error("[{}] Bulk index of results has errors: {}", (Object)this.jobId, (Object)addRecordsResponse.buildFailureMessage());
            }
        }
        this.bulkRequest = new BulkRequest();
    }

    BulkRequest getBulkRequest() {
        return this.bulkRequest;
    }
}

