/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.CsvDataToProcessWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DataToProcessWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.JsonDataToProcessWriter;

public final class DataToProcessWriterFactory {
    private DataToProcessWriterFactory() {
    }

    public static DataToProcessWriter create(boolean includeControlField, boolean includeTokensField, AutodetectProcess autodetectProcess, DataDescription dataDescription, AnalysisConfig analysisConfig, DataCountsReporter dataCountsReporter, NamedXContentRegistry xContentRegistry) {
        switch (dataDescription.getFormat()) {
            case XCONTENT: {
                return new JsonDataToProcessWriter(includeControlField, includeTokensField, autodetectProcess, dataDescription, analysisConfig, dataCountsReporter, xContentRegistry);
            }
            case DELIMITED: {
                return new CsvDataToProcessWriter(includeControlField, includeTokensField, autodetectProcess, dataDescription, analysisConfig, dataCountsReporter);
            }
        }
        throw new IllegalArgumentException();
    }
}

