/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.List;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

public class RestGetDatafeedsAction
extends BaseRestHandler {
    public java.util.List<RestHandler.Route> routes() {
        return List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/datafeeds/{" + DatafeedConfig.ID + "}")).replaces(RestRequest.Method.GET, "/_xpack/ml/datafeeds/{" + DatafeedConfig.ID + "}", RestApiVersion.V_7).build(), (Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_ml/datafeeds").replaces(RestRequest.Method.GET, "/_xpack/ml/datafeeds", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_get_datafeeds_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        if (datafeedId == null) {
            datafeedId = "_all";
        }
        GetDatafeedsAction.Request request = new GetDatafeedsAction.Request(datafeedId);
        if (restRequest.hasParam("allow_no_datafeeds")) {
            LoggingDeprecationHandler.INSTANCE.usedDeprecatedName(null, () -> null, "allow_no_datafeeds", "allow_no_match");
        }
        request.setAllowNoMatch(restRequest.paramAsBoolean("allow_no_match", restRequest.paramAsBoolean("allow_no_datafeeds", request.allowNoMatch())));
        return channel -> client.execute((ActionType)GetDatafeedsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    protected Set<String> responseParams() {
        return Collections.singleton("exclude_generated");
    }
}

