/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class PerPartitionCategorizationConfig
implements ToXContentObject,
Writeable {
    public static final ParseField TYPE_FIELD = new ParseField("per_partition_categorization", new String[0]);
    public static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    public static final ParseField STOP_ON_WARN = new ParseField("stop_on_warn", new String[0]);
    public static final ConstructingObjectParser<PerPartitionCategorizationConfig, Void> LENIENT_PARSER = PerPartitionCategorizationConfig.createParser(true);
    public static final ConstructingObjectParser<PerPartitionCategorizationConfig, Void> STRICT_PARSER = PerPartitionCategorizationConfig.createParser(false);
    private final boolean enabled;
    private final boolean stopOnWarn;

    private static ConstructingObjectParser<PerPartitionCategorizationConfig, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(TYPE_FIELD.getPreferredName(), ignoreUnknownFields, a -> new PerPartitionCategorizationConfig((Boolean)a[0], (Boolean)a[1]));
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED_FIELD);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), STOP_ON_WARN);
        return parser;
    }

    public PerPartitionCategorizationConfig() {
        this(false, null);
    }

    public PerPartitionCategorizationConfig(boolean enabled, Boolean stopOnWarn) {
        this.enabled = enabled;
        boolean bl = this.stopOnWarn = stopOnWarn == null ? false : stopOnWarn;
        if (!this.enabled && this.stopOnWarn) {
            throw ExceptionsHelper.badRequestException(STOP_ON_WARN.getPreferredName() + " cannot be true in " + TYPE_FIELD.getPreferredName() + " when " + ENABLED_FIELD.getPreferredName() + " is false", new Object[0]);
        }
    }

    public PerPartitionCategorizationConfig(StreamInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.stopOnWarn = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.stopOnWarn);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        if (this.enabled) {
            builder.field(STOP_ON_WARN.getPreferredName(), this.stopOnWarn);
        }
        builder.endObject();
        return builder;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isStopOnWarn() {
        return this.stopOnWarn;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PerPartitionCategorizationConfig)) {
            return false;
        }
        PerPartitionCategorizationConfig that = (PerPartitionCategorizationConfig)other;
        return this.enabled == that.enabled && this.stopOnWarn == that.stopOnWarn;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.stopOnWarn);
    }
}

