/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;
import org.elasticsearch.xpack.core.ssl.TrustConfig;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

class DefaultJDKTrustConfig
extends TrustConfig {
    private SecureString trustStorePassword;

    DefaultJDKTrustConfig(@Nullable SecureString trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            return CertParsingUtils.trustManager(this.getSystemTrustStore(), TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    Collection<CertificateInfo> certificates(Environment environment) throws GeneralSecurityException, IOException {
        return Collections.emptyList();
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        return "JDK trusted certs";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJDKTrustConfig that = (DefaultJDKTrustConfig)o;
        return Objects.equals(this.trustStorePassword, that.trustStorePassword);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.trustStorePassword);
    }

    static TrustConfig merge(TrustConfig trustConfig, SecureString trustStorePassword) {
        if (trustConfig == null) {
            return new DefaultJDKTrustConfig(trustStorePassword);
        }
        return new TrustConfig.CombiningTrustConfig(Arrays.asList(new DefaultJDKTrustConfig(trustStorePassword), trustConfig));
    }

    private KeyStore getSystemTrustStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        if (System.getProperty("javax.net.ssl.trustStoreType", "").equalsIgnoreCase("PKCS11") && this.trustStorePassword != null) {
            KeyStore keyStore = KeyStore.getInstance("PKCS11");
            keyStore.load(null, this.trustStorePassword.getChars());
            return keyStore;
        }
        return null;
    }
}

