/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial;

import org.apache.lucene.util.SloppyMath;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.Polygon;

public class SpatialUtils {
    private SpatialUtils() {
    }

    public static Polygon createRegularGeoShapePolygon(Circle circle, int gons) {
        if (SloppyMath.haversinMeters((double)circle.getLat(), (double)circle.getLon(), (double)90.0, (double)0.0) < circle.getRadiusMeters()) {
            throw new IllegalArgumentException("circle [" + circle.toString() + "] contains the north pole. It cannot be translated to a polygon");
        }
        if (SloppyMath.haversinMeters((double)circle.getLat(), (double)circle.getLon(), (double)-90.0, (double)0.0) < circle.getRadiusMeters()) {
            throw new IllegalArgumentException("circle [" + circle.toString() + "] contains the south pole. It cannot be translated to a polygon");
        }
        double[][] result = new double[][]{new double[gons + 1], new double[gons + 1]};
        for (int i = 0; i < gons; ++i) {
            double lon;
            double lat;
            double angle = (double)i * (360.0 / (double)gons);
            double x = Math.cos(SloppyMath.toRadians((double)angle));
            double y = Math.sin(SloppyMath.toRadians((double)angle));
            double factor = 2.0;
            double step = 1.0;
            int last = 0;
            while (true) {
                lat = circle.getLat() + y * factor;
                lon = circle.getLon() + x * factor;
                double distanceMeters = SloppyMath.haversinMeters((double)circle.getLat(), (double)circle.getLon(), (double)lat, (double)lon);
                if (Math.abs(distanceMeters - circle.getRadiusMeters()) < 0.1) break;
                if (distanceMeters > circle.getRadiusMeters()) {
                    factor -= step;
                    if (last == 1) {
                        step /= 2.0;
                    }
                    last = -1;
                    continue;
                }
                if (!(distanceMeters < circle.getRadiusMeters())) continue;
                factor += step;
                if (last == -1) {
                    step /= 2.0;
                }
                last = 1;
            }
            result[0][i] = lon;
            result[1][i] = lat;
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return new Polygon(new LinearRing(result[0], result[1]));
    }

    public static Polygon createRegularShapePolygon(Circle circle, int gons) {
        double[][] result = new double[][]{new double[gons + 1], new double[gons + 1]};
        for (int i = 0; i < gons; ++i) {
            double angle = (double)i * (360.0 / (double)gons);
            double x = circle.getRadiusMeters() * Math.cos(SloppyMath.toRadians((double)angle));
            double y = circle.getRadiusMeters() * Math.sin(SloppyMath.toRadians((double)angle));
            result[0][i] = x + circle.getX();
            result[1][i] = y + circle.getY();
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return new Polygon(new LinearRing(result[0], result[1]));
    }
}

