/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import org.apache.lucene.geo.GeoEncodingUtils;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;

final class GeoShapeCoordinateEncoder
implements CoordinateEncoder {
    GeoShapeCoordinateEncoder() {
    }

    @Override
    public int encodeX(double x) {
        if (x == Double.NEGATIVE_INFINITY) {
            return Integer.MIN_VALUE;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return Integer.MAX_VALUE;
        }
        return GeoEncodingUtils.encodeLongitude((double)x);
    }

    @Override
    public int encodeY(double y) {
        if (y == Double.NEGATIVE_INFINITY) {
            return Integer.MIN_VALUE;
        }
        if (y == Double.POSITIVE_INFINITY) {
            return Integer.MAX_VALUE;
        }
        return GeoEncodingUtils.encodeLatitude((double)y);
    }

    @Override
    public double decodeX(int x) {
        return GeoEncodingUtils.decodeLongitude((int)x);
    }

    @Override
    public double decodeY(int y) {
        return GeoEncodingUtils.decodeLatitude((int)y);
    }

    @Override
    public double normalizeX(double x) {
        return GeoUtils.normalizeLon((double)x);
    }

    @Override
    public double normalizeY(double y) {
        return GeoUtils.normalizeLat((double)y);
    }
}

