/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.scalar;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class BinaryScalarFunction
extends ScalarFunction {
    private final Expression left;
    private final Expression right;

    protected BinaryScalarFunction(Source source, Expression left, Expression right) {
        super(source, Arrays.asList(left, right));
        this.left = left;
        this.right = right;
    }

    @Override
    public final BinaryScalarFunction replaceChildren(List<Expression> newChildren) {
        Expression newLeft = newChildren.get(0);
        Expression newRight = newChildren.get(1);
        return this.left.equals(newLeft) && this.right.equals(newRight) ? this : this.replaceChildren(newLeft, newRight);
    }

    protected abstract BinaryScalarFunction replaceChildren(Expression var1, Expression var2);

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    @Override
    public boolean foldable() {
        return this.left.foldable() && this.right.foldable();
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate leftScript = this.asScript(this.left());
        ScriptTemplate rightScript = this.asScript(this.right());
        return this.asScriptFrom(leftScript, rightScript);
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate leftScript, ScriptTemplate rightScript) {
        return Scripts.binaryMethod(Scripts.classPackageAsPrefix(this.getClass()), this.scriptMethodName(), leftScript, rightScript, this.dataType());
    }

    protected String scriptMethodName() {
        return this.getClass().getSimpleName().toLowerCase(Locale.ROOT);
    }
}

