/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryDirectoryServerEqualityAttributeIndex;
import com.unboundid.ldap.listener.InMemoryDirectoryServerPassword;
import com.unboundid.ldap.listener.InMemoryDirectoryServerSnapshot;
import com.unboundid.ldap.listener.InMemoryExtendedOperationHandler;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.listener.InMemoryPasswordEncoder;
import com.unboundid.ldap.listener.InMemorySASLBindHandler;
import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.RequestControlPreProcessor;
import com.unboundid.ldap.matchingrules.DistinguishedNameMatchingRule;
import com.unboundid.ldap.matchingrules.GeneralizedTimeMatchingRule;
import com.unboundid.ldap.matchingrules.IntegerMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ChangeLogEntry;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.EntrySorter;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.AssertionRequestControl;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityResponseControl;
import com.unboundid.ldap.sdk.controls.PostReadRequestControl;
import com.unboundid.ldap.sdk.controls.PostReadResponseControl;
import com.unboundid.ldap.sdk.controls.PreReadRequestControl;
import com.unboundid.ldap.sdk.controls.PreReadResponseControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV1RequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.controls.ServerSideSortRequestControl;
import com.unboundid.ldap.sdk.controls.ServerSideSortResponseControl;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.SortKey;
import com.unboundid.ldap.sdk.controls.TransactionSpecificationRequestControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewRequestControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewResponseControl;
import com.unboundid.ldap.sdk.extensions.AbortedTransactionExtendedResult;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.DITContentRuleDefinition;
import com.unboundid.ldap.sdk.schema.DITStructureRuleDefinition;
import com.unboundid.ldap.sdk.schema.EntryValidator;
import com.unboundid.ldap.sdk.schema.MatchingRuleUseDefinition;
import com.unboundid.ldap.sdk.schema.NameFormDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class InMemoryRequestHandler
extends LDAPListenerRequestHandler {
    private static final Control[] NO_CONTROLS = new Control[0];
    static final String OID_INTERNAL_OPERATION_REQUEST_CONTROL = "1.3.6.1.4.1.30221.2.5.18";
    private final AtomicLong firstChangeNumber;
    private final AtomicLong lastChangeNumber;
    private final AtomicLong processingDelayMillis;
    private final AtomicReference<EntryValidator> entryValidatorRef;
    private final AtomicReference<ReadOnlyEntry> subschemaSubentryRef;
    private final AtomicReference<Schema> schemaRef;
    private final boolean generateOperationalAttributes;
    private DN authenticatedDN;
    private final DN changeLogBaseDN;
    private final DN subschemaSubentryDN;
    private final InMemoryDirectoryServerConfig config;
    private final InMemoryDirectoryServerSnapshot initialSnapshot;
    private final InMemoryPasswordEncoder primaryPasswordEncoder;
    private final int maxChangelogEntries;
    private final int maxSizeLimit;
    private final LDAPListenerClientConnection connection;
    private final List<InMemoryPasswordEncoder> passwordEncoders;
    private final List<String> configuredPasswordAttributes;
    private final List<String> extendedPasswordAttributes;
    private final Map<AttributeTypeDefinition, InMemoryDirectoryServerEqualityAttributeIndex> equalityIndexes;
    private final Map<DN, byte[]> additionalBindCredentials;
    private final Map<String, InMemoryExtendedOperationHandler> extendedRequestHandlers;
    private final Map<String, InMemorySASLBindHandler> saslBindHandlers;
    private final Map<String, Object> connectionState;
    private final Set<DN> baseDNs;
    private final Set<String> referentialIntegrityAttributes;
    private final Map<DN, ReadOnlyEntry> entryMap;

    public InMemoryRequestHandler(InMemoryDirectoryServerConfig config) throws LDAPException {
        DN[] baseDNArray;
        this.config = config;
        this.schemaRef = new AtomicReference();
        this.entryValidatorRef = new AtomicReference();
        this.subschemaSubentryRef = new AtomicReference();
        Schema schema = config.getSchema();
        this.schemaRef.set(schema);
        if (schema != null) {
            EntryValidator entryValidator = new EntryValidator(schema);
            this.entryValidatorRef.set(entryValidator);
            entryValidator.setCheckAttributeSyntax(config.enforceAttributeSyntaxCompliance());
            entryValidator.setCheckStructuralObjectClasses(config.enforceSingleStructuralObjectClass());
        }
        if ((baseDNArray = config.getBaseDNs()) == null || baseDNArray.length == 0) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_HANDLER_NO_BASE_DNS.get());
        }
        this.entryMap = new TreeMap<DN, ReadOnlyEntry>();
        LinkedHashSet<DN> baseDNSet = new LinkedHashSet<DN>(Arrays.asList(baseDNArray));
        if (baseDNSet.contains(DN.NULL_DN)) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_HANDLER_NULL_BASE_DN.get());
        }
        this.changeLogBaseDN = new DN("cn=changelog", schema);
        if (baseDNSet.contains(this.changeLogBaseDN)) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_HANDLER_CHANGELOG_BASE_DN.get(this.changeLogBaseDN));
        }
        this.maxChangelogEntries = config.getMaxChangeLogEntries();
        this.maxSizeLimit = config.getMaxSizeLimit() <= 0 ? Integer.MAX_VALUE : config.getMaxSizeLimit();
        TreeMap<String, InMemoryExtendedOperationHandler> extOpHandlers = new TreeMap<String, InMemoryExtendedOperationHandler>();
        for (InMemoryExtendedOperationHandler h : config.getExtendedOperationHandlers()) {
            for (String oid : h.getSupportedExtendedRequestOIDs()) {
                if (extOpHandlers.containsKey(oid)) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_HANDLER_EXTENDED_REQUEST_HANDLER_CONFLICT.get(oid));
                }
                extOpHandlers.put(oid, h);
            }
        }
        this.extendedRequestHandlers = Collections.unmodifiableMap(extOpHandlers);
        TreeMap<String, InMemorySASLBindHandler> saslHandlers = new TreeMap<String, InMemorySASLBindHandler>();
        for (InMemorySASLBindHandler h : config.getSASLBindHandlers()) {
            String mech = h.getSASLMechanismName();
            if (saslHandlers.containsKey(mech)) {
                throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_HANDLER_SASL_BIND_HANDLER_CONFLICT.get(mech));
            }
            saslHandlers.put(mech, h);
        }
        this.saslBindHandlers = Collections.unmodifiableMap(saslHandlers);
        this.additionalBindCredentials = Collections.unmodifiableMap(config.getAdditionalBindCredentials());
        List<String> eqIndexAttrs = config.getEqualityIndexAttributes();
        this.equalityIndexes = new HashMap<AttributeTypeDefinition, InMemoryDirectoryServerEqualityAttributeIndex>(eqIndexAttrs.size());
        for (String s : eqIndexAttrs) {
            InMemoryDirectoryServerEqualityAttributeIndex i = new InMemoryDirectoryServerEqualityAttributeIndex(s, schema);
            this.equalityIndexes.put(i.getAttributeType(), i);
        }
        Set<String> pwAttrSet = config.getPasswordAttributes();
        LinkedHashSet<String> basePWAttrSet = new LinkedHashSet<String>(pwAttrSet.size());
        LinkedHashSet<String> extendedPWAttrSet = new LinkedHashSet<String>(pwAttrSet.size() * 2);
        for (String attr : pwAttrSet) {
            AttributeTypeDefinition attrType;
            basePWAttrSet.add(attr);
            extendedPWAttrSet.add(StaticUtils.toLowerCase(attr));
            if (schema == null || (attrType = schema.getAttributeType(attr)) == null) continue;
            for (String name : attrType.getNames()) {
                extendedPWAttrSet.add(StaticUtils.toLowerCase(name));
            }
            extendedPWAttrSet.add(StaticUtils.toLowerCase(attrType.getOID()));
        }
        this.configuredPasswordAttributes = Collections.unmodifiableList(new ArrayList(basePWAttrSet));
        this.extendedPasswordAttributes = Collections.unmodifiableList(new ArrayList(extendedPWAttrSet));
        this.referentialIntegrityAttributes = Collections.unmodifiableSet(config.getReferentialIntegrityAttributes());
        this.primaryPasswordEncoder = config.getPrimaryPasswordEncoder();
        ArrayList<InMemoryPasswordEncoder> encoderList = new ArrayList<InMemoryPasswordEncoder>(10);
        if (this.primaryPasswordEncoder != null) {
            encoderList.add(this.primaryPasswordEncoder);
        }
        encoderList.addAll(config.getSecondaryPasswordEncoders());
        this.passwordEncoders = Collections.unmodifiableList(encoderList);
        this.baseDNs = Collections.unmodifiableSet(baseDNSet);
        this.generateOperationalAttributes = config.generateOperationalAttributes();
        this.authenticatedDN = new DN("cn=Internal Root User", schema);
        this.connection = null;
        this.connectionState = Collections.emptyMap();
        this.firstChangeNumber = new AtomicLong(0L);
        this.lastChangeNumber = new AtomicLong(0L);
        this.processingDelayMillis = new AtomicLong(0L);
        ReadOnlyEntry subschemaSubentry = InMemoryRequestHandler.generateSubschemaSubentry(schema);
        this.subschemaSubentryRef.set(subschemaSubentry);
        this.subschemaSubentryDN = subschemaSubentry.getParsedDN();
        if (this.baseDNs.contains(this.subschemaSubentryDN)) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_HANDLER_SCHEMA_BASE_DN.get(this.subschemaSubentryDN));
        }
        if (this.maxChangelogEntries > 0) {
            baseDNSet.add(this.changeLogBaseDN);
            ReadOnlyEntry changeLogBaseEntry = new ReadOnlyEntry(this.changeLogBaseDN, schema, new Attribute("objectClass", "top", "namedObject"), new Attribute("cn", "changelog"), new Attribute("entryDN", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), "cn=changelog"), new Attribute("entryUUID", UUID.randomUUID().toString()), new Attribute("creatorsName", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), DN.NULL_DN.toString()), new Attribute("createTimestamp", (MatchingRule)GeneralizedTimeMatchingRule.getInstance(), StaticUtils.encodeGeneralizedTime(new Date())), new Attribute("modifiersName", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), DN.NULL_DN.toString()), new Attribute("modifyTimestamp", (MatchingRule)GeneralizedTimeMatchingRule.getInstance(), StaticUtils.encodeGeneralizedTime(new Date())), new Attribute("subschemaSubentry", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), this.subschemaSubentryDN.toString()));
            this.entryMap.put(this.changeLogBaseDN, changeLogBaseEntry);
            this.indexAdd(changeLogBaseEntry);
        }
        this.initialSnapshot = this.createSnapshot();
    }

    private InMemoryRequestHandler(InMemoryRequestHandler parent, LDAPListenerClientConnection connection) {
        this.connection = connection;
        this.authenticatedDN = DN.NULL_DN;
        this.connectionState = Collections.synchronizedMap(new LinkedHashMap(0));
        this.config = parent.config;
        this.generateOperationalAttributes = parent.generateOperationalAttributes;
        this.additionalBindCredentials = parent.additionalBindCredentials;
        this.baseDNs = parent.baseDNs;
        this.changeLogBaseDN = parent.changeLogBaseDN;
        this.firstChangeNumber = parent.firstChangeNumber;
        this.lastChangeNumber = parent.lastChangeNumber;
        this.processingDelayMillis = parent.processingDelayMillis;
        this.maxChangelogEntries = parent.maxChangelogEntries;
        this.maxSizeLimit = parent.maxSizeLimit;
        this.equalityIndexes = parent.equalityIndexes;
        this.referentialIntegrityAttributes = parent.referentialIntegrityAttributes;
        this.entryMap = parent.entryMap;
        this.entryValidatorRef = parent.entryValidatorRef;
        this.extendedRequestHandlers = parent.extendedRequestHandlers;
        this.saslBindHandlers = parent.saslBindHandlers;
        this.schemaRef = parent.schemaRef;
        this.subschemaSubentryRef = parent.subschemaSubentryRef;
        this.subschemaSubentryDN = parent.subschemaSubentryDN;
        this.initialSnapshot = parent.initialSnapshot;
        this.configuredPasswordAttributes = parent.configuredPasswordAttributes;
        this.extendedPasswordAttributes = parent.extendedPasswordAttributes;
        this.primaryPasswordEncoder = parent.primaryPasswordEncoder;
        this.passwordEncoders = parent.passwordEncoders;
    }

    @Override
    public InMemoryRequestHandler newInstance(LDAPListenerClientConnection connection) throws LDAPException {
        return new InMemoryRequestHandler(this, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InMemoryDirectoryServerSnapshot createSnapshot() {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            return new InMemoryDirectoryServerSnapshot(this.entryMap, this.firstChangeNumber.get(), this.lastChangeNumber.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreSnapshot(InMemoryDirectoryServerSnapshot snapshot) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            this.entryMap.clear();
            this.entryMap.putAll(snapshot.getEntryMap());
            for (InMemoryDirectoryServerEqualityAttributeIndex i : this.equalityIndexes.values()) {
                i.clear();
                for (Entry entry : this.entryMap.values()) {
                    try {
                        i.processAdd(entry);
                    }
                    catch (Exception ex) {
                        Debug.debugException(ex);
                    }
                }
            }
            this.firstChangeNumber.set(snapshot.getFirstChangeNumber());
            this.lastChangeNumber.set(snapshot.getLastChangeNumber());
        }
    }

    public Schema getSchema() {
        return this.schemaRef.get();
    }

    public List<DN> getBaseDNs() {
        return Collections.unmodifiableList(new ArrayList<DN>(this.baseDNs));
    }

    public LDAPListenerClientConnection getClientConnection() {
        return this.connection;
    }

    public synchronized DN getAuthenticatedDN() {
        return this.authenticatedDN;
    }

    public synchronized void setAuthenticatedDN(DN authenticatedDN) {
        this.authenticatedDN = authenticatedDN == null ? DN.NULL_DN : authenticatedDN;
    }

    public Map<DN, byte[]> getAdditionalBindCredentials() {
        return this.additionalBindCredentials;
    }

    public byte[] getAdditionalBindCredentials(DN dn) {
        return this.additionalBindCredentials.get(dn);
    }

    public Map<String, Object> getConnectionState() {
        return this.connectionState;
    }

    public long getProcessingDelayMillis() {
        return this.processingDelayMillis.get();
    }

    public void setProcessingDelayMillis(long processingDelayMillis) {
        if (processingDelayMillis > 0L) {
            this.processingDelayMillis.set(processingDelayMillis);
        } else {
            this.processingDelayMillis.set(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processAddRequest(int messageID, AddRequestProtocolOp request, List<Control> controls) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            PostReadResponseControl postReadResponse;
            DN authzDN;
            EntryValidator entryValidator;
            String[] objectClasses;
            Entry referralEntry;
            DN dn;
            MatchingRule matchingRule;
            Entry entry;
            Map<String, Control> controlMap;
            this.sleepBeforeProcessing();
            try {
                controlMap = RequestControlPreProcessor.processControls((byte)104, controls);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            ArrayList<Control> responseControls = new ArrayList<Control>(1);
            boolean isInternalOp = controlMap.containsKey(OID_INTERNAL_OPERATION_REQUEST_CONTROL);
            if (!isInternalOp && !this.config.getAllowedOperationTypes().contains((Object)OperationType.ADD)) {
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_ADD_NOT_ALLOWED.get(), null), new Control[0]);
            }
            if (this.authenticatedDN.isNullDN() && this.config.getAuthenticationRequiredOperationTypes().contains((Object)OperationType.ADD)) {
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(50, null, ListenerMessages.ERR_MEM_HANDLER_ADD_REQUIRES_AUTH.get(), null), new Control[0]);
            }
            try {
                ASN1OctetString txnID = this.processTransactionRequest(messageID, request, controlMap);
                if (txnID != null) {
                    return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(0, null, ListenerMessages.INFO_MEM_HANDLER_OP_IN_TXN.get(txnID.stringValue()), null), new Control[0]);
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(le.getResultCode().intValue(), le.getMatchedDN(), le.getDiagnosticMessage(), StaticUtils.toList(le.getReferralURLs())), le.getResponseControls());
            }
            Schema schema = this.schemaRef.get();
            if (schema == null) {
                entry = new Entry(request.getDN(), request.getAttributes());
            } else {
                List<Attribute> providedAttrs = request.getAttributes();
                ArrayList<Attribute> newAttrs = new ArrayList<Attribute>(providedAttrs.size());
                for (Attribute a : providedAttrs) {
                    String baseName = a.getBaseName();
                    matchingRule = MatchingRule.selectEqualityMatchingRule(baseName, schema);
                    newAttrs.add(new Attribute(a.getName(), matchingRule, a.getRawValues()));
                }
                entry = new Entry(request.getDN(), schema, newAttrs);
            }
            try {
                dn = entry.getParsedDN();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(34, null, ListenerMessages.ERR_MEM_HANDLER_ADD_MALFORMED_DN.get(request.getDN(), le.getMessage()), null), new Control[0]);
            }
            if (dn.isNullDN()) {
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(68, null, ListenerMessages.ERR_MEM_HANDLER_ADD_ROOT_DSE.get(), null), new Control[0]);
            }
            if (dn.isDescendantOf(this.subschemaSubentryDN, true)) {
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(68, null, ListenerMessages.ERR_MEM_HANDLER_ADD_SCHEMA.get(this.subschemaSubentryDN.toString()), null), new Control[0]);
            }
            if (dn.isDescendantOf(this.changeLogBaseDN, true)) {
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_ADD_CHANGELOG.get(this.changeLogBaseDN.toString()), null), new Control[0]);
            }
            if (!controlMap.containsKey("2.16.840.1.113730.3.4.2") && (referralEntry = this.findNearestReferral(dn)) != null) {
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(10, referralEntry.getDN(), ListenerMessages.INFO_MEM_HANDLER_REFERRAL_ENCOUNTERED.get(), InMemoryRequestHandler.getReferralURLs(dn, referralEntry)), new Control[0]);
            }
            if (this.entryMap.containsKey(dn)) {
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(68, null, ListenerMessages.ERR_MEM_HANDLER_ADD_ALREADY_EXISTS.get(request.getDN()), null), new Control[0]);
            }
            RDN rdn = dn.getRDN();
            String[] rdnAttrNames = rdn.getAttributeNames();
            byte[][] rdnAttrValues = rdn.getByteArrayAttributeValues();
            for (int i = 0; i < rdnAttrNames.length; ++i) {
                matchingRule = MatchingRule.selectEqualityMatchingRule(rdnAttrNames[i], schema);
                entry.addAttribute(new Attribute(rdnAttrNames[i], matchingRule, rdnAttrValues[i]));
            }
            if (schema != null && (objectClasses = entry.getObjectClassValues()) != null) {
                LinkedHashMap<String, String> ocMap = new LinkedHashMap<String, String>(objectClasses.length);
                for (String ocName : objectClasses) {
                    ObjectClassDefinition oc = schema.getObjectClass(ocName);
                    if (oc == null) {
                        ocMap.put(StaticUtils.toLowerCase(ocName), ocName);
                        continue;
                    }
                    ocMap.put(StaticUtils.toLowerCase(oc.getNameOrOID()), ocName);
                    for (ObjectClassDefinition supClass : oc.getSuperiorClasses(schema, true)) {
                        ocMap.put(StaticUtils.toLowerCase(supClass.getNameOrOID()), supClass.getNameOrOID());
                    }
                }
                String[] newObjectClasses = new String[ocMap.size()];
                ocMap.values().toArray(newObjectClasses);
                entry.setAttribute("objectClass", newObjectClasses);
            }
            if ((entryValidator = this.entryValidatorRef.get()) != null) {
                ArrayList<String> invalidReasons = new ArrayList<String>(1);
                if (!entryValidator.entryIsValid(entry, invalidReasons)) {
                    return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(65, null, ListenerMessages.ERR_MEM_HANDLER_ADD_VIOLATES_SCHEMA.get(request.getDN(), StaticUtils.concatenateStrings(invalidReasons)), null), new Control[0]);
                }
                if (!isInternalOp && schema != null && !controlMap.containsKey("1.3.6.1.4.1.30221.2.5.5")) {
                    for (Attribute a : entry.getAttributes()) {
                        AttributeTypeDefinition at = schema.getAttributeType(a.getBaseName());
                        if (at == null || !at.isNoUserModification()) continue;
                        return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(19, null, ListenerMessages.ERR_MEM_HANDLER_ADD_CONTAINS_NO_USER_MOD.get(request.getDN(), a.getName()), null), new Control[0]);
                    }
                }
            }
            try {
                authzDN = this.handleProxiedAuthControl(controlMap);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            if (this.generateOperationalAttributes) {
                Date d = new Date();
                if (!entry.hasAttribute("entryDN")) {
                    entry.addAttribute(new Attribute("entryDN", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), dn.toNormalizedString()));
                }
                if (!entry.hasAttribute("entryUUID")) {
                    entry.addAttribute(new Attribute("entryUUID", UUID.randomUUID().toString()));
                }
                if (!entry.hasAttribute("subschemaSubentry")) {
                    entry.addAttribute(new Attribute("subschemaSubentry", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), this.subschemaSubentryDN.toString()));
                }
                if (!entry.hasAttribute("creatorsName")) {
                    entry.addAttribute(new Attribute("creatorsName", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), authzDN.toString()));
                }
                if (!entry.hasAttribute("createTimestamp")) {
                    entry.addAttribute(new Attribute("createTimestamp", (MatchingRule)GeneralizedTimeMatchingRule.getInstance(), StaticUtils.encodeGeneralizedTime(d)));
                }
                if (!entry.hasAttribute("modifiersName")) {
                    entry.addAttribute(new Attribute("modifiersName", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), authzDN.toString()));
                }
                if (!entry.hasAttribute("modifyTimestamp")) {
                    entry.addAttribute(new Attribute("modifyTimestamp", (MatchingRule)GeneralizedTimeMatchingRule.getInstance(), StaticUtils.encodeGeneralizedTime(d)));
                }
            }
            try {
                InMemoryRequestHandler.handleAssertionRequestControl(controlMap, entry);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            if (!this.passwordEncoders.isEmpty() && !this.configuredPasswordAttributes.isEmpty()) {
                ReadOnlyEntry readOnlyEntry = new ReadOnlyEntry(entry.duplicate());
                for (String passwordAttribute : this.configuredPasswordAttributes) {
                    for (Attribute attr : readOnlyEntry.getAttributesWithOptions(passwordAttribute, null)) {
                        ArrayList<byte[]> newValues = new ArrayList<byte[]>(attr.size());
                        for (ASN1OctetString value : attr.getRawValues()) {
                            try {
                                newValues.add(this.encodeAddPassword(value, readOnlyEntry, Collections.emptyList()).getValue());
                            }
                            catch (LDAPException le) {
                                Debug.debugException(le);
                                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(53, le.getMatchedDN(), le.getMessage(), null), new Control[0]);
                            }
                        }
                        byte[][] newValuesArray = new byte[newValues.size()][];
                        newValues.toArray((T[])newValuesArray);
                        entry.setAttribute(new Attribute(attr.getName(), schema, (byte[][])newValuesArray));
                    }
                }
            }
            if ((postReadResponse = this.handlePostReadControl(controlMap, entry)) != null) {
                responseControls.add(postReadResponse);
            }
            if (this.baseDNs.contains(dn)) {
                this.entryMap.put(dn, new ReadOnlyEntry(entry));
                this.indexAdd(entry);
                this.addChangeLogEntry(request, authzDN);
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(0, null, null, null), responseControls);
            }
            DN parentDN = dn.getParent();
            if (parentDN != null && this.entryMap.containsKey(parentDN)) {
                this.entryMap.put(dn, new ReadOnlyEntry(entry));
                this.indexAdd(entry);
                this.addChangeLogEntry(request, authzDN);
                return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(0, null, null, null), responseControls);
            }
            return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(32, this.getMatchedDNString(dn), ListenerMessages.ERR_MEM_HANDLER_ADD_MISSING_PARENT.get(request.getDN(), dn.getParentString()), null), new Control[0]);
        }
    }

    private ASN1OctetString encodeAddPassword(ASN1OctetString password, ReadOnlyEntry entry, List<Modification> mods) throws LDAPException {
        for (InMemoryPasswordEncoder encoder : this.passwordEncoders) {
            if (!encoder.passwordStartsWithPrefix(password)) continue;
            encoder.ensurePreEncodedPasswordAppearsValid(password, entry, mods);
            return password;
        }
        if (this.primaryPasswordEncoder != null) {
            return this.primaryPasswordEncoder.encodePassword(password, entry, mods);
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processBindRequest(int messageID, BindRequestProtocolOp request, List<Control> controls) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            Map<String, Control> controlMap;
            DN bindDN;
            this.sleepBeforeProcessing();
            if (!this.config.getAllowedOperationTypes().contains((Object)OperationType.BIND)) {
                return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_BIND_NOT_ALLOWED.get(), null, null), new Control[0]);
            }
            this.authenticatedDN = DN.NULL_DN;
            if (this.authenticatedDN.isNullDN() && this.config.getAuthenticationRequiredOperationTypes().contains((Object)OperationType.BIND) && request.getCredentialsType() == -128 && (request.getSimplePassword() == null || request.getSimplePassword().getValueLength() == 0)) {
                return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(49, null, ListenerMessages.ERR_MEM_HANDLER_BIND_REQUIRES_AUTH.get(), null, null), new Control[0]);
            }
            try {
                bindDN = new DN(request.getBindDN(), this.schemaRef.get());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(34, null, ListenerMessages.ERR_MEM_HANDLER_BIND_MALFORMED_DN.get(request.getBindDN(), le.getMessage()), null, null), new Control[0]);
            }
            if (request.getCredentialsType() == -93) {
                String mechanism = request.getSASLMechanism();
                InMemorySASLBindHandler handler = this.saslBindHandlers.get(mechanism);
                if (handler == null) {
                    return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(7, null, ListenerMessages.ERR_MEM_HANDLER_SASL_MECH_NOT_SUPPORTED.get(mechanism), null, null), new Control[0]);
                }
                try {
                    BindResult bindResult = handler.processSASLBind(this, messageID, bindDN, request.getSASLCredentials(), controls);
                    if (bindResult.getResultCode() == ResultCode.SUCCESS && this.authenticatedDN == DN.NULL_DN && this.config.getAuthenticationRequiredOperationTypes().contains((Object)OperationType.BIND)) {
                        return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(49, null, ListenerMessages.ERR_MEM_HANDLER_BIND_REQUIRES_AUTH.get(), null, null), new Control[0]);
                    }
                    return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(bindResult.getResultCode().intValue(), bindResult.getMatchedDN(), bindResult.getDiagnosticMessage(), Arrays.asList(bindResult.getReferralURLs()), bindResult.getServerSASLCredentials()), Arrays.asList(bindResult.getResponseControls()));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(80, null, ListenerMessages.ERR_MEM_HANDLER_SASL_BIND_FAILURE.get(StaticUtils.getExceptionMessage(e)), null, null), new Control[0]);
                }
            }
            try {
                controlMap = RequestControlPreProcessor.processControls((byte)96, controls);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null, null), new Control[0]);
            }
            ArrayList<Control> responseControls = new ArrayList<Control>(1);
            ASN1OctetString bindPassword = request.getSimplePassword();
            if (bindDN.isNullDN()) {
                if (bindPassword.getValueLength() == 0) {
                    if (controlMap.containsKey("2.16.840.1.113730.3.4.16")) {
                        responseControls.add(new AuthorizationIdentityResponseControl(""));
                    }
                    return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(0, null, null, null, null), responseControls);
                }
                return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(49, this.getMatchedDNString(bindDN), ListenerMessages.ERR_MEM_HANDLER_BIND_WRONG_PASSWORD.get(request.getBindDN()), null, null), new Control[0]);
            }
            if (!bindDN.isNullDN() && bindPassword.getValueLength() == 0) {
                return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_BIND_SIMPLE_DN_WITHOUT_PASSWORD.get(), null, null), new Control[0]);
            }
            byte[] additionalCreds = this.additionalBindCredentials.get(bindDN);
            if (additionalCreds != null) {
                if (Arrays.equals(additionalCreds, bindPassword.getValue())) {
                    this.authenticatedDN = bindDN;
                    if (controlMap.containsKey("2.16.840.1.113730.3.4.16")) {
                        responseControls.add(new AuthorizationIdentityResponseControl("dn:" + bindDN.toString()));
                    }
                    return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(0, null, null, null, null), responseControls);
                }
                return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(49, this.getMatchedDNString(bindDN), ListenerMessages.ERR_MEM_HANDLER_BIND_WRONG_PASSWORD.get(request.getBindDN()), null, null), new Control[0]);
            }
            ReadOnlyEntry userEntry = this.entryMap.get(bindDN);
            if (userEntry == null) {
                return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(49, this.getMatchedDNString(bindDN), ListenerMessages.ERR_MEM_HANDLER_BIND_NO_SUCH_USER.get(request.getBindDN()), null, null), new Control[0]);
            }
            List<InMemoryDirectoryServerPassword> matchingPasswords = this.getPasswordsInEntry(userEntry, bindPassword);
            if (matchingPasswords.isEmpty()) {
                return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(49, this.getMatchedDNString(bindDN), ListenerMessages.ERR_MEM_HANDLER_BIND_WRONG_PASSWORD.get(request.getBindDN()), null, null), new Control[0]);
            }
            this.authenticatedDN = bindDN;
            if (controlMap.containsKey("2.16.840.1.113730.3.4.16")) {
                responseControls.add(new AuthorizationIdentityResponseControl("dn:" + bindDN.toString()));
            }
            return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(0, null, null, null, null), responseControls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processCompareRequest(int messageID, CompareRequestProtocolOp request, List<Control> controls) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            Entry referralEntry;
            DN dn;
            Map<String, Control> controlMap;
            this.sleepBeforeProcessing();
            try {
                controlMap = RequestControlPreProcessor.processControls((byte)110, controls);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            ArrayList<Control> responseControls = new ArrayList<Control>(1);
            boolean isInternalOp = controlMap.containsKey(OID_INTERNAL_OPERATION_REQUEST_CONTROL);
            if (!isInternalOp && !this.config.getAllowedOperationTypes().contains((Object)OperationType.COMPARE)) {
                return new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_COMPARE_NOT_ALLOWED.get(), null), new Control[0]);
            }
            if (this.authenticatedDN.isNullDN() && this.config.getAuthenticationRequiredOperationTypes().contains((Object)OperationType.COMPARE)) {
                return new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(50, null, ListenerMessages.ERR_MEM_HANDLER_COMPARE_REQUIRES_AUTH.get(), null), new Control[0]);
            }
            try {
                dn = new DN(request.getDN(), this.schemaRef.get());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(34, null, ListenerMessages.ERR_MEM_HANDLER_COMPARE_MALFORMED_DN.get(request.getDN(), le.getMessage()), null), new Control[0]);
            }
            if (!controlMap.containsKey("2.16.840.1.113730.3.4.2") && (referralEntry = this.findNearestReferral(dn)) != null) {
                return new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(10, referralEntry.getDN(), ListenerMessages.INFO_MEM_HANDLER_REFERRAL_ENCOUNTERED.get(), InMemoryRequestHandler.getReferralURLs(dn, referralEntry)), new Control[0]);
            }
            Entry entry = dn.isNullDN() ? this.generateRootDSE() : (dn.equals(this.subschemaSubentryDN) ? (Entry)this.subschemaSubentryRef.get() : (Entry)this.entryMap.get(dn));
            if (entry == null) {
                return new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(32, this.getMatchedDNString(dn), ListenerMessages.ERR_MEM_HANDLER_COMPARE_NO_SUCH_ENTRY.get(request.getDN()), null), new Control[0]);
            }
            try {
                InMemoryRequestHandler.handleAssertionRequestControl(controlMap, entry);
                this.handleProxiedAuthControl(controlMap);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            int resultCode = entry.hasAttributeValue(request.getAttributeName(), request.getAssertionValue().getValue()) ? 6 : 5;
            return new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(resultCode, null, null, null), responseControls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processDeleteRequest(int messageID, DeleteRequestProtocolOp request, List<Control> controls) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            DN authzDN;
            Entry referralEntry;
            DN dn;
            Map<String, Control> controlMap;
            this.sleepBeforeProcessing();
            try {
                controlMap = RequestControlPreProcessor.processControls((byte)74, controls);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            ArrayList<Control> responseControls = new ArrayList<Control>(1);
            boolean isInternalOp = controlMap.containsKey(OID_INTERNAL_OPERATION_REQUEST_CONTROL);
            if (!isInternalOp && !this.config.getAllowedOperationTypes().contains((Object)OperationType.DELETE)) {
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_DELETE_NOT_ALLOWED.get(), null), new Control[0]);
            }
            if (this.authenticatedDN.isNullDN() && this.config.getAuthenticationRequiredOperationTypes().contains((Object)OperationType.DELETE)) {
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(50, null, ListenerMessages.ERR_MEM_HANDLER_DELETE_REQUIRES_AUTH.get(), null), new Control[0]);
            }
            try {
                ASN1OctetString txnID = this.processTransactionRequest(messageID, request, controlMap);
                if (txnID != null) {
                    return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(0, null, ListenerMessages.INFO_MEM_HANDLER_OP_IN_TXN.get(txnID.stringValue()), null), new Control[0]);
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(le.getResultCode().intValue(), le.getMatchedDN(), le.getDiagnosticMessage(), StaticUtils.toList(le.getReferralURLs())), le.getResponseControls());
            }
            try {
                dn = new DN(request.getDN(), this.schemaRef.get());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(34, null, ListenerMessages.ERR_MEM_HANDLER_DELETE_MALFORMED_DN.get(request.getDN(), le.getMessage()), null), new Control[0]);
            }
            if (!controlMap.containsKey("2.16.840.1.113730.3.4.2") && (referralEntry = this.findNearestReferral(dn)) != null) {
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(10, referralEntry.getDN(), ListenerMessages.INFO_MEM_HANDLER_REFERRAL_ENCOUNTERED.get(), InMemoryRequestHandler.getReferralURLs(dn, referralEntry)), new Control[0]);
            }
            if (dn.isNullDN()) {
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_DELETE_ROOT_DSE.get(), null), new Control[0]);
            }
            if (dn.equals(this.subschemaSubentryDN)) {
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_DELETE_SCHEMA.get(this.subschemaSubentryDN.toString()), null), new Control[0]);
            }
            if (dn.isDescendantOf(this.changeLogBaseDN, true)) {
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_DELETE_CHANGELOG.get(request.getDN()), null), new Control[0]);
            }
            Entry entry = this.entryMap.get(dn);
            if (entry == null) {
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(32, this.getMatchedDNString(dn), ListenerMessages.ERR_MEM_HANDLER_DELETE_NO_SUCH_ENTRY.get(request.getDN()), null), new Control[0]);
            }
            ArrayList<DN> subordinateDNs = new ArrayList<DN>(this.entryMap.size());
            for (DN mapEntryDN : this.entryMap.keySet()) {
                if (!mapEntryDN.isDescendantOf(dn, false)) continue;
                subordinateDNs.add(mapEntryDN);
            }
            if (!subordinateDNs.isEmpty() && !controlMap.containsKey("1.2.840.113556.1.4.805")) {
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(66, null, ListenerMessages.ERR_MEM_HANDLER_DELETE_HAS_SUBORDINATES.get(request.getDN()), null), new Control[0]);
            }
            try {
                InMemoryRequestHandler.handleAssertionRequestControl(controlMap, entry);
                PreReadResponseControl preReadResponse = this.handlePreReadControl(controlMap, entry);
                if (preReadResponse != null) {
                    responseControls.add(preReadResponse);
                }
                authzDN = this.handleProxiedAuthControl(controlMap);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            for (int i = subordinateDNs.size() - 1; i >= 0; --i) {
                DN subordinateDN = (DN)subordinateDNs.get(i);
                Entry subEntry = this.entryMap.remove(subordinateDN);
                this.indexDelete(subEntry);
                this.addDeleteChangeLogEntry(subEntry, authzDN);
                this.handleReferentialIntegrityDelete(subordinateDN);
            }
            this.entryMap.remove(dn);
            this.indexDelete(entry);
            this.addDeleteChangeLogEntry(entry, authzDN);
            this.handleReferentialIntegrityDelete(dn);
            return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(0, null, null, null), responseControls);
        }
    }

    private void handleReferentialIntegrityDelete(DN dn) {
        if (this.referentialIntegrityAttributes.isEmpty()) {
            return;
        }
        ArrayList<DN> entryDNs = new ArrayList<DN>(this.entryMap.keySet());
        for (DN mapDN : entryDNs) {
            ReadOnlyEntry e = this.entryMap.get(mapDN);
            boolean referenceFound = false;
            Schema schema = this.schemaRef.get();
            for (String attrName : this.referentialIntegrityAttributes) {
                Attribute a = e.getAttribute(attrName, schema);
                if (a == null || !a.hasValue(dn.toNormalizedString(), (MatchingRule)DistinguishedNameMatchingRule.getInstance())) continue;
                referenceFound = true;
                break;
            }
            if (!referenceFound) continue;
            Entry copy = e.duplicate();
            for (String attrName : this.referentialIntegrityAttributes) {
                copy.removeAttributeValue(attrName, dn.toNormalizedString(), (MatchingRule)DistinguishedNameMatchingRule.getInstance());
            }
            this.entryMap.put(mapDN, new ReadOnlyEntry(copy));
            this.indexDelete(e);
            this.indexAdd(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processExtendedRequest(int messageID, ExtendedRequestProtocolOp request, List<Control> controls) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            this.sleepBeforeProcessing();
            boolean isInternalOp = false;
            for (Control c : controls) {
                if (!c.getOID().equals(OID_INTERNAL_OPERATION_REQUEST_CONTROL)) continue;
                isInternalOp = true;
                break;
            }
            if (!isInternalOp && !this.config.getAllowedOperationTypes().contains((Object)OperationType.EXTENDED)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_EXTENDED_NOT_ALLOWED.get(), null, null, null), new Control[0]);
            }
            if (this.authenticatedDN.isNullDN() && this.config.getAuthenticationRequiredOperationTypes().contains((Object)OperationType.EXTENDED)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(50, null, ListenerMessages.ERR_MEM_HANDLER_EXTENDED_REQUIRES_AUTH.get(), null, null, null), new Control[0]);
            }
            String oid = request.getOID();
            InMemoryExtendedOperationHandler handler = this.extendedRequestHandlers.get(oid);
            if (handler == null) {
                return new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_EXTENDED_OP_NOT_SUPPORTED.get(oid), null, null, null), new Control[0]);
            }
            try {
                Control[] controlArray = new Control[controls.size()];
                controls.toArray(controlArray);
                ExtendedRequest extendedRequest = new ExtendedRequest(oid, request.getValue(), controlArray);
                ExtendedResult extendedResult = handler.processExtendedOperation(this, messageID, extendedRequest);
                return new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(extendedResult.getResultCode().intValue(), extendedResult.getMatchedDN(), extendedResult.getDiagnosticMessage(), Arrays.asList(extendedResult.getReferralURLs()), extendedResult.getOID(), extendedResult.getValue()), extendedResult.getResponseControls());
            }
            catch (Exception e) {
                Debug.debugException(e);
                return new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(80, null, ListenerMessages.ERR_MEM_HANDLER_EXTENDED_OP_FAILURE.get(StaticUtils.getExceptionMessage(e)), null, null, null), new Control[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processModifyRequest(int messageID, ModifyRequestProtocolOp request, List<Control> controls) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            PostReadResponseControl postReadResponse;
            PreReadResponseControl preReadResponse;
            DN authzDN;
            Entry modifiedEntry;
            Entry referralEntry;
            DN dn;
            Map<String, Control> controlMap;
            this.sleepBeforeProcessing();
            try {
                controlMap = RequestControlPreProcessor.processControls((byte)102, controls);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            ArrayList<Control> responseControls = new ArrayList<Control>(1);
            boolean isInternalOp = controlMap.containsKey(OID_INTERNAL_OPERATION_REQUEST_CONTROL);
            if (!isInternalOp && !this.config.getAllowedOperationTypes().contains((Object)OperationType.MODIFY)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_MODIFY_NOT_ALLOWED.get(), null), new Control[0]);
            }
            if (this.authenticatedDN.isNullDN() && this.config.getAuthenticationRequiredOperationTypes().contains((Object)OperationType.MODIFY)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(50, null, ListenerMessages.ERR_MEM_HANDLER_MODIFY_REQUIRES_AUTH.get(), null), new Control[0]);
            }
            try {
                ASN1OctetString txnID = this.processTransactionRequest(messageID, request, controlMap);
                if (txnID != null) {
                    return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(0, null, ListenerMessages.INFO_MEM_HANDLER_OP_IN_TXN.get(txnID.stringValue()), null), new Control[0]);
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(le.getResultCode().intValue(), le.getMatchedDN(), le.getDiagnosticMessage(), StaticUtils.toList(le.getReferralURLs())), le.getResponseControls());
            }
            Schema schema = this.schemaRef.get();
            try {
                dn = new DN(request.getDN(), schema);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(34, null, ListenerMessages.ERR_MEM_HANDLER_MOD_MALFORMED_DN.get(request.getDN(), le.getMessage()), null), new Control[0]);
            }
            if (!controlMap.containsKey("2.16.840.1.113730.3.4.2") && (referralEntry = this.findNearestReferral(dn)) != null) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(10, referralEntry.getDN(), ListenerMessages.INFO_MEM_HANDLER_REFERRAL_ENCOUNTERED.get(), InMemoryRequestHandler.getReferralURLs(dn, referralEntry)), new Control[0]);
            }
            if (dn.isNullDN()) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_MOD_ROOT_DSE.get(), null), new Control[0]);
            }
            if (dn.equals(this.subschemaSubentryDN)) {
                try {
                    this.validateSchemaMods(request);
                }
                catch (LDAPException le) {
                    return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(le.getResultCode().intValue(), le.getMatchedDN(), le.getMessage(), null), new Control[0]);
                }
            } else if (dn.isDescendantOf(this.changeLogBaseDN, true)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_MOD_CHANGELOG.get(request.getDN()), null), new Control[0]);
            }
            Entry entry = this.entryMap.get(dn);
            if (entry == null) {
                if (dn.equals(this.subschemaSubentryDN)) {
                    entry = this.subschemaSubentryRef.get().duplicate();
                } else {
                    return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(32, this.getMatchedDNString(dn), ListenerMessages.ERR_MEM_HANDLER_MOD_NO_SUCH_ENTRY.get(request.getDN()), null), new Control[0]);
                }
            }
            ReadOnlyEntry readOnlyEntry = new ReadOnlyEntry(entry);
            List<Modification> unencodedMods = request.getModifications();
            ArrayList<Modification> modifications = new ArrayList<Modification>(unencodedMods.size());
            for (Modification m : unencodedMods) {
                try {
                    modifications.add(this.encodeModificationPasswords(m, readOnlyEntry, unencodedMods));
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (le.getResultCode().isClientSideResultCode()) {
                        return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(53, le.getMatchedDN(), le.getMessage(), null), new Control[0]);
                    }
                    return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(le.getResultCode().intValue(), le.getMatchedDN(), le.getMessage(), null), new Control[0]);
                }
            }
            try {
                modifiedEntry = Entry.applyModifications(entry, controlMap.containsKey("1.2.840.113556.1.4.1413"), modifications);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(le.getResultCode().intValue(), null, ListenerMessages.ERR_MEM_HANDLER_MOD_FAILED.get(request.getDN(), le.getMessage()), null), new Control[0]);
            }
            EntryValidator entryValidator = this.entryValidatorRef.get();
            if (entryValidator != null) {
                ArrayList<String> invalidReasons = new ArrayList<String>(1);
                if (!entryValidator.entryIsValid(modifiedEntry, invalidReasons)) {
                    return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(65, null, ListenerMessages.ERR_MEM_HANDLER_MOD_VIOLATES_SCHEMA.get(request.getDN(), StaticUtils.concatenateStrings(invalidReasons)), null), new Control[0]);
                }
                for (Modification m : modifications) {
                    Attribute a = m.getAttribute();
                    String baseName = a.getBaseName();
                    AttributeTypeDefinition at = schema.getAttributeType(baseName);
                    if (isInternalOp || at == null || !at.isNoUserModification()) continue;
                    return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(19, null, ListenerMessages.ERR_MEM_HANDLER_MOD_NO_USER_MOD.get(request.getDN(), a.getName()), null), new Control[0]);
                }
            }
            try {
                InMemoryRequestHandler.handleAssertionRequestControl(controlMap, entry);
                authzDN = this.handleProxiedAuthControl(controlMap);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            if (this.generateOperationalAttributes) {
                modifiedEntry.setAttribute(new Attribute("modifiersName", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), authzDN.toString()));
                modifiedEntry.setAttribute(new Attribute("modifyTimestamp", (MatchingRule)GeneralizedTimeMatchingRule.getInstance(), StaticUtils.encodeGeneralizedTime(new Date())));
            }
            if ((preReadResponse = this.handlePreReadControl(controlMap, entry)) != null) {
                responseControls.add(preReadResponse);
            }
            if ((postReadResponse = this.handlePostReadControl(controlMap, modifiedEntry)) != null) {
                responseControls.add(postReadResponse);
            }
            if (dn.equals(this.subschemaSubentryDN)) {
                Schema newSchema = new Schema(modifiedEntry);
                this.subschemaSubentryRef.set(new ReadOnlyEntry(modifiedEntry));
                this.schemaRef.set(newSchema);
                this.entryValidatorRef.set(new EntryValidator(newSchema));
            } else {
                this.entryMap.put(dn, new ReadOnlyEntry(modifiedEntry));
                this.indexDelete(entry);
                this.indexAdd(modifiedEntry);
            }
            this.addChangeLogEntry(request, authzDN);
            return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(0, null, null, null), responseControls);
        }
    }

    private Modification encodeModificationPasswords(Modification mod, ReadOnlyEntry entry, List<Modification> mods) throws LDAPException {
        ASN1OctetString[] originalValues = mod.getRawValues();
        if (originalValues.length == 0) {
            return mod;
        }
        if (this.extendedPasswordAttributes.isEmpty() || this.passwordEncoders.isEmpty()) {
            return mod;
        }
        boolean isPasswordAttribute = false;
        for (String passwordAttribute : this.extendedPasswordAttributes) {
            if (!mod.getAttribute().getBaseName().equalsIgnoreCase(passwordAttribute)) continue;
            isPasswordAttribute = true;
            break;
        }
        if (!isPasswordAttribute) {
            return mod;
        }
        ASN1OctetString[] newValues = new ASN1OctetString[originalValues.length];
        for (int i = 0; i < originalValues.length; ++i) {
            newValues[i] = this.encodeModValue(originalValues[i], mod, entry, mods);
        }
        return new Modification(mod.getModificationType(), mod.getAttributeName(), newValues);
    }

    private ASN1OctetString encodeModValue(ASN1OctetString value, Modification mod, ReadOnlyEntry entry, List<Modification> mods) throws LDAPException {
        for (InMemoryPasswordEncoder encoder : this.passwordEncoders) {
            if (!encoder.passwordStartsWithPrefix(value)) continue;
            encoder.ensurePreEncodedPasswordAppearsValid(value, entry, mods);
            return value;
        }
        ModificationType modificationType = mod.getModificationType();
        if (modificationType == ModificationType.ADD || modificationType == ModificationType.REPLACE) {
            if (this.primaryPasswordEncoder == null) {
                return value;
            }
            return this.primaryPasswordEncoder.encodePassword(value, entry, mods);
        }
        if (modificationType == ModificationType.DELETE) {
            Attribute existingAttribute = entry.getAttribute(mod.getAttributeName());
            if (existingAttribute == null) {
                return value;
            }
            for (ASN1OctetString existingValue : existingAttribute.getRawValues()) {
                if (value.equalsIgnoreType(existingValue)) {
                    return value;
                }
                for (InMemoryPasswordEncoder encoder : this.passwordEncoders) {
                    if (!encoder.clearPasswordMatchesEncodedPassword(value, existingValue, entry)) continue;
                    return existingValue;
                }
            }
            return value;
        }
        return value;
    }

    private void validateSchemaMods(ModifyRequestProtocolOp request) throws LDAPException {
        if (this.schemaRef.get() == null) {
            throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_MEM_HANDLER_MOD_SCHEMA.get(this.subschemaSubentryDN.toString()));
        }
        for (Modification m : request.getModifications()) {
            String attrName = m.getAttributeName();
            if (attrName.equalsIgnoreCase("ldapSyntaxes") || attrName.equalsIgnoreCase("matchingRules")) {
                throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_MEM_HANDLER_MOD_SCHEMA_DISALLOWED_ATTR.get(attrName));
            }
            if (attrName.equalsIgnoreCase("attributeTypes")) {
                if (m.getModificationType() == ModificationType.ADD) {
                    for (String value : m.getValues()) {
                        new AttributeTypeDefinition(value);
                    }
                    continue;
                }
                if (m.getModificationType() == ModificationType.DELETE) continue;
                throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_MEM_HANDLER_MOD_SCHEMA_DISALLOWED_MOD_TYPE.get(m.getModificationType().getName(), attrName));
            }
            if (attrName.equalsIgnoreCase("objectClasses")) {
                if (m.getModificationType() == ModificationType.ADD) {
                    for (String value : m.getValues()) {
                        new ObjectClassDefinition(value);
                    }
                    continue;
                }
                if (m.getModificationType() == ModificationType.DELETE) continue;
                throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_MEM_HANDLER_MOD_SCHEMA_DISALLOWED_MOD_TYPE.get(m.getModificationType().getName(), attrName));
            }
            if (attrName.equalsIgnoreCase("nameForms")) {
                if (m.getModificationType() == ModificationType.ADD) {
                    for (String value : m.getValues()) {
                        new NameFormDefinition(value);
                    }
                    continue;
                }
                if (m.getModificationType() == ModificationType.DELETE) continue;
                throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_MEM_HANDLER_MOD_SCHEMA_DISALLOWED_MOD_TYPE.get(m.getModificationType().getName(), attrName));
            }
            if (attrName.equalsIgnoreCase("dITContentRules")) {
                if (m.getModificationType() == ModificationType.ADD) {
                    for (String value : m.getValues()) {
                        new DITContentRuleDefinition(value);
                    }
                    continue;
                }
                if (m.getModificationType() == ModificationType.DELETE) continue;
                throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_MEM_HANDLER_MOD_SCHEMA_DISALLOWED_MOD_TYPE.get(m.getModificationType().getName(), attrName));
            }
            if (attrName.equalsIgnoreCase("dITStructureRules")) {
                if (m.getModificationType() == ModificationType.ADD) {
                    for (String value : m.getValues()) {
                        new DITStructureRuleDefinition(value);
                    }
                    continue;
                }
                if (m.getModificationType() == ModificationType.DELETE) continue;
                throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_MEM_HANDLER_MOD_SCHEMA_DISALLOWED_MOD_TYPE.get(m.getModificationType().getName(), attrName));
            }
            if (!attrName.equalsIgnoreCase("matchingRuleUse")) continue;
            if (m.getModificationType() == ModificationType.ADD) {
                for (String value : m.getValues()) {
                    new MatchingRuleUseDefinition(value);
                }
                continue;
            }
            if (m.getModificationType() == ModificationType.DELETE) continue;
            throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_MEM_HANDLER_MOD_SCHEMA_DISALLOWED_MOD_TYPE.get(m.getModificationType().getName(), attrName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processModifyDNRequest(int messageID, ModifyDNRequestProtocolOp request, List<Control> controls) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            PostReadResponseControl postReadResponse;
            PreReadResponseControl preReadResponse;
            DN authzDN;
            int i;
            DN newParent;
            Entry referralEntry;
            DN originalParent;
            Entry referralEntry2;
            DN newSuperiorDN;
            RDN newRDN;
            DN dn;
            Map<String, Control> controlMap;
            this.sleepBeforeProcessing();
            try {
                controlMap = RequestControlPreProcessor.processControls((byte)108, controls);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            ArrayList<Control> responseControls = new ArrayList<Control>(1);
            boolean isInternalOp = controlMap.containsKey(OID_INTERNAL_OPERATION_REQUEST_CONTROL);
            if (!isInternalOp && !this.config.getAllowedOperationTypes().contains((Object)OperationType.MODIFY_DN)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_MODIFY_DN_NOT_ALLOWED.get(), null), new Control[0]);
            }
            if (this.authenticatedDN.isNullDN() && this.config.getAuthenticationRequiredOperationTypes().contains((Object)OperationType.MODIFY_DN)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(50, null, ListenerMessages.ERR_MEM_HANDLER_MODIFY_DN_REQUIRES_AUTH.get(), null), new Control[0]);
            }
            try {
                ASN1OctetString txnID = this.processTransactionRequest(messageID, request, controlMap);
                if (txnID != null) {
                    return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(0, null, ListenerMessages.INFO_MEM_HANDLER_OP_IN_TXN.get(txnID.stringValue()), null), new Control[0]);
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(le.getResultCode().intValue(), le.getMatchedDN(), le.getDiagnosticMessage(), StaticUtils.toList(le.getReferralURLs())), le.getResponseControls());
            }
            Schema schema = this.schemaRef.get();
            try {
                dn = new DN(request.getDN(), schema);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(34, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_MALFORMED_DN.get(request.getDN(), le.getMessage()), null), new Control[0]);
            }
            try {
                newRDN = new RDN(request.getNewRDN(), schema);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(34, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_MALFORMED_NEW_RDN.get(request.getDN(), request.getNewRDN(), le.getMessage()), null), new Control[0]);
            }
            String newSuperiorString = request.getNewSuperiorDN();
            if (newSuperiorString == null) {
                newSuperiorDN = null;
            } else {
                try {
                    newSuperiorDN = new DN(newSuperiorString, schema);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(34, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_MALFORMED_NEW_SUPERIOR.get(request.getDN(), request.getNewSuperiorDN(), le.getMessage()), null), new Control[0]);
                }
            }
            if (!controlMap.containsKey("2.16.840.1.113730.3.4.2") && (referralEntry2 = this.findNearestReferral(dn)) != null) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(10, referralEntry2.getDN(), ListenerMessages.INFO_MEM_HANDLER_REFERRAL_ENCOUNTERED.get(), InMemoryRequestHandler.getReferralURLs(dn, referralEntry2)), new Control[0]);
            }
            if (dn.isNullDN()) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_ROOT_DSE.get(), null), new Control[0]);
            }
            if (dn.equals(this.subschemaSubentryDN)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_SOURCE_IS_SCHEMA.get(), null), new Control[0]);
            }
            if (dn.isDescendantOf(this.changeLogBaseDN, true)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_SOURCE_IS_CHANGELOG.get(), null), new Control[0]);
            }
            DN newDN = newSuperiorDN == null ? ((originalParent = dn.getParent()) == null ? new DN(newRDN) : new DN(newRDN, originalParent)) : new DN(newRDN, newSuperiorDN);
            if (newDN.equals(dn)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_NEW_DN_SAME_AS_OLD.get(request.getDN()), null), new Control[0]);
            }
            if (!controlMap.containsKey("2.16.840.1.113730.3.4.2") && (referralEntry = this.findNearestReferral(newDN)) != null) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(53, referralEntry.getDN(), ListenerMessages.ERR_MEM_HANDLER_MOD_DN_NEW_DN_BELOW_REFERRAL.get(request.getDN(), referralEntry.getDN().toString(), newDN.toString()), null), new Control[0]);
            }
            Entry originalEntry = this.entryMap.get(dn);
            if (originalEntry == null) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(32, this.getMatchedDNString(dn), ListenerMessages.ERR_MEM_HANDLER_MOD_DN_NO_SUCH_ENTRY.get(request.getDN()), null), new Control[0]);
            }
            if (newDN.equals(this.subschemaSubentryDN)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(68, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_TARGET_IS_SCHEMA.get(request.getDN(), newDN.toString()), null), new Control[0]);
            }
            if (newDN.isDescendantOf(this.changeLogBaseDN, true)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_TARGET_IS_CHANGELOG.get(request.getDN(), newDN.toString()), null), new Control[0]);
            }
            if (this.entryMap.containsKey(newDN)) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(68, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_TARGET_ALREADY_EXISTS.get(request.getDN(), newDN.toString()), null), new Control[0]);
            }
            if (!(this.baseDNs.contains(newDN) || (newParent = newDN.getParent()) != null && this.entryMap.containsKey(newParent))) {
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(32, this.getMatchedDNString(newDN), ListenerMessages.ERR_MEM_HANDLER_MOD_DN_PARENT_DOESNT_EXIST.get(request.getDN(), newDN.toString()), null), new Control[0]);
            }
            RDN originalRDN = dn.getRDN();
            Entry updatedEntry = originalEntry.duplicate();
            updatedEntry.setDN(newDN);
            if (request.deleteOldRDN()) {
                String[] oldRDNNames = originalRDN.getAttributeNames();
                byte[][] oldRDNValues = originalRDN.getByteArrayAttributeValues();
                for (i = 0; i < oldRDNNames.length; ++i) {
                    updatedEntry.removeAttributeValue(oldRDNNames[i], oldRDNValues[i]);
                }
            }
            String[] newRDNNames = newRDN.getAttributeNames();
            byte[][] newRDNValues = newRDN.getByteArrayAttributeValues();
            for (i = 0; i < newRDNNames.length; ++i) {
                MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(newRDNNames[i], schema);
                updatedEntry.addAttribute(new Attribute(newRDNNames[i], matchingRule, newRDNValues[i]));
            }
            EntryValidator entryValidator = this.entryValidatorRef.get();
            if (entryValidator != null) {
                byte[] value;
                AttributeTypeDefinition at;
                String name;
                int i2;
                ArrayList<String> invalidReasons = new ArrayList<String>(1);
                if (!entryValidator.entryIsValid(updatedEntry, invalidReasons)) {
                    return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(65, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_VIOLATES_SCHEMA.get(request.getDN(), StaticUtils.concatenateStrings(invalidReasons)), null), new Control[0]);
                }
                String[] oldRDNNames = originalRDN.getAttributeNames();
                for (i2 = 0; i2 < oldRDNNames.length; ++i2) {
                    name = oldRDNNames[i2];
                    at = schema.getAttributeType(name);
                    if (isInternalOp || at == null || !at.isNoUserModification() || updatedEntry.hasAttributeValue(name, value = originalRDN.getByteArrayAttributeValues()[i2])) continue;
                    return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(19, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_NO_USER_MOD.get(request.getDN(), name), null), new Control[0]);
                }
                for (i2 = 0; i2 < newRDNNames.length; ++i2) {
                    name = newRDNNames[i2];
                    at = schema.getAttributeType(name);
                    if (isInternalOp || at == null || !at.isNoUserModification() || originalEntry.hasAttributeValue(name, value = newRDN.getByteArrayAttributeValues()[i2])) continue;
                    return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(19, null, ListenerMessages.ERR_MEM_HANDLER_MOD_DN_NO_USER_MOD.get(request.getDN(), name), null), new Control[0]);
                }
            }
            try {
                InMemoryRequestHandler.handleAssertionRequestControl(controlMap, originalEntry);
                authzDN = this.handleProxiedAuthControl(controlMap);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            if (this.generateOperationalAttributes) {
                updatedEntry.setAttribute(new Attribute("modifiersName", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), authzDN.toString()));
                updatedEntry.setAttribute(new Attribute("modifyTimestamp", (MatchingRule)GeneralizedTimeMatchingRule.getInstance(), StaticUtils.encodeGeneralizedTime(new Date())));
                updatedEntry.setAttribute(new Attribute("entryDN", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), newDN.toNormalizedString()));
            }
            if ((preReadResponse = this.handlePreReadControl(controlMap, originalEntry)) != null) {
                responseControls.add(preReadResponse);
            }
            if ((postReadResponse = this.handlePostReadControl(controlMap, updatedEntry)) != null) {
                responseControls.add(postReadResponse);
            }
            this.entryMap.remove(dn);
            this.entryMap.put(newDN, new ReadOnlyEntry(updatedEntry));
            this.indexDelete(originalEntry);
            this.indexAdd(updatedEntry);
            RDN[] oldDNComps = dn.getRDNs();
            RDN[] newDNComps = newDN.getRDNs();
            LinkedHashSet<DN> dnSet = new LinkedHashSet<DN>(this.entryMap.keySet());
            for (DN mapEntryDN : dnSet) {
                if (!mapEntryDN.isDescendantOf(dn, false)) continue;
                Entry o = this.entryMap.remove(mapEntryDN);
                Entry e = o.duplicate();
                RDN[] oldMapEntryComps = mapEntryDN.getRDNs();
                int compsToSave = oldMapEntryComps.length - oldDNComps.length;
                RDN[] newMapEntryComps = new RDN[compsToSave + newDNComps.length];
                System.arraycopy(oldMapEntryComps, 0, newMapEntryComps, 0, compsToSave);
                System.arraycopy(newDNComps, 0, newMapEntryComps, compsToSave, newDNComps.length);
                DN newMapEntryDN = new DN(newMapEntryComps);
                e.setDN(newMapEntryDN);
                if (this.generateOperationalAttributes) {
                    e.setAttribute(new Attribute("entryDN", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), newMapEntryDN.toNormalizedString()));
                }
                this.entryMap.put(newMapEntryDN, new ReadOnlyEntry(e));
                this.indexDelete(o);
                this.indexAdd(e);
                this.handleReferentialIntegrityModifyDN(mapEntryDN, newMapEntryDN);
            }
            this.addChangeLogEntry(request, authzDN);
            this.handleReferentialIntegrityModifyDN(dn, newDN);
            return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(0, null, null, null), responseControls);
        }
    }

    private void handleReferentialIntegrityModifyDN(DN oldDN, DN newDN) {
        if (this.referentialIntegrityAttributes.isEmpty()) {
            return;
        }
        ArrayList<DN> entryDNs = new ArrayList<DN>(this.entryMap.keySet());
        for (DN mapDN : entryDNs) {
            ReadOnlyEntry e = this.entryMap.get(mapDN);
            boolean referenceFound = false;
            Schema schema = this.schemaRef.get();
            for (String attrName : this.referentialIntegrityAttributes) {
                Attribute a = e.getAttribute(attrName, schema);
                if (a == null || !a.hasValue(oldDN.toNormalizedString(), (MatchingRule)DistinguishedNameMatchingRule.getInstance())) continue;
                referenceFound = true;
                break;
            }
            if (!referenceFound) continue;
            Entry copy = e.duplicate();
            for (String attrName : this.referentialIntegrityAttributes) {
                if (!copy.removeAttributeValue(attrName, oldDN.toNormalizedString(), (MatchingRule)DistinguishedNameMatchingRule.getInstance())) continue;
                copy.addAttribute(attrName, newDN.toString());
            }
            this.entryMap.put(mapDN, new ReadOnlyEntry(copy));
            this.indexDelete(e);
            this.indexAdd(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            ArrayList<SearchResultEntry> entryList = new ArrayList<SearchResultEntry>(this.entryMap.size());
            ArrayList<SearchResultReference> referenceList = new ArrayList<SearchResultReference>(this.entryMap.size());
            LDAPMessage returnMessage = this.processSearchRequest(messageID, request, controls, entryList, referenceList);
            for (SearchResultEntry e : entryList) {
                try {
                    this.connection.sendSearchResultEntry(messageID, e, e.getControls());
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(le.getResultCode().intValue(), le.getMatchedDN(), le.getDiagnosticMessage(), StaticUtils.toList(le.getReferralURLs())), le.getResponseControls());
                }
            }
            for (SearchResultReference r : referenceList) {
                try {
                    this.connection.sendSearchResultReference(messageID, new SearchResultReferenceProtocolOp(StaticUtils.toList(r.getReferralURLs())), r.getControls());
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(le.getResultCode().intValue(), le.getMatchedDN(), le.getDiagnosticMessage(), StaticUtils.toList(le.getReferralURLs())), le.getResponseControls());
                }
            }
            return returnMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls, List<SearchResultEntry> entryList, List<SearchResultReference> referenceList) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            VirtualListViewRequestControl vlvRequest;
            SimplePagedResultsControl pagedResultsControl;
            ServerSideSortRequestControl sortRequestControl;
            boolean includeNonSubEntries;
            boolean includeSubEntries;
            Entry baseEntry;
            Entry referralEntry;
            DN baseDN;
            Map<String, Control> controlMap;
            long processingStartTime = System.currentTimeMillis();
            this.sleepBeforeProcessing();
            long timeLimitMillis = 1000L * (long)request.getTimeLimit();
            if (timeLimitMillis > 0L) {
                long timeLimitExpirationTime = processingStartTime + timeLimitMillis;
                if (System.currentTimeMillis() >= timeLimitExpirationTime) {
                    return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(3, null, ListenerMessages.ERR_MEM_HANDLER_TIME_LIMIT_EXCEEDED.get(), null), new Control[0]);
                }
            }
            try {
                controlMap = RequestControlPreProcessor.processControls((byte)99, controls);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            ArrayList<Control> responseControls = new ArrayList<Control>(1);
            boolean isInternalOp = controlMap.containsKey(OID_INTERNAL_OPERATION_REQUEST_CONTROL);
            if (!isInternalOp && !this.config.getAllowedOperationTypes().contains((Object)OperationType.SEARCH)) {
                return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(53, null, ListenerMessages.ERR_MEM_HANDLER_SEARCH_NOT_ALLOWED.get(), null), new Control[0]);
            }
            if (this.authenticatedDN.isNullDN() && this.config.getAuthenticationRequiredOperationTypes().contains((Object)OperationType.SEARCH)) {
                return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(50, null, ListenerMessages.ERR_MEM_HANDLER_SEARCH_REQUIRES_AUTH.get(), null), new Control[0]);
            }
            Schema schema = this.schemaRef.get();
            try {
                baseDN = new DN(request.getBaseDN(), schema);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(34, null, ListenerMessages.ERR_MEM_HANDLER_SEARCH_MALFORMED_BASE.get(request.getBaseDN(), le.getMessage()), null), new Control[0]);
            }
            boolean hasManageDsaIT = controlMap.containsKey("2.16.840.1.113730.3.4.2");
            if (!hasManageDsaIT && (referralEntry = this.findNearestReferral(baseDN)) != null) {
                return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(10, referralEntry.getDN(), ListenerMessages.INFO_MEM_HANDLER_REFERRAL_ENCOUNTERED.get(), InMemoryRequestHandler.getReferralURLs(baseDN, referralEntry)), new Control[0]);
            }
            boolean includeChangeLog = true;
            if (baseDN.isNullDN()) {
                baseEntry = this.generateRootDSE();
                includeChangeLog = false;
            } else {
                baseEntry = baseDN.equals(this.subschemaSubentryDN) ? (Entry)this.subschemaSubentryRef.get() : (Entry)this.entryMap.get(baseDN);
            }
            if (baseEntry == null) {
                return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(32, this.getMatchedDNString(baseDN), ListenerMessages.ERR_MEM_HANDLER_SEARCH_BASE_DOES_NOT_EXIST.get(request.getBaseDN()), null), new Control[0]);
            }
            try {
                InMemoryRequestHandler.handleAssertionRequestControl(controlMap, baseEntry);
                this.handleProxiedAuthControl(controlMap);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(le.getResultCode().intValue(), null, le.getMessage(), null), new Control[0]);
            }
            SearchScope scope = request.getScope();
            if (scope == SearchScope.BASE) {
                includeSubEntries = true;
                includeNonSubEntries = true;
            } else if (controlMap.containsKey("1.3.6.1.4.1.7628.5.101.1")) {
                includeSubEntries = true;
                includeNonSubEntries = false;
            } else if (baseEntry.hasObjectClass("ldapSubEntry") || baseEntry.hasObjectClass("inheritableLDAPSubEntry")) {
                includeSubEntries = true;
                includeNonSubEntries = true;
            } else {
                includeSubEntries = false;
                includeNonSubEntries = true;
            }
            ArrayList<Entry> fullEntryList = new ArrayList<Entry>(this.entryMap.size());
            Filter filter = request.getFilter();
            if (scope == SearchScope.BASE) {
                try {
                    if (filter.matchesEntry(baseEntry, schema)) {
                        this.processSearchEntry(baseEntry, includeSubEntries, includeNonSubEntries, includeChangeLog, hasManageDsaIT, fullEntryList, referenceList);
                    }
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            } else if (scope == SearchScope.ONE && baseDN.isNullDN()) {
                for (DN dn : this.baseDNs) {
                    Entry entry = this.entryMap.get(dn);
                    if (entry == null) continue;
                    try {
                        if (!filter.matchesEntry(entry, schema)) continue;
                        this.processSearchEntry(entry, includeSubEntries, includeNonSubEntries, includeChangeLog, hasManageDsaIT, fullEntryList, referenceList);
                    }
                    catch (Exception ex) {
                        Debug.debugException(ex);
                    }
                }
            } else {
                Set<DN> candidateDNs = this.indexSearch(filter);
                if (candidateDNs == null) {
                    for (Map.Entry entry : this.entryMap.entrySet()) {
                        DN dn = (DN)entry.getKey();
                        Entry entry2 = (Entry)entry.getValue();
                        try {
                            if (!dn.matchesBaseAndScope(baseDN, scope) || !filter.matchesEntry(entry2, schema)) continue;
                            this.processSearchEntry(entry2, includeSubEntries, includeNonSubEntries, includeChangeLog, hasManageDsaIT, fullEntryList, referenceList);
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                } else {
                    for (DN dN : candidateDNs) {
                        try {
                            Entry entry;
                            if (!dN.matchesBaseAndScope(baseDN, scope) || !filter.matchesEntry(entry = (Entry)this.entryMap.get(dN), schema)) continue;
                            this.processSearchEntry(entry, includeSubEntries, includeNonSubEntries, includeChangeLog, hasManageDsaIT, fullEntryList, referenceList);
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                }
            }
            if ((sortRequestControl = (ServerSideSortRequestControl)controlMap.get("1.2.840.113556.1.4.473")) != null) {
                EntrySorter entrySorter = new EntrySorter(false, schema, sortRequestControl.getSortKeys());
                SortedSet<Entry> sortedEntrySet = entrySorter.sort(fullEntryList);
                fullEntryList.clear();
                fullEntryList.addAll(sortedEntrySet);
                responseControls.add(new ServerSideSortResponseControl(ResultCode.SUCCESS, null));
            }
            if ((pagedResultsControl = (SimplePagedResultsControl)controlMap.get("1.2.840.113556.1.4.319")) != null) {
                int pos;
                int offset;
                int totalSize = fullEntryList.size();
                int n = pagedResultsControl.getSize();
                ASN1OctetString cookie = pagedResultsControl.getCookie();
                if (cookie == null || cookie.getValueLength() == 0) {
                    offset = 0;
                } else {
                    try {
                        ASN1Integer offsetInteger = ASN1Integer.decodeAsInteger(cookie.getValue());
                        offset = offsetInteger.intValue();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(2, null, ListenerMessages.ERR_MEM_HANDLER_MALFORMED_PAGED_RESULTS_COOKIE.get(), null), responseControls);
                    }
                }
                Iterator iterator = fullEntryList.iterator();
                for (pos = 0; iterator.hasNext() && pos < offset; ++pos) {
                    iterator.next();
                    iterator.remove();
                }
                for (int keptEntries = 0; iterator.hasNext() && keptEntries < n; ++keptEntries) {
                    iterator.next();
                    ++pos;
                }
                if (iterator.hasNext()) {
                    responseControls.add(new SimplePagedResultsControl(totalSize, new ASN1OctetString(new ASN1Integer(pos).encode()), false));
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                } else {
                    responseControls.add(new SimplePagedResultsControl(totalSize, new ASN1OctetString(), false));
                }
            }
            if ((vlvRequest = (VirtualListViewRequestControl)controlMap.get("2.16.840.1.113730.3.4.9")) != null) {
                int n = fullEntryList.size();
                ASN1OctetString assertionValue = vlvRequest.getAssertionValue();
                int offset = vlvRequest.getTargetOffset();
                if (assertionValue == null) {
                    --offset;
                    offset = Math.max(0, offset);
                    offset = Math.min(fullEntryList.size(), offset);
                } else {
                    SortKey primarySortKey = sortRequestControl.getSortKeys()[0];
                    Entry testEntry = new Entry("cn=test", schema, new Attribute(primarySortKey.getAttributeName(), assertionValue));
                    EntrySorter entrySorter = new EntrySorter(false, schema, primarySortKey);
                    offset = fullEntryList.size();
                    for (int i = 0; i < fullEntryList.size(); ++i) {
                        if (entrySorter.compare((Entry)fullEntryList.get(i), testEntry) < 0) continue;
                        offset = i;
                        break;
                    }
                }
                int beforeCount = Math.max(0, vlvRequest.getBeforeCount());
                int afterCount = Math.max(0, vlvRequest.getAfterCount());
                int start = Math.max(0, offset - beforeCount);
                int end = Math.min(fullEntryList.size(), offset + afterCount + 1);
                int pos = 0;
                Iterator iterator = fullEntryList.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    if (pos < start || pos >= end) {
                        iterator.remove();
                    }
                    ++pos;
                }
                responseControls.add(new VirtualListViewResponseControl(offset + 1, n, ResultCode.SUCCESS, null));
            }
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            AtomicBoolean allOpAttrs = new AtomicBoolean(false);
            Map<String, List<List<String>>> returnAttrs = this.processRequestedAttributes(request.getAttributes(), atomicBoolean, allOpAttrs);
            int sizeLimit = request.getSizeLimit() > 0 ? Math.min(request.getSizeLimit(), this.maxSizeLimit) : this.maxSizeLimit;
            int entryCount = 0;
            for (Entry e : fullEntryList) {
                if (++entryCount > sizeLimit) {
                    return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(4, null, ListenerMessages.ERR_MEM_HANDLER_SEARCH_SIZE_LIMIT_EXCEEDED.get(), null), responseControls);
                }
                Entry trimmedEntry = this.trimForRequestedAttributes(e, atomicBoolean.get(), allOpAttrs.get(), returnAttrs);
                if (request.typesOnly()) {
                    Entry typesOnlyEntry = new Entry(trimmedEntry.getDN(), schema);
                    for (Attribute a : trimmedEntry.getAttributes()) {
                        typesOnlyEntry.addAttribute(new Attribute(a.getName()));
                    }
                    entryList.add(new SearchResultEntry(typesOnlyEntry, new Control[0]));
                    continue;
                }
                entryList.add(new SearchResultEntry(trimmedEntry, new Control[0]));
            }
            return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(0, null, null, null), responseControls);
        }
    }

    private void indexAdd(Entry entry) {
        for (InMemoryDirectoryServerEqualityAttributeIndex i : this.equalityIndexes.values()) {
            try {
                i.processAdd(entry);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
            }
        }
    }

    private void indexDelete(Entry entry) {
        for (InMemoryDirectoryServerEqualityAttributeIndex i : this.equalityIndexes.values()) {
            try {
                i.processDelete(entry);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
            }
        }
    }

    private Set<DN> indexSearch(Filter filter) {
        switch (filter.getFilterType()) {
            case -96: {
                Filter[] comps = filter.getComponents();
                if (comps.length == 0) {
                    return null;
                }
                if (comps.length == 1) {
                    return this.indexSearch(comps[0]);
                }
                TreeSet<DN> candidateSet = null;
                for (Filter f : comps) {
                    Set<DN> dnSet = this.indexSearch(f);
                    if (dnSet == null) continue;
                    if (candidateSet == null) {
                        candidateSet = new TreeSet<DN>(dnSet);
                        continue;
                    }
                    candidateSet.retainAll(dnSet);
                }
                return candidateSet;
            }
            case -95: {
                Filter[] comps = filter.getComponents();
                if (comps.length == 0) {
                    return Collections.emptySet();
                }
                if (comps.length == 1) {
                    return this.indexSearch(comps[0]);
                }
                TreeSet<DN> candidateSet = null;
                for (Filter f : comps) {
                    Set<DN> dnSet = this.indexSearch(f);
                    if (dnSet == null) {
                        return null;
                    }
                    if (candidateSet == null) {
                        candidateSet = new TreeSet<DN>(dnSet);
                        continue;
                    }
                    candidateSet.addAll(dnSet);
                }
                return candidateSet;
            }
            case -93: {
                Schema schema = this.schemaRef.get();
                if (schema == null) {
                    return null;
                }
                AttributeTypeDefinition at = schema.getAttributeType(filter.getAttributeName());
                if (at == null) {
                    return null;
                }
                InMemoryDirectoryServerEqualityAttributeIndex i = this.equalityIndexes.get(at);
                if (i == null) {
                    return null;
                }
                try {
                    return i.getMatchingEntries(filter.getRawAssertionValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    return null;
                }
            }
        }
        return null;
    }

    private ASN1OctetString processTransactionRequest(int messageID, ProtocolOp request, Map<String, Control> controls) throws LDAPException {
        TransactionSpecificationRequestControl txnControl = (TransactionSpecificationRequestControl)controls.remove("1.3.6.1.1.21.2");
        if (txnControl == null) {
            return null;
        }
        ASN1OctetString txnID = txnControl.getTransactionID();
        ObjectPair txnInfo = (ObjectPair)this.connectionState.get("TXN-INFO");
        if (txnInfo == null) {
            throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_MEM_HANDLER_TXN_CONTROL_WITHOUT_TXN.get(txnID.stringValue()));
        }
        ASN1OctetString existingTxnID = (ASN1OctetString)txnInfo.getFirst();
        if (!txnID.stringValue().equals(existingTxnID.stringValue())) {
            this.connectionState.remove("TXN-INFO");
            this.connection.sendUnsolicitedNotification(new AbortedTransactionExtendedResult(existingTxnID, ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_MEM_HANDLER_TXN_ABORTED_BY_CONTROL_TXN_ID_MISMATCH.get(existingTxnID.stringValue(), txnID.stringValue()), null, null, null));
            throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_MEM_HANDLER_TXN_CONTROL_ID_MISMATCH.get(txnID.stringValue(), existingTxnID.stringValue()));
        }
        ((List)txnInfo.getSecond()).add(new LDAPMessage(messageID, request, new ArrayList<Control>(controls.values())));
        return txnID;
    }

    private void sleepBeforeProcessing() {
        block3: {
            long delay = this.processingDelayMillis.get();
            if (delay > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (!(e instanceof InterruptedException)) break block3;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public List<String> getPasswordAttributes() {
        return this.configuredPasswordAttributes;
    }

    public InMemoryPasswordEncoder getPrimaryPasswordEncoder() {
        return this.primaryPasswordEncoder;
    }

    public List<InMemoryPasswordEncoder> getAllPasswordEncoders() {
        return this.passwordEncoders;
    }

    public List<InMemoryDirectoryServerPassword> getPasswordsInEntry(Entry entry, ASN1OctetString clearPasswordToMatch) {
        ArrayList<InMemoryDirectoryServerPassword> passwordList = new ArrayList<InMemoryDirectoryServerPassword>(5);
        ReadOnlyEntry readOnlyEntry = new ReadOnlyEntry(entry);
        for (String passwordAttributeName : this.configuredPasswordAttributes) {
            List<Attribute> passwordAttributeList = entry.getAttributesWithOptions(passwordAttributeName, null);
            for (Attribute passwordAttribute : passwordAttributeList) {
                for (ASN1OctetString value : passwordAttribute.getRawValues()) {
                    block7: {
                        InMemoryDirectoryServerPassword password = new InMemoryDirectoryServerPassword(value, readOnlyEntry, passwordAttribute.getName(), this.passwordEncoders);
                        if (clearPasswordToMatch != null) {
                            try {
                                if (!password.matchesClearPassword(clearPasswordToMatch)) {
                                }
                                break block7;
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                            }
                            continue;
                        }
                    }
                    passwordList.add(new InMemoryDirectoryServerPassword(value, readOnlyEntry, passwordAttribute.getName(), this.passwordEncoders));
                }
            }
        }
        return passwordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countEntries(boolean includeChangeLog) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            if (includeChangeLog || this.maxChangelogEntries == 0) {
                return this.entryMap.size();
            }
            int count = 0;
            for (DN dn : this.entryMap.keySet()) {
                if (dn.isDescendantOf(this.changeLogBaseDN, true)) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countEntriesBelow(String baseDN) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            DN parsedBaseDN = new DN(baseDN, this.schemaRef.get());
            int count = 0;
            for (DN dn : this.entryMap.keySet()) {
                if (!dn.isDescendantOf(parsedBaseDN, true)) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            this.restoreSnapshot(this.initialSnapshot);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int importFromLDIF(boolean clear, LDIFReader ldifReader) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            InMemoryDirectoryServerSnapshot snapshot = this.createSnapshot();
            boolean restoreSnapshot = true;
            try {
                if (clear) {
                    this.restoreSnapshot(this.initialSnapshot);
                }
                int entriesAdded = 0;
                while (true) {
                    Entry entry;
                    block16: {
                        int n;
                        try {
                            entry = ldifReader.readEntry();
                            if (entry != null) break block16;
                            restoreSnapshot = false;
                            n = entriesAdded;
                        }
                        catch (LDIFException le) {
                            Debug.debugException(le);
                            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_HANDLER_INIT_FROM_LDIF_READ_ERROR.get(le.getMessage()), le);
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_HANDLER_INIT_FROM_LDIF_READ_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
                        }
                        return n;
                    }
                    this.addEntry(entry, true);
                    ++entriesAdded;
                }
            }
            finally {
                try {
                    ldifReader.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                if (restoreSnapshot) {
                    this.restoreSnapshot(snapshot);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exportToLDIF(LDIFWriter ldifWriter, boolean excludeGeneratedAttrs, boolean excludeChangeLog, boolean closeWriter) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            int n;
            block16: {
                boolean exceptionThrown = false;
                try {
                    int entriesWritten = 0;
                    for (Map.Entry<DN, ReadOnlyEntry> me : this.entryMap.entrySet()) {
                        Entry entry;
                        DN dn = me.getKey();
                        if (excludeChangeLog && dn.isDescendantOf(this.changeLogBaseDN, true)) continue;
                        if (excludeGeneratedAttrs) {
                            entry = me.getValue().duplicate();
                            entry.removeAttribute("entryDN");
                            entry.removeAttribute("entryUUID");
                            entry.removeAttribute("subschemaSubentry");
                            entry.removeAttribute("creatorsName");
                            entry.removeAttribute("createTimestamp");
                            entry.removeAttribute("modifiersName");
                            entry.removeAttribute("modifyTimestamp");
                        } else {
                            entry = me.getValue();
                        }
                        try {
                            ldifWriter.writeEntry(entry);
                            ++entriesWritten;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            exceptionThrown = true;
                            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_HANDLER_LDIF_WRITE_ERROR.get(entry.getDN(), StaticUtils.getExceptionMessage(e)), e);
                        }
                    }
                    n = entriesWritten;
                    if (!closeWriter) break block16;
                }
                catch (Throwable throwable) {
                    block17: {
                        if (closeWriter) {
                            try {
                                ldifWriter.close();
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                                if (exceptionThrown) break block17;
                                throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_HANDLER_LDIF_WRITE_CLOSE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
                            }
                        }
                    }
                    throw throwable;
                }
                try {
                    ldifWriter.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (exceptionThrown) break block16;
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_HANDLER_LDIF_WRITE_CLOSE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            return n;
        }
    }

    public void addEntry(Entry entry, boolean ignoreNoUserModification) throws LDAPException {
        List<Control> controls;
        if (ignoreNoUserModification) {
            controls = new ArrayList(1);
            controls.add(new Control(OID_INTERNAL_OPERATION_REQUEST_CONTROL, false));
        } else {
            controls = Collections.emptyList();
        }
        AddRequestProtocolOp addRequest = new AddRequestProtocolOp(entry.getDN(), new ArrayList<Attribute>(entry.getAttributes()));
        LDAPMessage resultMessage = this.processAddRequest(-1, addRequest, controls);
        AddResponseProtocolOp addResponse = resultMessage.getAddResponseProtocolOp();
        if (addResponse.getResultCode() != 0) {
            throw new LDAPException(ResultCode.valueOf(addResponse.getResultCode()), addResponse.getDiagnosticMessage(), addResponse.getMatchedDN(), InMemoryRequestHandler.stringListToArray(addResponse.getReferralURLs()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntries(List<? extends Entry> entries) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            InMemoryDirectoryServerSnapshot snapshot = this.createSnapshot();
            boolean restoreSnapshot = true;
            try {
                for (Entry entry : entries) {
                    this.addEntry(entry, false);
                }
                restoreSnapshot = false;
            }
            finally {
                if (restoreSnapshot) {
                    this.restoreSnapshot(snapshot);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteSubtree(String baseDN) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            DN dn = new DN(baseDN, this.schemaRef.get());
            if (dn.isNullDN()) {
                throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_MEM_HANDLER_DELETE_ROOT_DSE.get());
            }
            int numDeleted = 0;
            Iterator<Map.Entry<DN, ReadOnlyEntry>> iterator = this.entryMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<DN, ReadOnlyEntry> e = iterator.next();
                if (!e.getKey().isDescendantOf(dn, true)) continue;
                iterator.remove();
                ++numDeleted;
            }
            return numDeleted;
        }
    }

    public void modifyEntry(String dn, List<Modification> mods) throws LDAPException {
        ModifyRequestProtocolOp modifyRequest = new ModifyRequestProtocolOp(dn, mods);
        LDAPMessage resultMessage = this.processModifyRequest(-1, modifyRequest, Collections.emptyList());
        ModifyResponseProtocolOp modifyResponse = resultMessage.getModifyResponseProtocolOp();
        if (modifyResponse.getResultCode() != 0) {
            throw new LDAPException(ResultCode.valueOf(modifyResponse.getResultCode()), modifyResponse.getDiagnosticMessage(), modifyResponse.getMatchedDN(), InMemoryRequestHandler.stringListToArray(modifyResponse.getReferralURLs()));
        }
    }

    public ReadOnlyEntry getEntry(String dn) throws LDAPException {
        return this.getEntry(new DN(dn, this.schemaRef.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyEntry getEntry(DN dn) {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            if (dn.isNullDN()) {
                return this.generateRootDSE();
            }
            if (dn.equals(this.subschemaSubentryDN)) {
                return this.subschemaSubentryRef.get();
            }
            Entry e = this.entryMap.get(dn);
            if (e == null) {
                return null;
            }
            return new ReadOnlyEntry(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReadOnlyEntry> search(String baseDN, SearchScope scope, Filter filter) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            ArrayList<ReadOnlyEntry> entryList;
            ReadOnlyEntry baseEntry;
            DN parsedDN;
            Schema schema = this.schemaRef.get();
            try {
                parsedDN = new DN(baseDN, schema);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, ListenerMessages.ERR_MEM_HANDLER_SEARCH_MALFORMED_BASE.get(baseDN, le.getMessage()), le);
            }
            if (parsedDN.isNullDN()) {
                baseEntry = this.generateRootDSE();
            } else if (parsedDN.equals(this.subschemaSubentryDN)) {
                baseEntry = this.subschemaSubentryRef.get();
            } else {
                Entry e = this.entryMap.get(parsedDN);
                if (e == null) {
                    throw new LDAPException(ResultCode.NO_SUCH_OBJECT, ListenerMessages.ERR_MEM_HANDLER_SEARCH_BASE_DOES_NOT_EXIST.get(baseDN), this.getMatchedDNString(parsedDN), null);
                }
                baseEntry = new ReadOnlyEntry(e);
            }
            if (scope == SearchScope.BASE) {
                entryList = new ArrayList<ReadOnlyEntry>(1);
                try {
                    if (filter.matchesEntry(baseEntry, schema)) {
                        entryList.add(baseEntry);
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
                return Collections.unmodifiableList(entryList);
            }
            if (scope == SearchScope.ONE && parsedDN.isNullDN()) {
                entryList = new ArrayList(this.baseDNs.size());
                try {
                    for (DN dn : this.baseDNs) {
                        Entry e = this.entryMap.get(dn);
                        if (e == null || !filter.matchesEntry(e, schema)) continue;
                        entryList.add(new ReadOnlyEntry(e));
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
                return Collections.unmodifiableList(entryList);
            }
            entryList = new ArrayList(10);
            for (Map.Entry<DN, ReadOnlyEntry> me : this.entryMap.entrySet()) {
                DN dn = me.getKey();
                if (!dn.matchesBaseAndScope(parsedDN, scope) || parsedDN.isNullDN() && dn.isDescendantOf(this.changeLogBaseDN, true)) continue;
                try {
                    Entry entry = me.getValue();
                    if (!filter.matchesEntry(entry, schema)) continue;
                    entryList.add(new ReadOnlyEntry(entry));
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            return Collections.unmodifiableList(entryList);
        }
    }

    private ReadOnlyEntry generateRootDSE() {
        String vendorVersion;
        ReadOnlyEntry rootDSEFromCfg = this.config.getRootDSEEntry();
        if (rootDSEFromCfg != null) {
            return rootDSEFromCfg;
        }
        Entry rootDSEEntry = new Entry(DN.NULL_DN, this.schemaRef.get());
        rootDSEEntry.addAttribute("objectClass", "top", "ds-root-dse");
        rootDSEEntry.addAttribute(new Attribute("supportedLDAPVersion", (MatchingRule)IntegerMatchingRule.getInstance(), "3"));
        String vendorName = this.config.getVendorName();
        if (vendorName != null) {
            rootDSEEntry.addAttribute("vendorName", vendorName);
        }
        if ((vendorVersion = this.config.getVendorVersion()) != null) {
            rootDSEEntry.addAttribute("vendorVersion", vendorVersion);
        }
        rootDSEEntry.addAttribute(new Attribute("subschemaSubentry", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), this.subschemaSubentryDN.toString()));
        rootDSEEntry.addAttribute(new Attribute("entryDN", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), ""));
        rootDSEEntry.addAttribute("entryUUID", UUID.randomUUID().toString());
        rootDSEEntry.addAttribute("supportedFeatures", "1.3.6.1.4.1.4203.1.5.1", "1.3.6.1.4.1.4203.1.5.2", "1.3.6.1.4.1.4203.1.5.3", "1.3.6.1.1.14");
        TreeSet<String> ctlSet = new TreeSet<String>();
        ctlSet.add("1.3.6.1.1.12");
        ctlSet.add("2.16.840.1.113730.3.4.16");
        ctlSet.add("1.3.6.1.1.22");
        ctlSet.add("2.16.840.1.113730.3.4.2");
        ctlSet.add("1.3.6.1.4.1.4203.1.10.2");
        ctlSet.add("1.2.840.113556.1.4.1413");
        ctlSet.add("1.3.6.1.1.13.2");
        ctlSet.add("1.3.6.1.1.13.1");
        ctlSet.add("2.16.840.1.113730.3.4.12");
        ctlSet.add("2.16.840.1.113730.3.4.18");
        ctlSet.add("1.2.840.113556.1.4.473");
        ctlSet.add("1.2.840.113556.1.4.319");
        ctlSet.add("1.3.6.1.4.1.7628.5.101.1");
        ctlSet.add("1.2.840.113556.1.4.805");
        ctlSet.add("1.3.6.1.1.21.2");
        ctlSet.add("2.16.840.1.113730.3.4.9");
        ctlSet.add("1.3.6.1.4.1.30221.2.5.5");
        String[] controlOIDs = new String[ctlSet.size()];
        rootDSEEntry.addAttribute("supportedControl", ctlSet.toArray(controlOIDs));
        if (!this.extendedRequestHandlers.isEmpty()) {
            String[] oidArray = new String[this.extendedRequestHandlers.size()];
            rootDSEEntry.addAttribute("supportedExtension", this.extendedRequestHandlers.keySet().toArray(oidArray));
            for (InMemoryListenerConfig c : this.config.getListenerConfigs()) {
                if (c.getStartTLSSocketFactory() == null) continue;
                rootDSEEntry.addAttribute("supportedExtension", "1.3.6.1.4.1.1466.20037");
                break;
            }
        }
        if (!this.saslBindHandlers.isEmpty()) {
            String[] mechanismArray = new String[this.saslBindHandlers.size()];
            rootDSEEntry.addAttribute("supportedSASLMechanisms", this.saslBindHandlers.keySet().toArray(mechanismArray));
        }
        int pos = 0;
        String[] baseDNStrings = new String[this.baseDNs.size()];
        for (DN baseDN : this.baseDNs) {
            baseDNStrings[pos++] = baseDN.toString();
        }
        rootDSEEntry.addAttribute(new Attribute("namingContexts", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), baseDNStrings));
        if (this.maxChangelogEntries > 0) {
            rootDSEEntry.addAttribute(new Attribute("changeLog", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), this.changeLogBaseDN.toString()));
            rootDSEEntry.addAttribute(new Attribute("firstChangeNumber", (MatchingRule)IntegerMatchingRule.getInstance(), this.firstChangeNumber.toString()));
            rootDSEEntry.addAttribute(new Attribute("lastChangeNumber", (MatchingRule)IntegerMatchingRule.getInstance(), this.lastChangeNumber.toString()));
        }
        return new ReadOnlyEntry(rootDSEEntry);
    }

    private static ReadOnlyEntry generateSubschemaSubentry(Schema schema) {
        Entry e;
        if (schema == null) {
            e = new Entry("cn=schema", schema);
            e.addAttribute("objectClass", "namedObject", "ldapSubEntry", "subschema");
            e.addAttribute("cn", "schema");
        } else {
            e = schema.getSchemaEntry().duplicate();
        }
        try {
            e.addAttribute("entryDN", DN.normalize(e.getDN(), schema));
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            e.setAttribute("entryDN", StaticUtils.toLowerCase(e.getDN()));
        }
        e.addAttribute("entryUUID", UUID.randomUUID().toString());
        return new ReadOnlyEntry(e);
    }

    private Map<String, List<List<String>>> processRequestedAttributes(List<String> attrList, AtomicBoolean allUserAttrs, AtomicBoolean allOpAttrs) {
        if (attrList.isEmpty()) {
            allUserAttrs.set(true);
            return Collections.emptyMap();
        }
        Schema schema = this.schemaRef.get();
        HashMap<String, List<List<String>>> m = new HashMap<String, List<List<String>>>(attrList.size() * 2);
        for (String s : attrList) {
            AttributeTypeDefinition at2;
            if (s.equals("*")) {
                allUserAttrs.set(true);
                continue;
            }
            if (s.equals("+")) {
                allOpAttrs.set(true);
                continue;
            }
            if (s.startsWith("@")) {
                String ocName;
                ObjectClassDefinition oc;
                if (schema == null || (oc = schema.getObjectClass(ocName = s.substring(1))) == null) continue;
                for (AttributeTypeDefinition at2 : oc.getRequiredAttributes(schema, true)) {
                    this.addAttributeOIDAndNames(at2, m, Collections.emptyList());
                }
                for (AttributeTypeDefinition at2 : oc.getOptionalAttributes(schema, true)) {
                    this.addAttributeOIDAndNames(at2, m, Collections.emptyList());
                }
                continue;
            }
            ObjectPair<String, List<String>> nameWithOptions = InMemoryRequestHandler.getNameWithOptions(s);
            if (nameWithOptions == null) continue;
            String name = nameWithOptions.getFirst();
            List<String> options = nameWithOptions.getSecond();
            if (schema == null) {
                List<List<String>> optionLists = m.get(name);
                if (optionLists == null) {
                    optionLists = new ArrayList<List<String>>(1);
                    m.put(name, optionLists);
                }
                optionLists.add(options);
                continue;
            }
            at2 = schema.getAttributeType(name);
            if (at2 == null) {
                List<List<String>> optionLists = m.get(name);
                if (optionLists == null) {
                    optionLists = new ArrayList<List<String>>(1);
                    m.put(name, optionLists);
                }
                optionLists.add(options);
                continue;
            }
            this.addAttributeOIDAndNames(at2, m, options);
        }
        return m;
    }

    private static ObjectPair<String, List<String>> getNameWithOptions(String s) {
        if (!Attribute.nameIsValid(s, true)) {
            return null;
        }
        String l = StaticUtils.toLowerCase(s);
        int semicolonPos = l.indexOf(59);
        if (semicolonPos < 0) {
            return new ObjectPair<String, List<String>>(l, Collections.emptyList());
        }
        String name = l.substring(0, semicolonPos);
        ArrayList<String> optionList = new ArrayList<String>(1);
        while (true) {
            int nextSemicolonPos;
            if ((nextSemicolonPos = l.indexOf(59, semicolonPos + 1)) < 0) break;
            optionList.add(l.substring(semicolonPos + 1, nextSemicolonPos));
            semicolonPos = nextSemicolonPos;
        }
        optionList.add(l.substring(semicolonPos + 1));
        return new ObjectPair<String, List<String>>(name, optionList);
    }

    private void addAttributeOIDAndNames(AttributeTypeDefinition d, Map<String, List<List<String>>> m, List<String> o) {
        if (d == null) {
            return;
        }
        String lowerOID = StaticUtils.toLowerCase(d.getOID());
        if (lowerOID != null) {
            List<List<String>> l = m.get(lowerOID);
            if (l == null) {
                l = new ArrayList<List<String>>(1);
                m.put(lowerOID, l);
            }
            l.add(o);
        }
        for (String name : d.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<List<String>> l = m.get(lowerName);
            if (l == null) {
                l = new ArrayList<List<String>>(1);
                m.put(lowerName, l);
            }
            l.add(o);
        }
        Schema schema = this.schemaRef.get();
        if (schema != null) {
            for (AttributeTypeDefinition subordinateType : schema.getSubordinateAttributeTypes(d)) {
                this.addAttributeOIDAndNames(subordinateType, m, o);
            }
        }
    }

    private void processSearchEntry(Entry entry, boolean includeSubEntries, boolean includeNonSubEntries, boolean includeChangeLog, boolean hasManageDsaIT, List<Entry> entryList, List<SearchResultReference> referenceList) {
        if (entry.hasObjectClass("ldapSubEntry") || entry.hasObjectClass("inheritableLDAPSubEntry") ? !includeSubEntries : !includeNonSubEntries) {
            return;
        }
        try {
            if (!includeChangeLog && entry.getParsedDN().isDescendantOf(this.changeLogBaseDN, true)) {
                return;
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        if (!hasManageDsaIT && entry.hasObjectClass("referral") && entry.hasAttribute("ref")) {
            referenceList.add(new SearchResultReference(entry.getAttributeValues("ref"), NO_CONTROLS));
            return;
        }
        entryList.add(entry);
    }

    private Entry trimForRequestedAttributes(Entry entry, boolean allUserAttrs, boolean allOpAttrs, Map<String, List<List<String>>> returnAttrs) {
        Schema schema = this.schemaRef.get();
        if (allUserAttrs && (allOpAttrs || schema == null)) {
            return entry;
        }
        Entry copy = new Entry(entry.getDN(), schema);
        block0: for (Attribute a : entry.getAttributes()) {
            AttributeTypeDefinition at;
            ObjectPair<String, List<String>> nameWithOptions = InMemoryRequestHandler.getNameWithOptions(a.getName());
            String name = nameWithOptions.getFirst();
            List<String> options = nameWithOptions.getSecond();
            if (schema != null && (at = schema.getAttributeType(name)) != null && at.isOperational()) {
                if (allOpAttrs) {
                    copy.addAttribute(a);
                    continue;
                }
                List<List<String>> optionLists = returnAttrs.get(name);
                if (optionLists == null) continue;
                for (List<String> optionList : optionLists) {
                    boolean matchAll = true;
                    for (String option : optionList) {
                        if (options.contains(option)) continue;
                        matchAll = false;
                        break;
                    }
                    if (!matchAll) continue;
                    copy.addAttribute(a);
                    continue block0;
                }
                continue;
            }
            if (allUserAttrs) {
                copy.addAttribute(a);
                continue;
            }
            List<List<String>> optionLists = returnAttrs.get(name);
            if (optionLists == null) continue;
            for (List<String> optionList : optionLists) {
                boolean matchAll = true;
                for (String option : optionList) {
                    if (options.contains(option)) continue;
                    matchAll = false;
                    break;
                }
                if (!matchAll) continue;
                copy.addAttribute(a);
                continue block0;
            }
        }
        return copy;
    }

    private String getMatchedDNString(DN dn) {
        for (DN parentDN = dn.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
            if (!this.entryMap.containsKey(parentDN)) continue;
            return parentDN.toString();
        }
        return null;
    }

    private static String[] stringListToArray(List<String> l) {
        if (l == null) {
            return null;
        }
        String[] a = new String[l.size()];
        return l.toArray(a);
    }

    private void addChangeLogEntry(AddRequestProtocolOp addRequest, DN authzDN) {
        if (this.maxChangelogEntries <= 0) {
            return;
        }
        long changeNumber = this.lastChangeNumber.incrementAndGet();
        LDIFAddChangeRecord changeRecord = new LDIFAddChangeRecord(addRequest.getDN(), addRequest.getAttributes());
        try {
            this.addChangeLogEntry(ChangeLogEntry.constructChangeLogEntry(changeNumber, changeRecord), authzDN);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
        }
    }

    private void addDeleteChangeLogEntry(Entry e, DN authzDN) {
        if (this.maxChangelogEntries <= 0) {
            return;
        }
        long changeNumber = this.lastChangeNumber.incrementAndGet();
        LDIFDeleteChangeRecord changeRecord = new LDIFDeleteChangeRecord(e.getDN());
        try {
            ChangeLogEntry cle = ChangeLogEntry.constructChangeLogEntry(changeNumber, changeRecord);
            StringBuilder deletedEntryAttrsBuffer = new StringBuilder();
            String[] ldifLines = e.toLDIF(0);
            for (int i = 1; i < ldifLines.length; ++i) {
                deletedEntryAttrsBuffer.append(ldifLines[i]);
                deletedEntryAttrsBuffer.append(StaticUtils.EOL);
            }
            Entry copy = cle.duplicate();
            copy.addAttribute("deletedEntryAttrs", deletedEntryAttrsBuffer.toString());
            this.addChangeLogEntry(new ChangeLogEntry(copy), authzDN);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
        }
    }

    private void addChangeLogEntry(ModifyRequestProtocolOp modifyRequest, DN authzDN) {
        if (this.maxChangelogEntries <= 0) {
            return;
        }
        long changeNumber = this.lastChangeNumber.incrementAndGet();
        LDIFModifyChangeRecord changeRecord = new LDIFModifyChangeRecord(modifyRequest.getDN(), modifyRequest.getModifications());
        try {
            this.addChangeLogEntry(ChangeLogEntry.constructChangeLogEntry(changeNumber, changeRecord), authzDN);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
        }
    }

    private void addChangeLogEntry(ModifyDNRequestProtocolOp modifyDNRequest, DN authzDN) {
        if (this.maxChangelogEntries <= 0) {
            return;
        }
        long changeNumber = this.lastChangeNumber.incrementAndGet();
        LDIFModifyDNChangeRecord changeRecord = new LDIFModifyDNChangeRecord(modifyDNRequest.getDN(), modifyDNRequest.getNewRDN(), modifyDNRequest.deleteOldRDN(), modifyDNRequest.getNewSuperiorDN());
        try {
            this.addChangeLogEntry(ChangeLogEntry.constructChangeLogEntry(changeNumber, changeRecord), authzDN);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
        }
    }

    private void addChangeLogEntry(ChangeLogEntry e, DN authzDN) {
        long changeNumber = e.getChangeNumber();
        Schema schema = this.schemaRef.get();
        DN dn = new DN(new RDN("changeNumber", String.valueOf(changeNumber), schema), this.changeLogBaseDN);
        Entry entry = e.duplicate();
        if (this.generateOperationalAttributes) {
            Date d = new Date();
            entry.addAttribute(new Attribute("entryDN", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), dn.toNormalizedString()));
            entry.addAttribute(new Attribute("entryUUID", UUID.randomUUID().toString()));
            entry.addAttribute(new Attribute("subschemaSubentry", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), this.subschemaSubentryDN.toString()));
            entry.addAttribute(new Attribute("creatorsName", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), authzDN.toString()));
            entry.addAttribute(new Attribute("createTimestamp", (MatchingRule)GeneralizedTimeMatchingRule.getInstance(), StaticUtils.encodeGeneralizedTime(d)));
            entry.addAttribute(new Attribute("modifiersName", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), authzDN.toString()));
            entry.addAttribute(new Attribute("modifyTimestamp", (MatchingRule)GeneralizedTimeMatchingRule.getInstance(), StaticUtils.encodeGeneralizedTime(d)));
        }
        this.entryMap.put(dn, new ReadOnlyEntry(entry));
        this.indexAdd(entry);
        long firstNumber = this.firstChangeNumber.get();
        if (changeNumber == 1L) {
            this.firstChangeNumber.set(1L);
        } else {
            long numChangeLogEntries = changeNumber - firstNumber + 1L;
            if (numChangeLogEntries > (long)this.maxChangelogEntries) {
                this.firstChangeNumber.incrementAndGet();
                Entry deletedEntry = this.entryMap.remove(new DN(new RDN("changeNumber", String.valueOf(firstNumber), schema), this.changeLogBaseDN));
                this.indexDelete(deletedEntry);
            }
        }
    }

    private DN handleProxiedAuthControl(Map<String, Control> m) throws LDAPException {
        ProxiedAuthorizationV1RequestControl p1 = (ProxiedAuthorizationV1RequestControl)m.get("2.16.840.1.113730.3.4.12");
        if (p1 != null) {
            DN authzDN = new DN(p1.getProxyDN(), this.schemaRef.get());
            if (authzDN.isNullDN() || this.entryMap.containsKey(authzDN) || this.additionalBindCredentials.containsKey(authzDN)) {
                return authzDN;
            }
            throw new LDAPException(ResultCode.AUTHORIZATION_DENIED, ListenerMessages.ERR_MEM_HANDLER_NO_SUCH_IDENTITY.get("dn:" + authzDN.toString()));
        }
        ProxiedAuthorizationV2RequestControl p2 = (ProxiedAuthorizationV2RequestControl)m.get("2.16.840.1.113730.3.4.18");
        if (p2 != null) {
            return this.getDNForAuthzID(p2.getAuthorizationID());
        }
        return this.authenticatedDN;
    }

    public DN getDNForAuthzID(String authzID) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            String lowerAuthzID = StaticUtils.toLowerCase(authzID);
            if (lowerAuthzID.startsWith("dn:")) {
                if (lowerAuthzID.equals("dn:")) {
                    return DN.NULL_DN;
                }
                DN dn = new DN(authzID.substring(3), this.schemaRef.get());
                if (this.entryMap.containsKey(dn) || this.additionalBindCredentials.containsKey(dn)) {
                    return dn;
                }
                throw new LDAPException(ResultCode.AUTHORIZATION_DENIED, ListenerMessages.ERR_MEM_HANDLER_NO_SUCH_IDENTITY.get(authzID));
            }
            if (lowerAuthzID.startsWith("u:")) {
                Filter f = Filter.createEqualityFilter("uid", authzID.substring(2));
                List<ReadOnlyEntry> entryList = this.search("", SearchScope.SUB, f);
                if (entryList.size() == 1) {
                    return entryList.get(0).getParsedDN();
                }
                throw new LDAPException(ResultCode.AUTHORIZATION_DENIED, ListenerMessages.ERR_MEM_HANDLER_NO_SUCH_IDENTITY.get(authzID));
            }
            throw new LDAPException(ResultCode.AUTHORIZATION_DENIED, ListenerMessages.ERR_MEM_HANDLER_NO_SUCH_IDENTITY.get(authzID));
        }
    }

    private static void handleAssertionRequestControl(Map<String, Control> m, Entry e) throws LDAPException {
        AssertionRequestControl c = (AssertionRequestControl)m.get("1.3.6.1.1.12");
        if (c == null) {
            return;
        }
        try {
            if (c.getFilter().matchesEntry(e)) {
                return;
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
        }
        throw new LDAPException(ResultCode.ASSERTION_FAILED, ListenerMessages.ERR_MEM_HANDLER_ASSERTION_CONTROL_NOT_SATISFIED.get());
    }

    private PreReadResponseControl handlePreReadControl(Map<String, Control> m, Entry e) {
        PreReadRequestControl c = (PreReadRequestControl)m.get("1.3.6.1.1.13.1");
        if (c == null) {
            return null;
        }
        AtomicBoolean allUserAttrs = new AtomicBoolean(false);
        AtomicBoolean allOpAttrs = new AtomicBoolean(false);
        Map<String, List<List<String>>> returnAttrs = this.processRequestedAttributes(Arrays.asList(c.getAttributes()), allUserAttrs, allOpAttrs);
        Entry trimmedEntry = this.trimForRequestedAttributes(e, allUserAttrs.get(), allOpAttrs.get(), returnAttrs);
        return new PreReadResponseControl(new ReadOnlyEntry(trimmedEntry));
    }

    private PostReadResponseControl handlePostReadControl(Map<String, Control> m, Entry e) {
        PostReadRequestControl c = (PostReadRequestControl)m.get("1.3.6.1.1.13.2");
        if (c == null) {
            return null;
        }
        AtomicBoolean allUserAttrs = new AtomicBoolean(false);
        AtomicBoolean allOpAttrs = new AtomicBoolean(false);
        Map<String, List<List<String>>> returnAttrs = this.processRequestedAttributes(Arrays.asList(c.getAttributes()), allUserAttrs, allOpAttrs);
        Entry trimmedEntry = this.trimForRequestedAttributes(e, allUserAttrs.get(), allOpAttrs.get(), returnAttrs);
        return new PostReadResponseControl(new ReadOnlyEntry(trimmedEntry));
    }

    private Entry findNearestReferral(DN dn) {
        Entry e;
        DN d = dn;
        while ((e = (Entry)this.entryMap.get(d)) == null) {
            if ((d = d.getParent()) != null) continue;
            return null;
        }
        if (e.hasObjectClass("referral")) {
            return e;
        }
        return null;
    }

    private static List<String> getReferralURLs(DN targetDN, Entry referralEntry) {
        RDN[] retainRDNs;
        String[] refs = referralEntry.getAttributeValues("ref");
        if (refs == null) {
            return null;
        }
        try {
            DN parsedEntryDN = referralEntry.getParsedDN();
            if (targetDN.equals(parsedEntryDN) || !targetDN.isDescendantOf(parsedEntryDN, true)) {
                return Arrays.asList(refs);
            }
            RDN[] targetRDNs = targetDN.getRDNs();
            RDN[] refEntryRDNs = referralEntry.getParsedDN().getRDNs();
            retainRDNs = new RDN[targetRDNs.length - refEntryRDNs.length];
            System.arraycopy(targetRDNs, 0, retainRDNs, 0, retainRDNs.length);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return Arrays.asList(refs);
        }
        ArrayList<String> refList = new ArrayList<String>(refs.length);
        for (String ref : refs) {
            try {
                LDAPURL url = new LDAPURL(ref);
                RDN[] refRDNs = url.getBaseDN().getRDNs();
                RDN[] newRefRDNs = new RDN[retainRDNs.length + refRDNs.length];
                System.arraycopy(retainRDNs, 0, newRefRDNs, 0, retainRDNs.length);
                System.arraycopy(refRDNs, 0, newRefRDNs, retainRDNs.length, refRDNs.length);
                DN newBaseDN = new DN(newRefRDNs);
                LDAPURL newURL = new LDAPURL(url.getScheme(), url.getHost(), url.getPort(), newBaseDN, null, null, null);
                refList.add(newURL.toString());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                refList.add(ref);
            }
        }
        return refList;
    }

    public boolean entryExists(String dn) throws LDAPException {
        return this.getEntry(dn) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryExists(String dn, String filter) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            ReadOnlyEntry e = this.getEntry(dn);
            if (e == null) {
                return false;
            }
            Filter f = Filter.create(filter);
            try {
                return f.matchesEntry(e, this.schemaRef.get());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryExists(Entry entry) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            ReadOnlyEntry e = this.getEntry(entry.getDN());
            if (e == null) {
                return false;
            }
            for (Attribute a : entry.getAttributes()) {
                for (byte[] value : a.getValueByteArrays()) {
                    if (e.hasAttributeValue(a.getName(), value)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public void assertEntryExists(String dn) throws LDAPException, AssertionError {
        ReadOnlyEntry e = this.getEntry(dn);
        if (e == null) {
            throw new AssertionError((Object)ListenerMessages.ERR_MEM_HANDLER_TEST_ENTRY_MISSING.get(dn));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertEntryExists(String dn, String filter) throws LDAPException, AssertionError {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            ReadOnlyEntry e = this.getEntry(dn);
            if (e == null) {
                throw new AssertionError((Object)ListenerMessages.ERR_MEM_HANDLER_TEST_ENTRY_MISSING.get(dn));
            }
            Filter f = Filter.create(filter);
            try {
                if (!f.matchesEntry(e, this.schemaRef.get())) {
                    throw new AssertionError((Object)ListenerMessages.ERR_MEM_HANDLER_TEST_ENTRY_DOES_NOT_MATCH_FILTER.get(dn, filter));
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new AssertionError((Object)ListenerMessages.ERR_MEM_HANDLER_TEST_ENTRY_DOES_NOT_MATCH_FILTER.get(dn, filter));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertEntryExists(Entry entry) throws LDAPException, AssertionError {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            ReadOnlyEntry e = this.getEntry(entry.getDN());
            if (e == null) {
                throw new AssertionError((Object)ListenerMessages.ERR_MEM_HANDLER_TEST_ENTRY_MISSING.get(entry.getDN()));
            }
            Collection<Attribute> attrs = entry.getAttributes();
            ArrayList<String> messages = new ArrayList<String>(attrs.size());
            Schema schema = this.schemaRef.get();
            for (Attribute a : entry.getAttributes()) {
                Filter presFilter = Filter.createPresenceFilter(a.getName());
                if (!presFilter.matchesEntry(e, schema)) {
                    messages.add(ListenerMessages.ERR_MEM_HANDLER_TEST_ATTR_MISSING.get(entry.getDN(), a.getName()));
                    continue;
                }
                for (byte[] value : a.getValueByteArrays()) {
                    Filter eqFilter = Filter.createEqualityFilter(a.getName(), value);
                    if (eqFilter.matchesEntry(e, schema)) continue;
                    messages.add(ListenerMessages.ERR_MEM_HANDLER_TEST_VALUE_MISSING.get(entry.getDN(), a.getName(), StaticUtils.toUTF8String(value)));
                }
            }
            if (!messages.isEmpty()) {
                throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMissingEntryDNs(Collection<String> dns) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            ArrayList<String> missingDNs = new ArrayList<String>(dns.size());
            for (String dn : dns) {
                ReadOnlyEntry e = this.getEntry(dn);
                if (e != null) continue;
                missingDNs.add(dn);
            }
            return missingDNs;
        }
    }

    public void assertEntriesExist(Collection<String> dns) throws LDAPException, AssertionError {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            List<String> missingDNs = this.getMissingEntryDNs(dns);
            if (missingDNs.isEmpty()) {
                return;
            }
            ArrayList<String> messages = new ArrayList<String>(missingDNs.size());
            for (String dn : missingDNs) {
                messages.add(ListenerMessages.ERR_MEM_HANDLER_TEST_ENTRY_MISSING.get(dn));
            }
            throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMissingAttributeNames(String dn, Collection<String> attributeNames) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            ReadOnlyEntry e = this.getEntry(dn);
            if (e == null) {
                return null;
            }
            Schema schema = this.schemaRef.get();
            ArrayList<String> missingAttrs = new ArrayList<String>(attributeNames.size());
            for (String attr : attributeNames) {
                Filter f = Filter.createPresenceFilter(attr);
                if (f.matchesEntry(e, schema)) continue;
                missingAttrs.add(attr);
            }
            return missingAttrs;
        }
    }

    public void assertAttributeExists(String dn, Collection<String> attributeNames) throws LDAPException, AssertionError {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            List<String> missingAttrs = this.getMissingAttributeNames(dn, attributeNames);
            if (missingAttrs == null) {
                throw new AssertionError((Object)ListenerMessages.ERR_MEM_HANDLER_TEST_ENTRY_MISSING.get(dn));
            }
            if (missingAttrs.isEmpty()) {
                return;
            }
            ArrayList<String> messages = new ArrayList<String>(missingAttrs.size());
            for (String attr : missingAttrs) {
                messages.add(ListenerMessages.ERR_MEM_HANDLER_TEST_ATTR_MISSING.get(dn, attr));
            }
            throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMissingAttributeValues(String dn, String attributeName, Collection<String> attributeValues) throws LDAPException {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            ReadOnlyEntry e = this.getEntry(dn);
            if (e == null) {
                return null;
            }
            Schema schema = this.schemaRef.get();
            ArrayList<String> missingValues = new ArrayList<String>(attributeValues.size());
            for (String value : attributeValues) {
                Filter f = Filter.createEqualityFilter(attributeName, value);
                if (f.matchesEntry(e, schema)) continue;
                missingValues.add(value);
            }
            return missingValues;
        }
    }

    public void assertValueExists(String dn, String attributeName, Collection<String> attributeValues) throws LDAPException, AssertionError {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            List<String> missingValues = this.getMissingAttributeValues(dn, attributeName, attributeValues);
            if (missingValues == null) {
                throw new AssertionError((Object)ListenerMessages.ERR_MEM_HANDLER_TEST_ENTRY_MISSING.get(dn));
            }
            if (missingValues.isEmpty()) {
                return;
            }
            ReadOnlyEntry e = this.getEntry(dn);
            Filter f = Filter.createPresenceFilter(attributeName);
            if (!f.matchesEntry(e, this.schemaRef.get())) {
                throw new AssertionError((Object)ListenerMessages.ERR_MEM_HANDLER_TEST_ATTR_MISSING.get(dn, attributeName));
            }
            ArrayList<String> messages = new ArrayList<String>(missingValues.size());
            for (String value : missingValues) {
                messages.add(ListenerMessages.ERR_MEM_HANDLER_TEST_VALUE_MISSING.get(dn, attributeName, value));
            }
            throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
        }
    }

    public void assertEntryMissing(String dn) throws LDAPException, AssertionError {
        ReadOnlyEntry e = this.getEntry(dn);
        if (e != null) {
            throw new AssertionError((Object)ListenerMessages.ERR_MEM_HANDLER_TEST_ENTRY_EXISTS.get(dn));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertAttributeMissing(String dn, Collection<String> attributeNames) throws LDAPException, AssertionError {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            ReadOnlyEntry e = this.getEntry(dn);
            if (e == null) {
                throw new AssertionError((Object)ListenerMessages.ERR_MEM_HANDLER_TEST_ENTRY_MISSING.get(dn));
            }
            Schema schema = this.schemaRef.get();
            ArrayList<String> messages = new ArrayList<String>(attributeNames.size());
            for (String name : attributeNames) {
                Filter f = Filter.createPresenceFilter(name);
                if (!f.matchesEntry(e, schema)) continue;
                messages.add(ListenerMessages.ERR_MEM_HANDLER_TEST_ATTR_EXISTS.get(dn, name));
            }
            if (!messages.isEmpty()) {
                throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertValueMissing(String dn, String attributeName, Collection<String> attributeValues) throws LDAPException, AssertionError {
        Map<DN, ReadOnlyEntry> map = this.entryMap;
        synchronized (map) {
            ReadOnlyEntry e = this.getEntry(dn);
            if (e == null) {
                throw new AssertionError((Object)ListenerMessages.ERR_MEM_HANDLER_TEST_ENTRY_MISSING.get(dn));
            }
            Schema schema = this.schemaRef.get();
            ArrayList<String> messages = new ArrayList<String>(attributeValues.size());
            for (String value : attributeValues) {
                Filter f = Filter.createEqualityFilter(attributeName, value);
                if (!f.matchesEntry(e, schema)) continue;
                messages.add(ListenerMessages.ERR_MEM_HANDLER_TEST_VALUE_EXISTS.get(dn, attributeName, value));
            }
            if (!messages.isEmpty()) {
                throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
            }
        }
    }
}

