/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.unboundidds.controls.SoftDeleteRequestControl;
import com.unboundid.ldap.sdk.unboundidds.logs.AuditLogException;
import com.unboundid.ldap.sdk.unboundidds.logs.AuditLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessages;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AddAuditLogMessage
extends AuditLogMessage {
    private static final long serialVersionUID = -4103749134439291911L;
    private final Boolean isUndelete;
    private final LDIFAddChangeRecord addChangeRecord;
    private final ReadOnlyEntry undeleteRequestEntry;

    public AddAuditLogMessage(String ... logMessageLines) throws AuditLogException {
        this(StaticUtils.toList(logMessageLines), logMessageLines);
    }

    public AddAuditLogMessage(List<String> logMessageLines) throws AuditLogException {
        this(logMessageLines, StaticUtils.toArray(logMessageLines, String.class));
    }

    private AddAuditLogMessage(List<String> logMessageLineList, String[] logMessageLineArray) throws AuditLogException {
        super(logMessageLineList);
        try {
            LDIFChangeRecord changeRecord = LDIFReader.decodeChangeRecord(logMessageLineArray);
            if (!(changeRecord instanceof LDIFAddChangeRecord)) {
                throw new AuditLogException(logMessageLineList, LogMessages.ERR_ADD_AUDIT_LOG_MESSAGE_CHANGE_TYPE_NOT_ADD.get(changeRecord.getChangeType().getName(), ChangeType.ADD.getName()));
            }
            this.addChangeRecord = (LDIFAddChangeRecord)changeRecord;
        }
        catch (LDIFException e) {
            Debug.debugException(e);
            throw new AuditLogException(logMessageLineList, LogMessages.ERR_ADD_AUDIT_LOG_MESSAGE_LINES_NOT_CHANGE_RECORD.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.isUndelete = AddAuditLogMessage.getNamedValueAsBoolean("isUndelete", this.getHeaderNamedValues());
        this.undeleteRequestEntry = AddAuditLogMessage.decodeCommentedEntry("Undelete request entry", logMessageLineList, null);
    }

    AddAuditLogMessage(List<String> logMessageLines, LDIFAddChangeRecord addChangeRecord) throws AuditLogException {
        super(logMessageLines);
        this.addChangeRecord = addChangeRecord;
        this.isUndelete = AddAuditLogMessage.getNamedValueAsBoolean("isUndelete", this.getHeaderNamedValues());
        this.undeleteRequestEntry = AddAuditLogMessage.decodeCommentedEntry("Undelete request entry", logMessageLines, null);
    }

    @Override
    public String getDN() {
        return this.addChangeRecord.getDN();
    }

    public ReadOnlyEntry getEntry() {
        return new ReadOnlyEntry(this.addChangeRecord.getEntryToAdd());
    }

    public Boolean getIsUndelete() {
        return this.isUndelete;
    }

    public ReadOnlyEntry getUndeleteRequestEntry() {
        return this.undeleteRequestEntry;
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.ADD;
    }

    @Override
    public LDIFAddChangeRecord getChangeRecord() {
        return this.addChangeRecord;
    }

    @Override
    public boolean isRevertible() {
        return true;
    }

    @Override
    public List<LDIFChangeRecord> getRevertChangeRecords() {
        if (this.isUndelete != null && this.isUndelete.booleanValue()) {
            return Collections.singletonList(new LDIFDeleteChangeRecord(SoftDeleteRequestControl.createSoftDeleteRequest(this.addChangeRecord.getDN(), false, true)));
        }
        return Collections.singletonList(new LDIFDeleteChangeRecord(this.addChangeRecord.getDN()));
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.getUncommentedHeaderLine());
        buffer.append("; changeType=add; dn=\"");
        buffer.append(this.addChangeRecord.getDN());
        buffer.append('\"');
    }
}

