﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/application-insights/model/DeleteLogPatternRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::ApplicationInsights::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteLogPatternRequest::SerializePayload() const {
  JsonValue payload;

  if (m_resourceGroupNameHasBeenSet) {
    payload.WithString("ResourceGroupName", m_resourceGroupName);
  }

  if (m_patternSetNameHasBeenSet) {
    payload.WithString("PatternSetName", m_patternSetName);
  }

  if (m_patternNameHasBeenSet) {
    payload.WithString("PatternName", m_patternName);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteLogPatternRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "EC2WindowsBarleyService.DeleteLogPattern"));
  return headers;
}
