﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codebuild/CodeBuild_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeBuild {
namespace Model {
class ListProjectsResult {
 public:
  AWS_CODEBUILD_API ListProjectsResult() = default;
  AWS_CODEBUILD_API ListProjectsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEBUILD_API ListProjectsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>If there are more than 100 items in the list, only the first 100 items are
   * returned, along with a unique string called a <i>nextToken</i>. To get the next
   * batch of items in the list, call this operation again, adding the next token to
   * the call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListProjectsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of build project names, with each build project name representing a
   * single build project.</p>
   */
  inline const Aws::Vector<Aws::String>& GetProjects() const { return m_projects; }
  template <typename ProjectsT = Aws::Vector<Aws::String>>
  void SetProjects(ProjectsT&& value) {
    m_projectsHasBeenSet = true;
    m_projects = std::forward<ProjectsT>(value);
  }
  template <typename ProjectsT = Aws::Vector<Aws::String>>
  ListProjectsResult& WithProjects(ProjectsT&& value) {
    SetProjects(std::forward<ProjectsT>(value));
    return *this;
  }
  template <typename ProjectsT = Aws::String>
  ListProjectsResult& AddProjects(ProjectsT&& value) {
    m_projectsHasBeenSet = true;
    m_projects.emplace_back(std::forward<ProjectsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListProjectsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::Vector<Aws::String> m_projects;
  bool m_projectsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeBuild
}  // namespace Aws
