﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/comprehend/Comprehend_EXPORTS.h>
#include <aws/comprehend/model/KeyPhrasesDetectionJobProperties.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Comprehend {
namespace Model {
class ListKeyPhrasesDetectionJobsResult {
 public:
  AWS_COMPREHEND_API ListKeyPhrasesDetectionJobsResult() = default;
  AWS_COMPREHEND_API ListKeyPhrasesDetectionJobsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_COMPREHEND_API ListKeyPhrasesDetectionJobsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list containing the properties of each job that is returned.</p>
   */
  inline const Aws::Vector<KeyPhrasesDetectionJobProperties>& GetKeyPhrasesDetectionJobPropertiesList() const {
    return m_keyPhrasesDetectionJobPropertiesList;
  }
  template <typename KeyPhrasesDetectionJobPropertiesListT = Aws::Vector<KeyPhrasesDetectionJobProperties>>
  void SetKeyPhrasesDetectionJobPropertiesList(KeyPhrasesDetectionJobPropertiesListT&& value) {
    m_keyPhrasesDetectionJobPropertiesListHasBeenSet = true;
    m_keyPhrasesDetectionJobPropertiesList = std::forward<KeyPhrasesDetectionJobPropertiesListT>(value);
  }
  template <typename KeyPhrasesDetectionJobPropertiesListT = Aws::Vector<KeyPhrasesDetectionJobProperties>>
  ListKeyPhrasesDetectionJobsResult& WithKeyPhrasesDetectionJobPropertiesList(KeyPhrasesDetectionJobPropertiesListT&& value) {
    SetKeyPhrasesDetectionJobPropertiesList(std::forward<KeyPhrasesDetectionJobPropertiesListT>(value));
    return *this;
  }
  template <typename KeyPhrasesDetectionJobPropertiesListT = KeyPhrasesDetectionJobProperties>
  ListKeyPhrasesDetectionJobsResult& AddKeyPhrasesDetectionJobPropertiesList(KeyPhrasesDetectionJobPropertiesListT&& value) {
    m_keyPhrasesDetectionJobPropertiesListHasBeenSet = true;
    m_keyPhrasesDetectionJobPropertiesList.emplace_back(std::forward<KeyPhrasesDetectionJobPropertiesListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Identifies the next page of results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListKeyPhrasesDetectionJobsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListKeyPhrasesDetectionJobsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<KeyPhrasesDetectionJobProperties> m_keyPhrasesDetectionJobPropertiesList;
  bool m_keyPhrasesDetectionJobPropertiesListHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Comprehend
}  // namespace Aws
