﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/connect/model/EvaluationFormVersionStatus.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {

/**
 * <p>Summary information about an evaluation form.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/EvaluationFormVersionSummary">AWS
 * API Reference</a></p>
 */
class EvaluationFormVersionSummary {
 public:
  AWS_CONNECT_API EvaluationFormVersionSummary() = default;
  AWS_CONNECT_API EvaluationFormVersionSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API EvaluationFormVersionSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) for the evaluation form resource.</p>
   */
  inline const Aws::String& GetEvaluationFormArn() const { return m_evaluationFormArn; }
  inline bool EvaluationFormArnHasBeenSet() const { return m_evaluationFormArnHasBeenSet; }
  template <typename EvaluationFormArnT = Aws::String>
  void SetEvaluationFormArn(EvaluationFormArnT&& value) {
    m_evaluationFormArnHasBeenSet = true;
    m_evaluationFormArn = std::forward<EvaluationFormArnT>(value);
  }
  template <typename EvaluationFormArnT = Aws::String>
  EvaluationFormVersionSummary& WithEvaluationFormArn(EvaluationFormArnT&& value) {
    SetEvaluationFormArn(std::forward<EvaluationFormArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier for the evaluation form.</p>
   */
  inline const Aws::String& GetEvaluationFormId() const { return m_evaluationFormId; }
  inline bool EvaluationFormIdHasBeenSet() const { return m_evaluationFormIdHasBeenSet; }
  template <typename EvaluationFormIdT = Aws::String>
  void SetEvaluationFormId(EvaluationFormIdT&& value) {
    m_evaluationFormIdHasBeenSet = true;
    m_evaluationFormId = std::forward<EvaluationFormIdT>(value);
  }
  template <typename EvaluationFormIdT = Aws::String>
  EvaluationFormVersionSummary& WithEvaluationFormId(EvaluationFormIdT&& value) {
    SetEvaluationFormId(std::forward<EvaluationFormIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A version of the evaluation form.</p>
   */
  inline int GetEvaluationFormVersion() const { return m_evaluationFormVersion; }
  inline bool EvaluationFormVersionHasBeenSet() const { return m_evaluationFormVersionHasBeenSet; }
  inline void SetEvaluationFormVersion(int value) {
    m_evaluationFormVersionHasBeenSet = true;
    m_evaluationFormVersion = value;
  }
  inline EvaluationFormVersionSummary& WithEvaluationFormVersion(int value) {
    SetEvaluationFormVersion(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The flag indicating whether the evaluation form is locked for changes.</p>
   */
  inline bool GetLocked() const { return m_locked; }
  inline bool LockedHasBeenSet() const { return m_lockedHasBeenSet; }
  inline void SetLocked(bool value) {
    m_lockedHasBeenSet = true;
    m_locked = value;
  }
  inline EvaluationFormVersionSummary& WithLocked(bool value) {
    SetLocked(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the evaluation form.</p>
   */
  inline EvaluationFormVersionStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(EvaluationFormVersionStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline EvaluationFormVersionSummary& WithStatus(EvaluationFormVersionStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp for when the evaluation form was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTime() const { return m_createdTime; }
  inline bool CreatedTimeHasBeenSet() const { return m_createdTimeHasBeenSet; }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  void SetCreatedTime(CreatedTimeT&& value) {
    m_createdTimeHasBeenSet = true;
    m_createdTime = std::forward<CreatedTimeT>(value);
  }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  EvaluationFormVersionSummary& WithCreatedTime(CreatedTimeT&& value) {
    SetCreatedTime(std::forward<CreatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the user who created the evaluation
   * form.</p>
   */
  inline const Aws::String& GetCreatedBy() const { return m_createdBy; }
  inline bool CreatedByHasBeenSet() const { return m_createdByHasBeenSet; }
  template <typename CreatedByT = Aws::String>
  void SetCreatedBy(CreatedByT&& value) {
    m_createdByHasBeenSet = true;
    m_createdBy = std::forward<CreatedByT>(value);
  }
  template <typename CreatedByT = Aws::String>
  EvaluationFormVersionSummary& WithCreatedBy(CreatedByT&& value) {
    SetCreatedBy(std::forward<CreatedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp for when the evaluation form was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  EvaluationFormVersionSummary& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the user who last updated the evaluation
   * form.</p>
   */
  inline const Aws::String& GetLastModifiedBy() const { return m_lastModifiedBy; }
  inline bool LastModifiedByHasBeenSet() const { return m_lastModifiedByHasBeenSet; }
  template <typename LastModifiedByT = Aws::String>
  void SetLastModifiedBy(LastModifiedByT&& value) {
    m_lastModifiedByHasBeenSet = true;
    m_lastModifiedBy = std::forward<LastModifiedByT>(value);
  }
  template <typename LastModifiedByT = Aws::String>
  EvaluationFormVersionSummary& WithLastModifiedBy(LastModifiedByT&& value) {
    SetLastModifiedBy(std::forward<LastModifiedByT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_evaluationFormArn;
  bool m_evaluationFormArnHasBeenSet = false;

  Aws::String m_evaluationFormId;
  bool m_evaluationFormIdHasBeenSet = false;

  int m_evaluationFormVersion{0};
  bool m_evaluationFormVersionHasBeenSet = false;

  bool m_locked{false};
  bool m_lockedHasBeenSet = false;

  EvaluationFormVersionStatus m_status{EvaluationFormVersionStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::Utils::DateTime m_createdTime{};
  bool m_createdTimeHasBeenSet = false;

  Aws::String m_createdBy;
  bool m_createdByHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_lastModifiedTimeHasBeenSet = false;

  Aws::String m_lastModifiedBy;
  bool m_lastModifiedByHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
