/*
 * Decompiled with CFR 0.152.
 */
package com.imsl.math;

import com.imsl.math.Sfun;
import java.io.Serializable;

public class Complex
implements Serializable,
Cloneable {
    private double re;
    private double im;
    static final long serialVersionUID = -633126172485117692L;
    public static String suffix = "i";
    private static final long negZeroBits = Double.doubleToLongBits(-0.0);

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Complex(double d2) {
        this.re = d2;
        this.im = 0.0;
    }

    public Complex(double d2, double d3) {
        this.re = d2;
        this.im = d3;
    }

    public Complex(Complex complex) {
        this.re = complex.re;
        this.im = complex.im;
    }

    public static double abs(Complex complex) {
        double d2 = Math.abs(complex.re);
        double d3 = Math.abs(complex.im);
        if (Double.isInfinite(d2) || Double.isInfinite(d3)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d2 + d3 == 0.0) {
            return 0.0;
        }
        if (d2 > d3) {
            return d2 * Math.sqrt(1.0 + (d3 /= d2) * d3);
        }
        return d3 * Math.sqrt((d2 /= d3) * d2 + 1.0);
    }

    public static Complex acos(Complex complex) {
        Complex complex2 = new Complex();
        double d2 = Complex.abs(complex);
        if (Double.isInfinite(complex.re) && Double.isNaN(complex.im)) {
            complex2.re = Double.NaN;
            complex2.im = Double.NEGATIVE_INFINITY;
        } else if (Double.isInfinite(d2)) {
            complex2.re = Math.atan2(Math.abs(complex.im), complex.re);
            complex2.im = complex.im * Double.NEGATIVE_INFINITY;
        } else if (d2 == 0.0) {
            complex2.re = 1.5707963267948966;
            complex2.im = -complex.im;
        } else {
            complex2 = Complex.minus(1.5707963267948966, Complex.asin(complex));
        }
        return complex2;
    }

    public static Complex acosh(Complex complex) {
        Complex complex2 = Complex.acos(complex);
        double d2 = -complex2.im;
        complex2.im = complex2.re;
        complex2.re = d2;
        if (complex2.re < 0.0 || Complex.isNegZero(complex2.re)) {
            complex2.re = -complex2.re;
            complex2.im = -complex2.im;
        }
        return complex2;
    }

    public static double argument(Complex complex) {
        return Math.atan2(complex.im, complex.re);
    }

    public static Complex asin(Complex complex) {
        Complex complex2 = new Complex();
        double d2 = Complex.abs(complex);
        if (Double.isInfinite(d2)) {
            boolean bl = Double.isInfinite(complex.re);
            boolean bl2 = Double.isInfinite(complex.im);
            if (bl) {
                double d3 = 1.5707963267948966;
                double d4 = complex2.re = complex.re > 0.0 ? d3 : -d3;
                if (bl2) {
                    complex2.re /= 2.0;
                }
            } else if (bl2) {
                complex2.re = complex.re / Double.POSITIVE_INFINITY;
            }
            if (Double.isNaN(complex.im)) {
                complex2.im = -complex.re;
                complex2.re = complex.im;
            } else {
                complex2.im = complex.im * Double.POSITIVE_INFINITY;
            }
            return complex2;
        }
        if (Double.isNaN(d2)) {
            complex2.im = Double.NaN;
            complex2.re = Double.NaN;
            if (complex.re == 0.0) {
                complex2.re = complex.re;
            }
        } else if (d2 < 2.58095E-8) {
            complex2.re = complex.re;
            complex2.im = complex.im;
        } else if (complex.re == 0.0) {
            complex2.re = 0.0;
            complex2.im = Sfun.asinh(complex.im);
        } else if (d2 <= 0.1) {
            Complex complex3 = Complex.times(complex, complex);
            int n = 1;
            while (n <= 8) {
                double d5 = 2 * (8 - n) + 1;
                complex2 = Complex.times(Complex.times(complex2, complex3), d5 / (d5 + 1.0));
                complex2.re += 1.0 / d5;
                ++n;
            }
            complex2 = complex2.times(complex);
        } else {
            Complex complex4 = complex.im < 0.0 ? Complex.negative(complex) : complex;
            Complex complex5 = Complex.sqrt(Complex.plus(complex4, 1.0));
            if (complex5.im < 0.0) {
                complex5 = Complex.negative(complex5);
            }
            Complex complex6 = Complex.sqrt(Complex.minus(complex4, 1.0));
            complex2 = Complex.log(Complex.plus(complex4, Complex.times(complex5, complex6)));
            double d6 = complex2.re;
            complex2.re = 1.5707963267948966 + complex2.im;
            complex2.im = -d6;
        }
        if (complex2.re > 1.5707963267948966) {
            complex2.re = Math.PI - complex2.re;
            complex2.im = -complex2.im;
        }
        if (complex2.re < -1.5707963267948966) {
            complex2.re = -Math.PI - complex2.re;
            complex2.im = -complex2.im;
        }
        if (complex.im < 0.0) {
            complex2.re = -complex2.re;
            complex2.im = -complex2.im;
        }
        return complex2;
    }

    public static Complex asinh(Complex complex) {
        Complex complex2 = new Complex(complex.im, -complex.re);
        Complex complex3 = Complex.asin(complex2);
        double d2 = complex3.im;
        complex3.im = complex3.re;
        complex3.re = -d2;
        return complex3;
    }

    public static Complex atan(Complex complex) {
        Complex complex2 = new Complex();
        double d2 = Complex.abs(complex);
        if (Double.isInfinite(d2)) {
            double d3 = 1.5707963267948966;
            double d4 = Double.isNaN(complex.im) ? 0.0 : complex.im;
            complex2.re = complex.re < 0.0 ? -d3 : d3;
            complex2.im = (d4 < 0.0 ? -1.0 : 1.0) / Double.POSITIVE_INFINITY;
            if (Double.isNaN(complex.re)) {
                complex2.re = complex.re;
            }
        } else if (Double.isNaN(d2)) {
            complex2.im = Double.NaN;
            complex2.re = Double.NaN;
            if (complex.im == 0.0) {
                complex2.im = complex.im;
            }
        } else if (d2 < 1.82501E-8) {
            complex2.re = complex.re;
            complex2.im = complex.im;
        } else if (d2 < 0.1) {
            Complex complex3 = Complex.times(complex, complex);
            int n = 0;
            while (n < 17) {
                Complex complex4 = Complex.times(complex3, complex2);
                int n2 = 2 * (17 - n) - 1;
                complex2.re = 1.0 / (double)n2 - complex4.re;
                complex2.im = -complex4.im;
                ++n;
            }
            complex2 = complex2.times(complex);
        } else if (d2 < 9.0072E15) {
            double d5 = d2 * d2;
            complex2.re = 0.5 * Math.atan2(2.0 * complex.re, 1.0 - d5);
            complex2.im = 0.25 * Math.log((d5 + 2.0 * complex.im + 1.0) / (d5 - 2.0 * complex.im + 1.0));
        } else {
            complex2.re = complex.re < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        return complex2;
    }

    public static Complex atanh(Complex complex) {
        Complex complex2 = new Complex(complex.im, -complex.re);
        Complex complex3 = Complex.atan(complex2);
        double d2 = complex3.im;
        complex3.im = complex3.re;
        complex3.re = -d2;
        return complex3;
    }

    public static Complex conjugate(Complex complex) {
        return new Complex(complex.re, -complex.im);
    }

    private static double copysign(double d2, double d3) {
        double d4 = Math.abs(d2);
        return d3 < 0.0 ? -d4 : d4;
    }

    public static Complex cos(Complex complex) {
        return Complex.cosh(new Complex(-complex.im, complex.re));
    }

    public static Complex cosh(Complex complex) {
        if (complex.im == 0.0) {
            return new Complex(Sfun.cosh(complex.re));
        }
        double d2 = Sfun.cosh(complex.re);
        double d3 = Sfun.sinh(complex.re);
        double d4 = Math.cos(complex.im);
        double d5 = Math.sin(complex.im);
        boolean bl = Double.isInfinite(d2);
        boolean bl2 = Double.isInfinite(complex.im);
        Complex complex2 = new Complex(d2 * d4, d3 * d5);
        if (bl2) {
            complex2.re = Double.NaN;
        }
        if (complex.re == 0.0) {
            complex2.im = 0.0;
        } else if (bl) {
            complex2.re = complex.re * d4;
            complex2.im = complex.re * d5;
            if (complex.im == 0.0) {
                complex2.im = 0.0;
            }
            if (Double.isNaN(complex.im)) {
                complex2.re = complex.re;
            } else if (bl2) {
                complex2.re = complex.im;
            }
        }
        return complex2;
    }

    public boolean equals(Complex complex) {
        if (this.isNaN() && complex.isNaN()) {
            return true;
        }
        return this.re == complex.re && this.im == complex.im;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Complex) {
            return this.equals((Complex)object);
        }
        return false;
    }

    public static Complex exp(Complex complex) {
        Complex complex2 = new Complex();
        double d2 = Math.exp(complex.re);
        double d3 = Math.cos(complex.im);
        double d4 = Math.sin(complex.im);
        if (Double.isInfinite(complex.im) || Double.isNaN(complex.im) || Math.abs(d3) > 1.0) {
            d4 = Double.NaN;
            d3 = Double.NaN;
        }
        if (Double.isInfinite(complex.re) || Double.isInfinite(d2)) {
            if (complex.re < 0.0) {
                d2 = 0.0;
                if (Double.isInfinite(complex.im) || Double.isNaN(complex.im)) {
                    d4 = 0.0;
                    d3 = 0.0;
                } else {
                    d3 /= Double.POSITIVE_INFINITY;
                    d4 /= Double.POSITIVE_INFINITY;
                }
            } else {
                d2 = complex.re;
                if (Double.isNaN(complex.im)) {
                    d3 = 1.0;
                }
            }
        }
        if (complex.im == 0.0) {
            complex2.re = d2;
            complex2.im = complex.im;
        } else {
            complex2.re = d2 * d3;
            complex2.im = d2 * d4;
        }
        return complex2;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.re);
        long l2 = Double.doubleToLongBits(this.im);
        return (int)(l ^ l2 ^ (l ^ l2) >> 32);
    }

    public double imag() {
        return this.im;
    }

    public static double imag(Complex complex) {
        return complex.im;
    }

    private static boolean isFinite(double d2) {
        return !Double.isInfinite(d2) && !Double.isNaN(d2);
    }

    private boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    private static boolean isNegZero(double d2) {
        return Double.doubleToLongBits(d2) == negZeroBits;
    }

    public static Complex log(Complex complex) {
        Complex complex2 = new Complex();
        if (Double.isNaN(complex.re)) {
            complex2.re = complex2.im = complex.re;
            if (Double.isInfinite(complex.im)) {
                complex2.re = Double.POSITIVE_INFINITY;
            }
        } else if (Double.isNaN(complex.im)) {
            complex2.re = complex2.im = complex.im;
            if (Double.isInfinite(complex.re)) {
                complex2.re = Double.POSITIVE_INFINITY;
            }
        } else {
            complex2.re = Math.log(Complex.abs(complex));
            complex2.im = Complex.argument(complex);
        }
        return complex2;
    }

    public Complex minus(double d2) {
        return new Complex(this.re - d2, this.im);
    }

    public static Complex minus(double d2, Complex complex) {
        return new Complex(d2 - complex.re, -complex.im);
    }

    public Complex minus(Complex complex) {
        return new Complex(this.re - complex.re, this.im - complex.im);
    }

    public static Complex minus(Complex complex, double d2) {
        return new Complex(complex.re - d2, complex.im);
    }

    public static Complex minus(Complex complex, Complex complex2) {
        return new Complex(complex.re - complex2.re, complex.im - complex2.im);
    }

    public Complex minusReverse(double d2) {
        return new Complex(d2 - this.re, -this.im);
    }

    public static Complex negative(Complex complex) {
        return new Complex(-complex.re, -complex.im);
    }

    public Complex over(double d2) {
        return Complex.over(this, d2);
    }

    public static Complex over(double d2, Complex complex) {
        return complex.overReverse(d2);
    }

    public Complex over(Complex complex) {
        return Complex.over(this, complex);
    }

    public static Complex over(Complex complex, double d2) {
        return new Complex(complex.re / d2, complex.im / d2);
    }

    public static Complex over(Complex complex, Complex complex2) {
        double d2 = complex.re;
        double d3 = complex.im;
        double d4 = complex2.re;
        double d5 = complex2.im;
        double d6 = Math.max(Math.abs(d4), Math.abs(d5));
        boolean bl = Complex.isFinite(d6);
        if (bl) {
            d4 /= d6;
            d5 /= d6;
        }
        double d7 = d4 * d4 + d5 * d5;
        Complex complex3 = new Complex((d2 * d4 + d3 * d5) / d7, (d3 * d4 - d2 * d5) / d7);
        if (bl) {
            complex3.re /= d6;
            complex3.im /= d6;
        }
        if (Double.isNaN(complex3.re) && Double.isNaN(complex3.im)) {
            if (!(d7 != 0.0 || Double.isNaN(d2) && Double.isNaN(d3))) {
                double d8 = Complex.copysign(Double.POSITIVE_INFINITY, d4);
                complex3.re = d8 * d2;
                complex3.im = d8 * d3;
            } else if ((Double.isInfinite(d2) || Double.isInfinite(d3)) && Complex.isFinite(d4) && Complex.isFinite(d5)) {
                d2 = Complex.copysign(Double.isInfinite(d2) ? 1.0 : 0.0, d2);
                d3 = Complex.copysign(Double.isInfinite(d3) ? 1.0 : 0.0, d3);
                complex3.re = Double.POSITIVE_INFINITY * (d2 * d4 + d3 * d5);
                complex3.im = Double.POSITIVE_INFINITY * (d3 * d4 - d2 * d5);
            } else if (Double.isInfinite(d6) && Complex.isFinite(d2) && Complex.isFinite(d3)) {
                d4 = Complex.copysign(Double.isInfinite(d4) ? 1.0 : 0.0, d4);
                d5 = Complex.copysign(Double.isInfinite(d5) ? 1.0 : 0.0, d5);
                complex3.re = 0.0 * (d2 * d4 + d3 * d5);
                complex3.im = 0.0 * (d3 * d4 - d2 * d5);
            }
        }
        return complex3;
    }

    public Complex overReverse(double d2) {
        Complex complex;
        if (Math.abs(this.re) > Math.abs(this.im)) {
            double d3 = this.im / this.re;
            double d4 = this.re + this.im * d3;
            complex = new Complex(d2 / d4, -d2 * d3 / d4);
        } else {
            double d5 = this.re / this.im;
            double d6 = this.im + this.re * d5;
            complex = new Complex(d2 * d5 / d6, -d2 / d6);
        }
        return complex;
    }

    public Complex plus(double d2) {
        return new Complex(this.re + d2, this.im);
    }

    public static Complex plus(double d2, Complex complex) {
        return new Complex(d2 + complex.re, complex.im);
    }

    public Complex plus(Complex complex) {
        return new Complex(this.re + complex.re, this.im + complex.im);
    }

    public static Complex plus(Complex complex, double d2) {
        return new Complex(complex.re + d2, complex.im);
    }

    public static Complex plus(Complex complex, Complex complex2) {
        return new Complex(complex.re + complex2.re, complex.im + complex2.im);
    }

    public Complex plusReverse(double d2) {
        return new Complex(this.re + d2, this.im);
    }

    public static Complex pow(Complex complex, double d2) {
        double d3 = Complex.abs(complex);
        Complex complex2 = new Complex();
        if (d3 == 0.0) {
            complex2 = complex;
        } else {
            double d4 = Complex.argument(complex);
            double d5 = Math.pow(d3, d2);
            complex2.re = d5 * Math.cos(d2 * d4);
            complex2.im = d5 * Math.sin(d2 * d4);
        }
        return complex2;
    }

    public static Complex pow(Complex complex, Complex complex2) {
        return Complex.exp(Complex.times(complex2, Complex.log(complex)));
    }

    public double real() {
        return this.re;
    }

    public static double real(Complex complex) {
        return complex.re;
    }

    public static Complex sin(Complex complex) {
        Complex complex2 = new Complex(-complex.im, complex.re);
        Complex complex3 = Complex.sinh(complex2);
        double d2 = complex3.im;
        complex3.im = -complex3.re;
        complex3.re = d2;
        return complex3;
    }

    public static Complex sinh(Complex complex) {
        Complex complex2;
        double d2 = Sfun.cosh(complex.re);
        double d3 = Sfun.sinh(complex.re);
        double d4 = Math.cos(complex.im);
        double d5 = Math.sin(complex.im);
        boolean bl = Double.isInfinite(d2);
        boolean bl2 = Double.isInfinite(complex.im);
        if (complex.im == 0.0) {
            complex2 = new Complex(Sfun.sinh(complex.re));
        } else {
            complex2 = new Complex(d3 * d4, d2 * d5);
            if (bl2) {
                complex2.im = Double.NaN;
                if (complex.re == 0.0) {
                    complex2.re = 0.0;
                }
            }
            if (bl) {
                complex2.re = complex.re * d4;
                complex2.im = complex.re * d5;
                if (complex.im == 0.0) {
                    complex2.im = 0.0;
                }
                if (bl2) {
                    complex2.re = complex.im;
                }
            }
        }
        return complex2;
    }

    public static Complex sqrt(Complex complex) {
        Complex complex2 = new Complex();
        if (Double.isInfinite(complex.im)) {
            complex2.re = Double.POSITIVE_INFINITY;
            complex2.im = complex.im;
        } else if (Double.isNaN(complex.re)) {
            complex2.im = Double.NaN;
            complex2.re = Double.NaN;
        } else if (Double.isNaN(complex.im)) {
            if (Double.isInfinite(complex.re)) {
                if (complex.re > 0.0) {
                    complex2.re = complex.re;
                    complex2.im = complex.im;
                } else {
                    complex2.re = complex.im;
                    complex2.im = Double.POSITIVE_INFINITY;
                }
            } else {
                complex2.im = Double.NaN;
                complex2.re = Double.NaN;
            }
        } else {
            double d2 = Complex.abs(complex);
            if (Math.abs(complex.re) <= Math.abs(complex.im)) {
                complex2.re = Math.sqrt(0.5 * (d2 + complex.re));
                complex2.im = Math.sqrt(0.5 * (d2 - complex.re));
            } else if (complex.re > 0.0) {
                complex2.re = d2 + complex.re;
                complex2.im = Math.abs(complex.im) * Math.sqrt(0.5 / complex2.re);
                complex2.re = Math.sqrt(0.5 * complex2.re);
            } else {
                complex2.im = d2 - complex.re;
                complex2.re = Math.abs(complex.im) * Math.sqrt(0.5 / complex2.im);
                complex2.im = Math.sqrt(0.5 * complex2.im);
            }
            if (complex.im < 0.0) {
                complex2.im = -complex2.im;
            }
        }
        return complex2;
    }

    public static Complex tan(Complex complex) {
        Complex complex2 = new Complex(-complex.im, complex.re);
        Complex complex3 = Complex.tanh(complex2);
        double d2 = complex3.im;
        complex3.im = -complex3.re;
        complex3.re = d2;
        return complex3;
    }

    public static Complex tanh(Complex complex) {
        double d2 = Sfun.sinh(2.0 * complex.re);
        if (complex.im == 0.0) {
            return new Complex(Sfun.tanh(complex.re));
        }
        if (d2 == 0.0) {
            return new Complex(0.0, Math.tan(complex.im));
        }
        double d3 = Sfun.cosh(2.0 * complex.re);
        double d4 = Math.cos(2.0 * complex.im);
        double d5 = Math.sin(2.0 * complex.im);
        boolean bl = Double.isInfinite(d3);
        if (Double.isInfinite(complex.im) || Double.isNaN(complex.im)) {
            d5 = Double.NaN;
            d4 = Double.NaN;
        }
        if (bl) {
            return new Complex(complex.re > 0.0 ? 1.0 : -1.0);
        }
        double d6 = d3 + d4;
        return new Complex(d2 / d6, d5 / d6);
    }

    public Complex times(double d2) {
        return new Complex(this.re * d2, this.im * d2);
    }

    public static Complex times(double d2, Complex complex) {
        return new Complex(d2 * complex.re, d2 * complex.im);
    }

    public Complex times(Complex complex) {
        return Complex.times(this, complex);
    }

    public static Complex times(Complex complex, double d2) {
        return new Complex(complex.re * d2, complex.im * d2);
    }

    public static Complex times(Complex complex, Complex complex2) {
        Complex complex3 = new Complex(complex.re * complex2.re - complex.im * complex2.im, complex.re * complex2.im + complex.im * complex2.re);
        if (Double.isNaN(complex3.re) && Double.isNaN(complex3.im)) {
            Complex.timesNaN(complex, complex2, complex3);
        }
        return complex3;
    }

    private static void timesNaN(Complex complex, Complex complex2, Complex complex3) {
        boolean bl = false;
        double d2 = complex.re;
        double d3 = complex.im;
        double d4 = complex2.re;
        double d5 = complex2.im;
        if (Double.isInfinite(d2) || Double.isInfinite(d3)) {
            d2 = Complex.copysign(Double.isInfinite(d2) ? 1.0 : 0.0, d2);
            d3 = Complex.copysign(Double.isInfinite(d3) ? 1.0 : 0.0, d3);
            if (Double.isNaN(d4)) {
                d4 = Complex.copysign(0.0, d4);
            }
            if (Double.isNaN(d5)) {
                d5 = Complex.copysign(0.0, d5);
            }
            bl = true;
        }
        if (Double.isInfinite(d4) || Double.isInfinite(d5)) {
            d2 = Complex.copysign(Double.isInfinite(d4) ? 1.0 : 0.0, d4);
            d3 = Complex.copysign(Double.isInfinite(d5) ? 1.0 : 0.0, d5);
            if (Double.isNaN(d2)) {
                d2 = Complex.copysign(0.0, d2);
            }
            if (Double.isNaN(d3)) {
                d3 = Complex.copysign(0.0, d3);
            }
            bl = true;
        }
        if (!bl && (Double.isInfinite(d2 * d4) || Double.isInfinite(d3 * d5) || Double.isInfinite(d2 * d5) || Double.isInfinite(d3 * d4))) {
            if (Double.isNaN(d2)) {
                d2 = Complex.copysign(0.0, d2);
            }
            if (Double.isNaN(d3)) {
                d3 = Complex.copysign(0.0, d3);
            }
            if (Double.isNaN(d4)) {
                d4 = Complex.copysign(0.0, d4);
            }
            if (Double.isNaN(d5)) {
                d5 = Complex.copysign(0.0, d5);
            }
            bl = true;
        }
        if (bl) {
            complex3.re = Double.POSITIVE_INFINITY * (d2 * d4 - d3 * d5);
            complex3.im = Double.POSITIVE_INFINITY * (d2 * d5 + d3 * d4);
        }
    }

    public Complex timesReverse(double d2) {
        return new Complex(d2 * this.re, d2 * this.im);
    }

    public String toString() {
        if (this.im == 0.0) {
            return String.valueOf(this.re);
        }
        if (this.re == 0.0) {
            return String.valueOf(this.im) + suffix;
        }
        String string = this.im < 0.0 ? "" : "+";
        return String.valueOf(this.re) + string + String.valueOf(this.im) + suffix;
    }

    public static Complex valueOf(String string) throws NumberFormatException {
        String string2 = string.trim();
        int n = 0;
        Complex complex = new Complex();
        int n2 = 0;
        int n3 = 1;
        boolean bl = false;
        int n4 = 0;
        while (n4 < string2.length()) {
            char c2 = string2.charAt(n4);
            switch (c2) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (n2 == 0 || n2 == 1) {
                        n2 = 2;
                        break;
                    }
                    if (n2 != 4) break;
                    n2 = 5;
                    break;
                }
                case '+': 
                case '-': {
                    int n5 = n3 = c2 == '+' ? 1 : -1;
                    if (n2 == 0) {
                        n2 = 1;
                        break;
                    }
                    if (n2 == 4) {
                        n2 = 5;
                        break;
                    }
                    if (!bl) {
                        complex.re = Double.valueOf(string2.substring(n, n4));
                        bl = true;
                        n = n4;
                        n2 = 1;
                        break;
                    }
                    throw new NumberFormatException(string2);
                }
                case '.': {
                    if (n2 == 0 || n2 == 1 || n2 == 2) {
                        n2 = 3;
                        break;
                    }
                    throw new NumberFormatException(string2);
                }
                case 'I': 
                case 'J': 
                case 'i': 
                case 'j': {
                    if (n4 + 1 != string2.length()) {
                        throw new NumberFormatException(string2);
                    }
                    if (n2 == 0 || n2 == 1) {
                        complex.im = n3;
                        return complex;
                    }
                    if (n2 == 2 || n2 == 3 || n2 == 5) {
                        complex.im = Double.valueOf(string2.substring(n, n4));
                        return complex;
                    }
                    throw new NumberFormatException(string2);
                }
                case 'D': 
                case 'E': 
                case 'd': 
                case 'e': {
                    if (n2 == 2 || n2 == 3) {
                        n2 = 4;
                        break;
                    }
                    throw new NumberFormatException(string2);
                }
                default: {
                    throw new NumberFormatException(string2);
                }
            }
            ++n4;
        }
        if (!bl) {
            complex.re = Double.valueOf(string2);
            return complex;
        }
        throw new NumberFormatException(string2);
    }
}

