/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.lang;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public final class ByteUtils {
    public static final short UNSIGNED_MAX_VALUE = 255;

    public static short toUnsigned(byte b2) {
        return (short)(b2 < 0 ? 256 + b2 : b2);
    }

    public static String toHexAscii(byte b2) {
        StringWriter sw = new StringWriter(2);
        ByteUtils.addHexAscii(b2, sw);
        return sw.toString();
    }

    public static String toHexAscii(byte[] bytes) {
        int len = bytes.length;
        StringWriter sw = new StringWriter(len * 2);
        for (int i = 0; i < len; ++i) {
            ByteUtils.addHexAscii(bytes[i], sw);
        }
        return sw.toString();
    }

    public static byte[] fromHexAscii(String s) throws NumberFormatException {
        try {
            int len = s.length();
            if (len % 2 != 0) {
                throw new NumberFormatException("Hex ascii must be exactly two digits per byte.");
            }
            int out_len = len / 2;
            byte[] out = new byte[out_len];
            int i = 0;
            StringReader sr = new StringReader(s);
            while (i < out_len) {
                int val = 16 * ByteUtils.fromHexDigit(sr.read()) + ByteUtils.fromHexDigit(sr.read());
                out[i++] = (byte)val;
            }
            return out;
        }
        catch (IOException e2) {
            throw new InternalError("IOException reading from StringReader?!?!");
        }
    }

    static void addHexAscii(byte b2, StringWriter sw) {
        short ub = ByteUtils.toUnsigned(b2);
        int h1 = ub / 16;
        int h2 = ub % 16;
        sw.write(ByteUtils.toHexDigit(h1));
        sw.write(ByteUtils.toHexDigit(h2));
    }

    private static int fromHexDigit(int c2) throws NumberFormatException {
        if (c2 >= 48 && c2 < 58) {
            return c2 - 48;
        }
        if (c2 >= 65 && c2 < 71) {
            return c2 - 55;
        }
        if (c2 >= 97 && c2 < 103) {
            return c2 - 87;
        }
        throw new NumberFormatException(39 + c2 + "' is not a valid hexadecimal digit.");
    }

    private static char toHexDigit(int h) {
        char out = h <= 9 ? (char)(h + 48) : (char)(h + 55);
        return out;
    }

    private ByteUtils() {
    }
}

