/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.ref.AbstractHistogram3D;
import hep.aida.ref.FixedAxis;
import hep.aida.ref.Histogram2D;
import hep.aida.ref.VariableAxis;

public class Histogram3D
extends AbstractHistogram3D
implements IHistogram3D {
    private double[][][] heights;
    private double[][][] errors;
    private int[][][] entries;
    private int nEntry;
    private double sumWeight;
    private double sumWeightSquared;
    private double meanX;
    private double rmsX;
    private double meanY;
    private double rmsY;
    private double meanZ;
    private double rmsZ;

    public Histogram3D(String string, double[] dArray, double[] dArray2, double[] dArray3) {
        this(string, new VariableAxis(dArray), new VariableAxis(dArray2), new VariableAxis(dArray3));
    }

    public Histogram3D(String string, int n, double d2, double d3, int n2, double d4, double d5, int n3, double d6, double d7) {
        this(string, new FixedAxis(n, d2, d3), new FixedAxis(n2, d4, d5), new FixedAxis(n3, d6, d7));
    }

    public Histogram3D(String string, IAxis iAxis, IAxis iAxis2, IAxis iAxis3) {
        super(string);
        this.xAxis = iAxis;
        this.yAxis = iAxis2;
        this.zAxis = iAxis3;
        int n = iAxis.bins();
        int n2 = iAxis2.bins();
        int n3 = iAxis3.bins();
        this.entries = new int[n + 2][n2 + 2][n3 + 2];
        this.heights = new double[n + 2][n2 + 2][n3 + 2];
        this.errors = new double[n + 2][n2 + 2][n3 + 2];
    }

    public int allEntries() {
        return this.nEntry;
    }

    public int binEntries(int n, int n2, int n3) {
        return this.entries[this.mapX(n)][this.mapY(n2)][this.mapZ(n3)];
    }

    public double binError(int n, int n2, int n3) {
        return Math.sqrt(this.errors[this.mapX(n)][this.mapY(n2)][this.mapZ(n3)]);
    }

    public double binHeight(int n, int n2, int n3) {
        return this.heights[this.mapX(n)][this.mapY(n2)][this.mapZ(n3)];
    }

    public double equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    public void fill(double d2, double d3, double d4) {
        int n = this.mapX(this.xAxis.coordToIndex(d2));
        int n2 = this.mapY(this.yAxis.coordToIndex(d3));
        int n3 = this.mapZ(this.zAxis.coordToIndex(d4));
        int[] nArray = this.entries[n][n2];
        int n4 = n3;
        nArray[n4] = nArray[n4] + 1;
        double[] dArray = this.heights[n][n2];
        int n5 = n3;
        dArray[n5] = dArray[n5] + 1.0;
        double[] dArray2 = this.errors[n][n2];
        int n6 = n3;
        dArray2[n6] = dArray2[n6] + 1.0;
        ++this.nEntry;
        this.sumWeight += 1.0;
        this.sumWeightSquared += 1.0;
        this.meanX += d2;
        this.rmsX += d2;
        this.meanY += d3;
        this.rmsY += d3;
        this.meanZ += d4;
        this.rmsZ += d4;
    }

    public void fill(double d2, double d3, double d4, double d5) {
        int n = this.mapX(this.xAxis.coordToIndex(d2));
        int n2 = this.mapY(this.yAxis.coordToIndex(d3));
        int n3 = this.mapZ(this.zAxis.coordToIndex(d4));
        int[] nArray = this.entries[n][n2];
        int n4 = n3;
        nArray[n4] = nArray[n4] + 1;
        double[] dArray = this.heights[n][n2];
        int n5 = n3;
        dArray[n5] = dArray[n5] + d5;
        double[] dArray2 = this.errors[n][n2];
        int n6 = n3;
        dArray2[n6] = dArray2[n6] + d5 * d5;
        ++this.nEntry;
        this.sumWeight += d5;
        this.sumWeightSquared += d5 * d5;
        this.meanX += d2 * d5;
        this.rmsX += d2 * d5 * d5;
        this.meanY += d3 * d5;
        this.rmsY += d3 * d5 * d5;
        this.meanZ += d4 * d5;
        this.rmsZ += d4 * d5 * d5;
    }

    protected IHistogram2D internalSliceXY(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.xAxis.bins() + 2;
        int n4 = this.yAxis.bins() + 2;
        int[][] nArray = new int[n3][n4];
        double[][] dArray = new double[n3][n4];
        double[][] dArray2 = new double[n3][n4];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                int n7 = n;
                while (n7 <= n2) {
                    int[] nArray2 = nArray[n5];
                    int n8 = n6;
                    nArray2[n8] = nArray2[n8] + this.entries[n5][n6][n7];
                    double[] dArray3 = dArray[n5];
                    int n9 = n6;
                    dArray3[n9] = dArray3[n9] + this.heights[n5][n6][n7];
                    double[] dArray4 = dArray2[n5];
                    int n10 = n6;
                    dArray4[n10] = dArray4[n10] + this.errors[n5][n6][n7];
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        Histogram2D histogram2D = new Histogram2D(string, this.xAxis, this.yAxis);
        histogram2D.setContents(nArray, dArray, dArray2);
        return histogram2D;
    }

    protected IHistogram2D internalSliceXZ(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.xAxis.bins() + 2;
        int n4 = this.zAxis.bins() + 2;
        int[][] nArray = new int[n3][n4];
        double[][] dArray = new double[n3][n4];
        double[][] dArray2 = new double[n3][n4];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = n;
            while (n6 <= n2) {
                int n7 = 0;
                while (n5 < n4) {
                    int[] nArray2 = nArray[n5];
                    int n8 = n7;
                    nArray2[n8] = nArray2[n8] + this.entries[n5][n6][n7];
                    double[] dArray3 = dArray[n5];
                    int n9 = n7;
                    dArray3[n9] = dArray3[n9] + this.heights[n5][n6][n7];
                    double[] dArray4 = dArray2[n5];
                    int n10 = n7;
                    dArray4[n10] = dArray4[n10] + this.errors[n5][n6][n7];
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        Histogram2D histogram2D = new Histogram2D(string, this.xAxis, this.zAxis);
        histogram2D.setContents(nArray, dArray, dArray2);
        return histogram2D;
    }

    protected IHistogram2D internalSliceYZ(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.yAxis.bins() + 2;
        int n4 = this.zAxis.bins() + 2;
        int[][] nArray = new int[n3][n4];
        double[][] dArray = new double[n3][n4];
        double[][] dArray2 = new double[n3][n4];
        int n5 = n;
        while (n5 <= n2) {
            int n6 = 0;
            while (n6 < n3) {
                int n7 = 0;
                while (n7 < n4) {
                    int[] nArray2 = nArray[n6];
                    int n8 = n7;
                    nArray2[n8] = nArray2[n8] + this.entries[n5][n6][n7];
                    double[] dArray3 = dArray[n6];
                    int n9 = n7;
                    dArray3[n9] = dArray3[n9] + this.heights[n5][n6][n7];
                    double[] dArray4 = dArray2[n6];
                    int n10 = n7;
                    dArray4[n10] = dArray4[n10] + this.errors[n5][n6][n7];
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        Histogram2D histogram2D = new Histogram2D(string, this.yAxis, this.zAxis);
        histogram2D.setContents(nArray, dArray, dArray2);
        return histogram2D;
    }

    public double meanX() {
        return this.meanX / this.sumWeight;
    }

    public double meanY() {
        return this.meanY / this.sumWeight;
    }

    public double meanZ() {
        return this.meanZ / this.sumWeight;
    }

    public void reset() {
        int n = 0;
        while (n < this.entries.length) {
            int n2 = 0;
            while (n2 < this.entries[0].length) {
                int n3 = 0;
                while (n2 < this.entries[0][0].length) {
                    this.entries[n][n2][n3] = 0;
                    this.heights[n][n2][n3] = 0.0;
                    this.errors[n][n2][n3] = 0.0;
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.nEntry = 0;
        this.sumWeight = 0.0;
        this.sumWeightSquared = 0.0;
        this.meanX = 0.0;
        this.rmsX = 0.0;
        this.meanY = 0.0;
        this.rmsY = 0.0;
        this.meanZ = 0.0;
        this.rmsZ = 0.0;
    }

    public double rmsX() {
        return Math.sqrt(this.rmsX / this.sumWeight - this.meanX * this.meanX / this.sumWeight / this.sumWeight);
    }

    public double rmsY() {
        return Math.sqrt(this.rmsY / this.sumWeight - this.meanY * this.meanY / this.sumWeight / this.sumWeight);
    }

    public double rmsZ() {
        return Math.sqrt(this.rmsZ / this.sumWeight - this.meanZ * this.meanZ / this.sumWeight / this.sumWeight);
    }

    public double sumAllBinHeights() {
        return this.sumWeight;
    }
}

