/*
 * Decompiled with CFR 0.152.
 */
package jal.LONG;

import jal.LONG.BinaryPredicate;
import jal.LONG.Modification;
import jal.LONG.Range;

public final class Sorting {
    private static final int partitionCutoff = 13;
    private static final int qsort_stacksize = 56;
    private static final int stableSortCutoff = 9;

    public static void sort(long[] lArray, int n, int n2) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(lArray, n, n2);
        }
        Sorting.insertion_sort(lArray, n, n2);
    }

    public static void sort(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(lArray, n, n2, binaryPredicate);
        }
        Sorting.insertion_sort(lArray, n, n2, binaryPredicate);
    }

    public static void insertion_sort(long[] lArray, int n, int n2) {
        int n3 = n;
        while (++n3 < n2) {
            long l = lArray[n3];
            int n4 = n3;
            long l2 = lArray[n4 - 1];
            while (l < l2) {
                lArray[n4] = l2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                l2 = lArray[--n4 - 1];
            }
            lArray[n4] = l;
        }
    }

    public static void insertion_sort(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int n3 = n;
        while (++n3 < n2) {
            long l = lArray[n3];
            int n4 = n3;
            long l2 = lArray[n4 - 1];
            while (binaryPredicate.apply(l, l2)) {
                lArray[n4] = l2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                l2 = lArray[--n4 - 1];
            }
            lArray[n4] = l;
        }
    }

    private static int quickPartition(long[] lArray, int n, int n2) {
        long l = lArray[n];
        long l2 = lArray[n2 - 1];
        long l3 = lArray[n + (n2 - n) / 2];
        if (l3 < l) {
            if (l < l2) {
                l3 = l;
            } else if (l3 < l2) {
                l3 = l2;
            }
        } else if (l2 < l) {
            l3 = l;
        } else if (l2 < l3) {
            l3 = l2;
        }
        --n;
        while (true) {
            if (lArray[++n] < l3) {
                continue;
            }
            while (l3 < lArray[--n2]) {
            }
            if (n >= n2) {
                return n;
            }
            long l4 = lArray[n];
            lArray[n] = lArray[n2];
            lArray[n2] = l4;
        }
    }

    private static int quickPartition(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        long l = lArray[n];
        long l2 = lArray[n2 - 1];
        long l3 = lArray[n + (n2 - n) / 2];
        if (binaryPredicate.apply(l3, l)) {
            if (binaryPredicate.apply(l, l2)) {
                l3 = l;
            } else if (binaryPredicate.apply(l3, l2)) {
                l3 = l2;
            }
        } else if (binaryPredicate.apply(l2, l)) {
            l3 = l;
        } else if (binaryPredicate.apply(l2, l3)) {
            l3 = l2;
        }
        --n;
        while (true) {
            if (binaryPredicate.apply(lArray[++n], l3)) {
                continue;
            }
            while (binaryPredicate.apply(l3, lArray[--n2])) {
            }
            if (n >= n2) {
                return n;
            }
            long l4 = lArray[n];
            lArray[n] = lArray[n2];
            lArray[n2] = l4;
        }
    }

    private static void qsortLoop(long[] lArray, int n, int n2) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(lArray, n, n2)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    private static void qsortLoop(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(lArray, n, n2, binaryPredicate)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    public static void stable_sort(long[] lArray, int n, int n2) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(lArray, n, n2);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(lArray, n, n3);
            Sorting.stable_sort(lArray, n3, n2);
            Sorting.inplace_merge(lArray, n, n3, n2);
        }
    }

    public static void stable_sort(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(lArray, n, n2, binaryPredicate);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(lArray, n, n3, binaryPredicate);
            Sorting.stable_sort(lArray, n3, n2, binaryPredicate);
            Sorting.inplace_merge(lArray, n, n3, n2, binaryPredicate);
        }
    }

    public static void partial_sort(long[] lArray, int n, int n2, int n3) {
        Sorting.make_heap(lArray, n, n2);
        int n4 = n2;
        while (n4 < n3) {
            if (lArray[n4] < lArray[n]) {
                long l = lArray[n4];
                lArray[n4] = lArray[n];
                lArray[n] = l;
                Sorting.adjust_heap(lArray, n, n, n2);
            }
            ++n4;
        }
        Sorting.sort_heap(lArray, n, n2);
    }

    public static void partial_sort(long[] lArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        Sorting.make_heap(lArray, n, n2, binaryPredicate);
        int n4 = n2;
        while (n4 < n3) {
            if (binaryPredicate.apply(lArray[n4], lArray[n])) {
                long l = lArray[n4];
                lArray[n4] = lArray[n];
                lArray[n] = l;
                Sorting.adjust_heap(lArray, n, n, n2, binaryPredicate);
            }
            ++n4;
        }
        Sorting.sort_heap(lArray, n, n2, binaryPredicate);
    }

    public static int partial_sort_copy(long[] lArray, long[] lArray2, int n, int n2, int n3, int n4) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(lArray, lArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(lArray2, n3, n4);
        n += n5;
        while (n < n2) {
            if (lArray[n] < lArray2[n3]) {
                lArray2[n3] = lArray[n];
                Sorting.adjust_heap(lArray2, n3, n3, n4);
            }
            ++n;
        }
        Sorting.sort_heap(lArray2, n3, n4);
        return n4;
    }

    public static int partial_sort_copy(long[] lArray, long[] lArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(lArray, lArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(lArray2, n3, n4, binaryPredicate);
        n += n5;
        while (n < n2) {
            if (binaryPredicate.apply(lArray[n], lArray2[n3])) {
                lArray2[n3] = lArray[n];
                Sorting.adjust_heap(lArray2, n3, n3, n4, binaryPredicate);
            }
            ++n;
        }
        Sorting.sort_heap(lArray2, n3, n4, binaryPredicate);
        return n4;
    }

    public static void nth_element(long[] lArray, int n, int n2, int n3) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(lArray, n, n3);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(lArray, n, n3);
    }

    public static void nth_element(long[] lArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(lArray, n, n3, binaryPredicate);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(lArray, n, n3, binaryPredicate);
    }

    public static int lower_bound(long[] lArray, int n, int n2, long l) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (lArray[n5] < l) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int lower_bound(long[] lArray, int n, int n2, long l, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(lArray[n5], l)) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int upper_bound(long[] lArray, int n, int n2, long l) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (l < lArray[n5]) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static int upper_bound(long[] lArray, int n, int n2, long l, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(l, lArray[n5])) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static Range equal_range(long[] lArray, int n, int n2, long l) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (lArray[n5] < l) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (l < lArray[n5]) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(lArray, n, n5, l);
            int n7 = Sorting.upper_bound(lArray, n5 + 1, n + n3, l);
            return new Range(lArray, n6, n7);
        }
        return new Range(lArray, n, n);
    }

    public static Range equal_range(long[] lArray, int n, int n2, long l, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(lArray[n5], l)) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (binaryPredicate.apply(l, lArray[n5])) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(lArray, n, n5, l, binaryPredicate);
            int n7 = Sorting.upper_bound(lArray, n5 + 1, n + n3, l, binaryPredicate);
            return new Range(lArray, n6, n7);
        }
        return new Range(lArray, n, n);
    }

    public static boolean binary_search(long[] lArray, int n, int n2, long l) {
        int n3 = Sorting.lower_bound(lArray, n, n2, l);
        return n3 < n2 && l >= lArray[n3];
    }

    public static boolean binary_search(long[] lArray, int n, int n2, long l, BinaryPredicate binaryPredicate) {
        int n3 = Sorting.lower_bound(lArray, n, n2, l, binaryPredicate);
        return n3 < n2 && !binaryPredicate.apply(l, lArray[n3]);
    }

    public static int merge(long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            lArray3[n5++] = lArray2[n3] < lArray[n] ? lArray2[n3++] : lArray[n++];
        }
        Modification.copy(lArray, lArray3, n, n2, n5);
        Modification.copy(lArray2, lArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int merge(long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            lArray3[n5++] = binaryPredicate.apply(lArray2[n3], lArray[n]) ? lArray2[n3++] : lArray[n++];
        }
        Modification.copy(lArray, lArray3, n, n2, n5);
        Modification.copy(lArray2, lArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void inplace_merge(long[] lArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (lArray[n2] < lArray[n]) {
                long l = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(lArray, n2, n3, lArray[n5]);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(lArray, n, n2, lArray[n4]);
        }
        Modification.rotate(lArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(lArray, n, n5, n2);
        Sorting.inplace_merge(lArray, n2, n4, n3);
    }

    public static void inplace_merge(long[] lArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (binaryPredicate.apply(lArray[n2], lArray[n])) {
                long l = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(lArray, n2, n3, lArray[n5], binaryPredicate);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(lArray, n, n2, lArray[n4], binaryPredicate);
        }
        Modification.rotate(lArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(lArray, n, n5, n2, binaryPredicate);
        Sorting.inplace_merge(lArray, n2, n4, n3, binaryPredicate);
    }

    public static boolean includes(long[] lArray, long[] lArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (lArray2[n3] < lArray[n]) {
                return false;
            }
            if (lArray[n] < lArray2[n3]) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static boolean includes(long[] lArray, long[] lArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(lArray2[n3], lArray[n])) {
                return false;
            }
            if (binaryPredicate.apply(lArray[n], lArray2[n3])) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static int set_union(long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (lArray[n] < lArray2[n3]) {
                lArray3[n5++] = lArray[n++];
                continue;
            }
            if (lArray2[n3] < lArray[n]) {
                lArray3[n5++] = lArray2[n3++];
                continue;
            }
            lArray3[n5++] = lArray[n++];
            ++n3;
        }
        Modification.copy(lArray, lArray3, n, n2, n5);
        Modification.copy(lArray2, lArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_union(long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(lArray[n], lArray2[n3])) {
                lArray3[n5++] = lArray[n++];
                continue;
            }
            if (binaryPredicate.apply(lArray2[n3], lArray[n])) {
                lArray3[n5++] = lArray2[n3++];
                continue;
            }
            lArray3[n5++] = lArray[n++];
            ++n3;
        }
        Modification.copy(lArray, lArray3, n, n2, n5);
        Modification.copy(lArray2, lArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_intersection(long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (lArray[n] < lArray2[n3]) {
                ++n;
                continue;
            }
            if (lArray2[n3] < lArray[n]) {
                ++n3;
                continue;
            }
            lArray3[n5++] = lArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_intersection(long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(lArray[n], lArray2[n3])) {
                ++n;
                continue;
            }
            if (binaryPredicate.apply(lArray2[n3], lArray[n])) {
                ++n3;
                continue;
            }
            lArray3[n5++] = lArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_difference(long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (lArray[n] < lArray2[n3]) {
                lArray3[n5++] = lArray[n++];
                continue;
            }
            if (lArray2[n3] < lArray[n]) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(lArray, lArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_difference(long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(lArray[n], lArray2[n3])) {
                lArray3[n5++] = lArray[n++];
                continue;
            }
            if (binaryPredicate.apply(lArray2[n3], lArray[n])) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(lArray, lArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_symmetric_difference(long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (lArray[n] < lArray2[n3]) {
                lArray3[n5++] = lArray[n++];
                continue;
            }
            if (lArray2[n3] < lArray[n]) {
                lArray3[n5++] = lArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(lArray, lArray3, n, n2, n5);
        Modification.copy(lArray2, lArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_symmetric_difference(long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(lArray[n], lArray2[n3])) {
                lArray3[n5++] = lArray[n++];
                continue;
            }
            if (binaryPredicate.apply(lArray2[n3], lArray[n])) {
                lArray3[n5++] = lArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(lArray, lArray3, n, n2, n5);
        Modification.copy(lArray2, lArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void push_heap(long[] lArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        long l = lArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && lArray[n3] < l) {
            lArray[n2] = lArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        lArray[n2] = l;
    }

    public static void push_heap(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        long l = lArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && binaryPredicate.apply(lArray[n3], l)) {
            lArray[n2] = lArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        lArray[n2] = l;
    }

    private static void adjust_heap(long[] lArray, int n, int n2, int n3) {
        long l = lArray[n2];
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = 2 * n5 + 2;
        while (n6 < n4) {
            if (lArray[n + n6] < lArray[n + (n6 - 1)]) {
                --n6;
            }
            lArray[n + n5] = lArray[n + n6];
            n5 = n6++;
            n6 *= 2;
        }
        if (n6-- == n4) {
            lArray[n + n5] = lArray[n + n6];
            n5 = n6;
        }
        int n7 = (n5 - 1) / 2;
        int n8 = n2 - n;
        while (n5 != n8 && lArray[n + n7] < l) {
            lArray[n + n5] = lArray[n + n7];
            n5 = n7;
            n7 = (n5 - 1) / 2;
        }
        lArray[n + n5] = l;
    }

    private static void adjust_heap(long[] lArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        long l = lArray[n2];
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = 2 * n5 + 2;
        while (n6 < n4) {
            if (binaryPredicate.apply(lArray[n + n6], lArray[n + (n6 - 1)])) {
                --n6;
            }
            lArray[n + n5] = lArray[n + n6];
            n5 = n6++;
            n6 *= 2;
        }
        if (n6-- == n4) {
            lArray[n + n5] = lArray[n + n6];
            n5 = n6;
        }
        int n7 = (n5 - 1) / 2;
        int n8 = n2 - n;
        while (n5 != n8 && binaryPredicate.apply(lArray[n + n7], l)) {
            lArray[n + n5] = lArray[n + n7];
            n5 = n7;
            n7 = (n5 - 1) / 2;
        }
        lArray[n + n5] = l;
    }

    public static void pop_heap(long[] lArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        long l = lArray[--n2];
        lArray[n2] = lArray[n];
        lArray[n] = l;
        Sorting.adjust_heap(lArray, n, n, n2);
    }

    public static void pop_heap(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        long l = lArray[--n2];
        lArray[n2] = lArray[n];
        lArray[n] = l;
        Sorting.adjust_heap(lArray, n, n, n2, binaryPredicate);
    }

    public static void make_heap(long[] lArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(lArray, n, n + n3, n2);
        } while (n3-- != 0);
    }

    public static void make_heap(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(lArray, n, n + n3, n2, binaryPredicate);
        } while (n3-- != 0);
    }

    public static void sort_heap(long[] lArray, int n, int n2) {
        while (n2 - n > 1) {
            long l = lArray[--n2];
            lArray[n2] = lArray[n];
            lArray[n] = l;
            Sorting.adjust_heap(lArray, n, n, n2);
        }
    }

    public static void sort_heap(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        while (n2 - n > 1) {
            long l = lArray[--n2];
            lArray[n2] = lArray[n];
            lArray[n] = l;
            Sorting.adjust_heap(lArray, n, n, n2, binaryPredicate);
        }
    }

    public static int max_element(long[] lArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (lArray[n3] >= lArray[n]) continue;
            n3 = n;
        }
        return n3;
    }

    public static int max_element(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(lArray[n3], lArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(long[] lArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (lArray[n] >= lArray[n3]) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(lArray[n], lArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static boolean lexicographical_compare(long[] lArray, long[] lArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (lArray[n] < lArray2[n3]) {
                return true;
            }
            if (lArray2[n3++] >= lArray[n++]) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean lexicographical_compare(long[] lArray, long[] lArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(lArray[n], lArray2[n3])) {
                return true;
            }
            if (!binaryPredicate.apply(lArray2[n3++], lArray[n++])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean next_permutation(long[] lArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (lArray[--n3] >= lArray[n4]) continue;
            int n5 = n2;
            while (lArray[n3] >= lArray[--n5]) {
            }
            long l = lArray[n3];
            lArray[n3] = lArray[n5];
            lArray[n5] = l;
            Modification.reverse(lArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(lArray, n, n2);
        return false;
    }

    public static boolean next_permutation(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(lArray[--n3], lArray[n4])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(lArray[n3], lArray[--n5])) {
            }
            long l = lArray[n3];
            lArray[n3] = lArray[n5];
            lArray[n5] = l;
            Modification.reverse(lArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(lArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(long[] lArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (lArray[n4] >= lArray[--n3]) continue;
            int n5 = n2;
            while (lArray[--n5] >= lArray[n3]) {
            }
            long l = lArray[n3];
            lArray[n3] = lArray[n5];
            lArray[n5] = l;
            Modification.reverse(lArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(lArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(lArray[n4], lArray[--n3])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(lArray[--n5], lArray[n3])) {
            }
            long l = lArray[n3];
            lArray[n3] = lArray[n5];
            lArray[n5] = l;
            Modification.reverse(lArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(lArray, n, n2);
        return false;
    }

    private Sorting() {
    }
}

