/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameList;
import org.eso.cpl.FrameType;
import org.eso.cpl.NamingScheme;
import org.eso.cpl.Parameter;
import org.eso.cpl.Recipe;
import org.eso.cpl.Request;
import org.eso.cpl.gui.ExecutionEvent;
import org.eso.cpl.gui.ExecutionListener;
import org.eso.cpl.jni.CPLControl;
import org.eso.cpl.jni.MessageListener;

public class RequestExecutor
implements MessageListener {
    private List executionListeners_ = new ArrayList();
    private boolean errorMessageRecorded;

    public void addExecutionListener(ExecutionListener listener) {
        this.executionListeners_.add(listener);
    }

    public void removeExecutionListener(ExecutionListener listener) {
        this.executionListeners_.remove(listener);
    }

    public void execute(Request request) {
        ExecutionEvent endEvt;
        Recipe recipe = request.getRecipe();
        Parameter[] params = request.getParameters();
        FrameList inFrames = request.getInputFrames().selectActive();
        File productRoot = request.getProductRoot();
        if (recipe == null) {
            request.setState(3);
            throw new IllegalStateException("No recipe");
        }
        if (params == null) {
            request.setState(3);
            throw new IllegalStateException("No parameters");
        }
        if (inFrames == null) {
            request.setState(3);
            throw new IllegalStateException("No input frames");
        }
        request.setState(1);
        final ExecutionEvent startEvt = new ExecutionEvent(this, request, null, ExecutionEvent.Status.STARTED, null);
        boolean inEventThread = SwingUtilities.isEventDispatchThread();
        try {
            if (inEventThread) {
                this.fireExecutionStarted(startEvt);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        RequestExecutor.this.fireExecutionStarted(startEvt);
                    }
                });
            }
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        catch (InvocationTargetException e3) {
            e3.printStackTrace();
        }
        this.errorMessageRecorded = false;
        CPLControl.addMessageListener(this);
        try {
            FrameList outFrames = recipe.execute(params, inFrames, productRoot);
            endEvt = new ExecutionEvent(this, request, outFrames, ExecutionEvent.Status.SUCCESS, null);
            NamingScheme namer = request.getNamingScheme();
            Iterator it = outFrames.iterator();
            while (it.hasNext()) {
                this.renameFrame((Frame)it.next(), namer);
            }
            request.setState(2);
        }
        catch (Throwable e4) {
            request.setState(3);
            endEvt = new ExecutionEvent(this, request, null, ExecutionEvent.Status.FAILURE, e4);
        }
        CPLControl.removeMessageListener(this);
        final ExecutionEvent endEvt1 = endEvt;
        try {
            if (inEventThread) {
                this.fireExecutionEnded(startEvt);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        RequestExecutor.this.fireExecutionEnded(endEvt1);
                    }
                });
            }
        }
        catch (InterruptedException e5) {
            e5.printStackTrace();
        }
        catch (InvocationTargetException e6) {
            e6.printStackTrace();
        }
    }

    private void renameFrame(Frame frm, NamingScheme namer) throws Exception {
        File file1;
        File file2 = file1 = frm.getFile();
        int extidx = file1.getName().lastIndexOf(".");
        if (extidx < 0 || file1.getName().length() - extidx > 6) {
            String ext = "";
            if (frm.getType() == FrameType.TABLE) {
                ext = ".tfits";
            } else if (frm.getType() == FrameType.IMAGE) {
                ext = ".fits";
            }
            System.out.println("Product frame (proposed ext: " + ext + "): " + frm.toString());
            file2 = new File(file1.getPath() + ext);
        } else {
            System.out.println("Product frame with ext: " + frm.toString());
        }
        if (namer != null) {
            file2 = namer.transform(file2);
        }
        if (!file1.equals(file2) && !file1.renameTo(file2)) {
            throw new Exception("Failed to rename product " + file1.getPath() + " to " + file2.getPath());
        }
        file2 = file2.getAbsoluteFile();
        frm.setFile(file2);
    }

    private void fireExecutionEnded(ExecutionEvent evt) {
        for (ExecutionListener listener : this.executionListeners_) {
            listener.executionEnded(evt);
        }
    }

    private void fireExecutionStarted(ExecutionEvent evt) {
        for (ExecutionListener listener : this.executionListeners_) {
            listener.executionStarted(evt);
        }
    }

    @Override
    public void logMessage(String domain, String msg, int flags) {
    }

    @Override
    public void outMessage(String msg) {
    }

    @Override
    public void errMessage(String msg) {
        this.errorMessageRecorded = true;
    }
}

