/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.jni;

import java.util.ArrayList;
import java.util.List;
import org.eso.cpl.CPLException;
import org.eso.cpl.jni.MessageListener;

public class CPLControl {
    public static final String NATIVE_LIBRARY = "cplgasgano";
    public static final String JAVACPL_VERSION = "1.0";
    static final Object LOCK = new Object();
    private static List messageListeners_ = new ArrayList();

    public static void ensureSetup() {
    }

    public static void addMessageListener(MessageListener listener) {
        messageListeners_.add(listener);
    }

    public static void removeMessageListener(MessageListener listener) {
        messageListeners_.remove(listener);
    }

    private static void outMessage(String msg) {
        for (MessageListener listener : messageListeners_) {
            listener.outMessage(msg);
        }
    }

    private static void errMessage(String msg) {
        for (MessageListener listener : messageListeners_) {
            listener.errMessage(msg);
        }
    }

    private static void logMessage(String domain, String msg, int flags) {
        for (MessageListener listener : messageListeners_) {
            listener.logMessage(domain, msg, flags);
        }
    }

    private static native void nativeEnsureSetup() throws CPLException;

    private static native String nativeGetVersion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = LOCK;
        synchronized (object) {
            System.loadLibrary(NATIVE_LIBRARY);
            try {
                CPLControl.nativeEnsureSetup();
            }
            catch (CPLException e2) {
                System.err.println("Fatal error. Cannot ensure setup: " + e2.getMessage() + "\nExecution terminated.");
                System.exit(1);
            }
            String nativeVersion = CPLControl.nativeGetVersion();
            if (!JAVACPL_VERSION.equals(nativeVersion)) {
                System.err.println("Fatal error. Version mismatch: java version = 1.0, native version = " + nativeVersion + "." + "\nExecution terminated.");
                System.exit(1);
            }
        }
    }
}

