/*
 * Decompiled with CFR 0.152.
 */
package org.eso.dfs.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.eso.dfs.gui.RecallingComboBox;
import org.eso.dfs.gui.SharedListComboBoxModel;
import org.eso.dfs.util.SharedList;

public class RecallingComboBoxDemo
extends JPanel
implements ActionListener {
    private JLabel result;

    public RecallingComboBoxDemo() {
        this.setLayout(new BoxLayout(this, 3));
        RecallingComboBox comboBox1 = new RecallingComboBox(false, 10);
        RecallingComboBox comboBox2 = new RecallingComboBox(true, 5);
        comboBox1.addActionListener(this);
        comboBox2.addActionListener(this);
        SharedList sharedList = new SharedList();
        sharedList.setMaxCapacity(10);
        sharedList.setSortList(true);
        RecallingComboBox comboBox3 = new RecallingComboBox(new SharedListComboBoxModel(sharedList));
        RecallingComboBox comboBox4 = new RecallingComboBox(new SharedListComboBoxModel(sharedList));
        comboBox3.addActionListener(this);
        comboBox4.addActionListener(this);
        JLabel resultLabel = new JLabel("Current Selection", 10);
        this.result = new JLabel(" ");
        this.result.setForeground(Color.black);
        this.result.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(new JLabel("Enter something new or select one from the list:"));
        panel.add(new JLabel("         "));
        panel.add(new JLabel("Standard RecallingComboBox (max capacity 10):"));
        comboBox1.setAlignmentX(0.0f);
        panel.add(comboBox1);
        panel.add(new JLabel("         "));
        panel.add(new JLabel("Sorted RecallingComboBox (max capacity 5):"));
        comboBox2.setAlignmentX(0.0f);
        panel.add(comboBox2);
        panel.add(new JLabel("         "));
        panel.add(new JLabel("Shared, sorted RecallingComboBox (1 of 2):"));
        comboBox3.setAlignmentX(0.0f);
        panel.add(comboBox3);
        panel.add(new JLabel("         "));
        panel.add(new JLabel("Shared, sorted RecallingComboBox (2 of 2):"));
        comboBox4.setAlignmentX(0.0f);
        panel.add(comboBox4);
        JPanel resultPanel = new JPanel(new GridLayout(0, 1));
        resultPanel.add(resultLabel);
        resultPanel.add(this.result);
        panel.setAlignmentX(0.0f);
        resultPanel.setAlignmentX(0.0f);
        this.add(panel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(resultPanel);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.newEntry(" ");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        JComboBox cb = (JComboBox)e2.getSource();
        if (cb.getSelectedIndex() > -1) {
            String newSelection = cb.getSelectedItem().toString();
            this.newEntry(newSelection);
        }
    }

    public void newEntry(String entry) {
        this.result.setText(entry);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("RecallingComboBoxDemo");
        frame.setDefaultCloseOperation(3);
        RecallingComboBoxDemo newContentPane = new RecallingComboBoxDemo();
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RecallingComboBoxDemo.createAndShowGUI();
            }
        });
    }
}

