/*
 * Decompiled with CFR 0.152.
 */
package org.eso.dfs.services.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eso.dfs.services.ServiceException;
import org.eso.dfs.services.data.AssociationHandler;
import org.eso.dfs.services.data.AssociationNode;

public class AssociationService {
    private List handlerChain = new ArrayList();
    private static AssociationService instance;

    private AssociationService() {
    }

    public static synchronized AssociationService getInstance() {
        if (instance == null) {
            instance = new AssociationService();
        }
        return instance;
    }

    public void processNodes(AssociationNode[] nodes) throws ServiceException {
        Iterator i = this.handlerChain.iterator();
        StringBuffer errorReport = new StringBuffer();
        while (i.hasNext()) {
            AssociationHandler h = (AssociationHandler)i.next();
            try {
                h.processNodes(nodes);
            }
            catch (ServiceException e2) {
                errorReport.append(e2.toString() + "\n");
            }
        }
        if (errorReport.length() > 0) {
            throw new ServiceException(errorReport.toString());
        }
    }

    public void addFiles(File[] files) throws ServiceException {
        Iterator i = this.handlerChain.iterator();
        StringBuffer errorReport = new StringBuffer();
        while (i.hasNext()) {
            AssociationHandler h = (AssociationHandler)i.next();
            try {
                h.addFiles(files);
            }
            catch (ServiceException e2) {
                errorReport.append(e2.toString() + "\n");
            }
        }
        if (errorReport.length() > 0) {
            throw new ServiceException(errorReport.toString());
        }
    }

    public void removeFiles(File[] files) throws ServiceException {
        Iterator i = this.handlerChain.iterator();
        StringBuffer errorReport = new StringBuffer();
        while (i.hasNext()) {
            AssociationHandler h = (AssociationHandler)i.next();
            h.removeFiles(files);
        }
    }

    public void addAssociationHandler(AssociationHandler h) {
        this.removeAssociationHandler(h);
        this.handlerChain.add(h);
    }

    public void removeAssociationHandler(AssociationHandler h) {
        this.handlerChain.remove(h);
    }
}

