/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.eso.dfs.services.data.AssociationService;
import org.eso.gasgano.GasganoDisplay;
import org.eso.gasgano.datamodel.BasicFileDescription;
import org.eso.gasgano.datamodel.BasicObservationDescription;
import org.eso.gasgano.datamodel.BasicProgramDescription;
import org.eso.gasgano.datamodel.ObsStatusDescription;
import org.eso.gasgano.datamodel.ResultsModel;
import org.eso.gasgano.datamodel.database.DBDataModel;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.filesystem.FitsFile;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.gui.GUIUtils;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.properties.GasProp;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.oca.parser.ParseException;

public class Gasgano {
    public static final String VERSION = "GASGANO Version: 2.4.8";
    private DFSDataModel dataModel = null;
    private DBDataModel dbDataModel = null;
    private ResultsModel resultsModel = null;
    private GasganoDisplay gDisplay = null;
    private String userName = null;
    private String osName = null;
    private String userHome = null;
    private boolean safeEnvironment = false;

    public void printUsageAndExit() {
        System.out.println(VERSION);
        System.exit(0);
    }

    private void analyzeProperties() {
        int debugLevel = 0;
        try {
            debugLevel = Integer.parseInt(PropertyDB.getInstance().getProperty("VERBOSE_LEVEL"));
        }
        catch (Exception e2) {
            debugLevel = 0;
        }
        PropertyDB.getInstance().setDebugLevel(debugLevel);
        if (PropertyDB.getInstance().getProperty("SHORT_FILENAME").toString().equals("true")) {
            OBComponent.setShortName(true);
        } else {
            OBComponent.setShortName(false);
        }
        if (PropertyDB.getInstance().getProperty("RADEC_CONVERSION").equals("true")) {
            FitsFile.setRadecConversion(true);
        } else {
            FitsFile.setRadecConversion(false);
        }
        if (this.safeEnvironment) {
            if (PropertyDB.getInstance().getProperty("OB_STATUS_FROM_DB_REQUIRED").equals("true")) {
                ObsStatusDescription obsDesc = new ObsStatusDescription();
                obsDesc.setPasswordSource(this.gDisplay.getPasswordSource());
                this.dataModel.setDefaultObservationDescription(obsDesc);
            }
            if (PropertyDB.getInstance().getProperty("DBOBS_REQUIRED").equals("true")) {
                this.dbDataModel.setPasswordSource(this.gDisplay.getPasswordSource());
            }
        } else {
            this.dataModel.setDefaultObservationDescription(new BasicObservationDescription());
        }
    }

    public Gasgano(String[] args) {
        int i;
        Object ruleTable = null;
        GasProp properties = null;
        StringBuffer windowTitle = new StringBuffer(VERSION);
        String ruleFile = null;
        String prefFilePath = null;
        Vector displayCols = null;
        Keyword[] cols = null;
        JFrame silentFrame = new JFrame();
        this.userName = System.getProperties().getProperty("user.name");
        this.userHome = System.getProperties().getProperty("user.home");
        this.osName = System.getProperties().getProperty("os.name");
        prefFilePath = this.userHome.concat(File.separator + ".gasganorc");
        if (this.userName != null) {
            windowTitle.append(" " + this.userName);
        }
        if (this.osName != null) {
            windowTitle.append(" / " + this.osName);
        }
        GasProp.setEnvironmentUnsafe();
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-v")) {
                this.printUsageAndExit();
                continue;
            }
            prefFilePath = args[i2];
        }
        properties = new GasProp();
        File propertiesFile = new File(prefFilePath);
        if (propertiesFile.exists()) {
            if (!properties.loadProperties(prefFilePath)) {
                GUIUtils.userMessage(silentFrame, "File " + prefFilePath + "\n" + "is not a valid preferences file or cannot be loaded.\n" + "Please check file type and access permissions.\n\n" + "Loading aborted.");
                System.exit(1);
            }
        } else {
            GUIUtils.userMessage(silentFrame, "Preferences file " + prefFilePath + " does not exist.\n" + "Creating " + prefFilePath + " with default values.");
            if (!properties.saveProperties(prefFilePath)) {
                GUIUtils.userMessage(silentFrame, "Failed to save preferences file " + prefFilePath + "\n" + "Please check path and directory access permissions.");
                System.exit(2);
            }
        }
        GasProp.setProperties(properties);
        this.safeEnvironment = GasProp.isEnvironmentSafe();
        this.dataModel = DFSDataModel.getDataModel();
        AssociationService.getInstance().addAssociationHandler(this.dataModel);
        if (this.safeEnvironment) {
            this.dbDataModel = new DBDataModel();
        }
        this.resultsModel = new ResultsModel();
        ruleFile = PropertyDB.getInstance().getProperty("CLASSRULE_FILE");
        if (System.getProperty("os.name").equals("HP-UX")) {
            try {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            catch (UnsupportedLookAndFeelException e2) {
                System.out.println("Exception: " + e2);
            }
            catch (ClassNotFoundException e3) {
                System.out.println("Exception: " + e3);
            }
            catch (InstantiationException e4) {
                System.out.println("Exception: " + e4);
            }
            catch (IllegalAccessException e5) {
                System.out.println("Exception: " + e5);
            }
        }
        try {
            this.dataModel.setClassifier(DFSDataModel.createClassifier(new FileInputStream(ruleFile)));
        }
        catch (FileNotFoundException e6) {
            GUIUtils.userMessage(silentFrame, "Unable to access rules file [" + ruleFile + "].\n" + e6.getMessage());
        }
        catch (ParseException e7) {
            GUIUtils.userError(silentFrame, "Rule file [" + ruleFile + "] contains errors: \n\n" + e7.getMessage() + "\nPlease fix the errors and restart Gasgano.");
            System.exit(1);
        }
        catch (Exception e8) {
            GUIUtils.userMessage(silentFrame, "Unexpected exception while accessing rules file [" + ruleFile + "].\n" + e8.getMessage());
        }
        catch (Error e9) {
            GUIUtils.userMessage(silentFrame, "Unexpected error while accessing rules file [" + ruleFile + "].\n" + e9.getMessage());
        }
        this.dataModel.setDefaultProgramDescription(new BasicProgramDescription());
        displayCols = GasProp.getProperties().fsDisplayColumns;
        cols = new Keyword[displayCols.size()];
        for (i = 0; i < cols.length; ++i) {
            cols[i] = new Keyword((String)displayCols.elementAt(i), null);
        }
        this.dataModel.setDefaultFileDescription(new BasicFileDescription(cols));
        if (this.safeEnvironment) {
            displayCols = GasProp.getProperties().dbDisplayColumns;
            cols = new Keyword[displayCols.size()];
            for (i = 0; i < cols.length; ++i) {
                cols[i] = new Keyword((String)displayCols.elementAt(i), null);
            }
            this.dbDataModel.setDefaultFileDescription(new BasicFileDescription(cols));
        }
        this.dataModel.update();
        this.gDisplay = new GasganoDisplay(windowTitle.toString(), this.dataModel, this.dbDataModel, this.resultsModel);
        GasProp.addChangeListener(this.gDisplay);
        this.analyzeProperties();
        this.gDisplay.initializeFileSelections();
    }

    public static void main(String[] args) {
        Gasgano g = new Gasgano(args);
    }
}

